/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSFileListener
extends VcsVFSListener {
    public static final Logger logger = LoggerFactory.getLogger(TFSFileListener.class);

    public TFSFileListener(Project project, TFSVcs vcs) {
        super(project, (AbstractVcs)vcs);
    }

    protected String getAddTitle() {
        return TfPluginBundle.message("Tfvc.Add.Items", new Object[0]);
    }

    protected String getSingleFileAddTitle() {
        return TfPluginBundle.message("Tfvc.Add.Item", new Object[0]);
    }

    protected String getSingleFileAddPromptTemplate() {
        return TfPluginBundle.message("Tfvc.Add.Prompt", "{0}");
    }

    protected void executeAdd() {
        logger.info("executeAdd executing...");
        try {
            final List<String> filePaths = TfsFileUtil.getFilePathStrings(this.myAddedFiles);
            final ArrayList pendingChanges = new ArrayList();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                    pendingChanges.addAll(CommandUtils.getStatusForFiles((ServerContext)TFSVcs.getInstance(TFSFileListener.this.myProject).getServerContext(true), (List)filePaths));
                }
            }, TfPluginBundle.message("Tfvc.Add.Scheduling", new Object[0]), false, this.myProject);
            for (PendingChange pendingChange : pendingChanges) {
                StatusProvider.visitByStatus(new StatusVisitor(){

                    @Override
                    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(1);
                        }
                    }

                    @Override
                    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(3);
                        }
                    }

                    @Override
                    public void locked(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(4);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(5);
                        }
                    }

                    @Override
                    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(6);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(7);
                        }
                        TFSFileListener.this.myAddedFiles.remove(localPath.getVirtualFile());
                    }

                    @Override
                    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(8);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(9);
                        }
                    }

                    @Override
                    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(10);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(11);
                        }
                    }

                    @Override
                    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(12);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(13);
                        }
                    }

                    @Override
                    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            2.$$$reportNull$$$0(14);
                        }
                        if (serverStatus == null) {
                            2.$$$reportNull$$$0(15);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "localPath";
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 5: 
                            case 7: 
                            case 9: 
                            case 11: 
                            case 13: 
                            case 15: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "serverStatus";
                                break;
                            }
                        }
                        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSFileListener$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "unversioned";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "checkedOutForEdit";
                                break;
                            }
                            case 4: 
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "locked";
                                break;
                            }
                            case 6: 
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "scheduledForAddition";
                                break;
                            }
                            case 8: 
                            case 9: {
                                objectArray = objectArray2;
                                objectArray2[2] = "scheduledForDeletion";
                                break;
                            }
                            case 10: 
                            case 11: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renamed";
                                break;
                            }
                            case 12: 
                            case 13: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renamedCheckedOut";
                                break;
                            }
                            case 14: 
                            case 15: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undeleted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, pendingChange);
            }
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException((Throwable)e), "TFVC");
        }
        if (!this.myAddedFiles.isEmpty()) {
            super.executeAdd();
        }
    }

    protected void performDeletion(List<FilePath> filesToDelete) {
    }

    protected void executeDelete() {
    }

    protected void performAdding(final Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        final ArrayList errors = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                errors.addAll(TFSVcs.getInstance(TFSFileListener.this.myProject).getCheckinEnvironment().scheduleUnversionedFilesForAddition(new ArrayList(addedFiles)));
            }
        }, TfPluginBundle.message("Tfvc.Add.Progress", new Object[0]), false, this.myProject);
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(errors, "TFVC");
        }
    }

    protected String getDeleteTitle() {
        return "";
    }

    protected String getSingleFileDeleteTitle() {
        return null;
    }

    protected String getSingleFileDeletePromptTemplate() {
        return null;
    }

    protected void performMoveRename(List<VcsVFSListener.MovedFileInfo> movedFiles) {
        ArrayList errors = new ArrayList();
        ArrayList<FilePath> invalidate = new ArrayList<FilePath>(movedFiles.size());
        for (VcsVFSListener.MovedFileInfo info : movedFiles) {
            invalidate.add(VcsUtil.getFilePath((String)info.myOldPath));
        }
        TfsFileUtil.markDirtyRecursively(this.myProject, invalidate);
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(errors, "TFVC");
        }
    }

    protected boolean isDirectoryVersioningSupported() {
        return true;
    }
}

