/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.ServerStatus;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.StatusVisitor;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSFileSystemListener
implements LocalFileOperationsHandler,
Disposable {
    public static final Logger logger = LoggerFactory.getLogger(TFSFileSystemListener.class);

    public TFSFileSystemListener() {
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    public void dispose() {
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this);
    }

    public boolean delete(VirtualFile virtualFile) throws IOException {
        TFSVcs vcs = VcsHelper.getTFSVcsByPath(virtualFile);
        if (vcs == null) {
            logger.info("Not a TFVC project so not doing a TFVC delete");
            return false;
        }
        VcsShowConfirmationOption.Value value = vcs.getDeleteConfirmation().getValue();
        if (VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY.equals((Object)value)) {
            logger.info("Don't delete file from TFVC: " + virtualFile.getPath());
            return false;
        }
        logger.info("Deleting file with TFVC: " + virtualFile.getPath());
        ArrayList pendingChanges = new ArrayList();
        Project currentProject = vcs.getProject();
        pendingChanges.addAll(CommandUtils.getStatusForFiles((ServerContext)vcs.getServerContext(true), Arrays.asList(virtualFile.getPath())));
        if (pendingChanges.isEmpty()) {
            logger.info("No changes to file so deleting though TFVC");
            CommandUtils.deleteFiles((ServerContext)vcs.getServerContext(true), Arrays.asList(virtualFile.getPath()), null, (boolean)true);
            return true;
        }
        final AtomicBoolean revert = new AtomicBoolean(false);
        final AtomicBoolean success = new AtomicBoolean(false);
        final AtomicBoolean isUndelete = new AtomicBoolean(false);
        try {
            for (final PendingChange pendingChange : pendingChanges) {
                StatusProvider.visitByStatus(new StatusVisitor(){

                    @Override
                    public void scheduledForAddition(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        revert.set(true);
                        success.set(false);
                    }

                    @Override
                    public void unversioned(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (pendingChange.getChangeTypes().contains(ServerStatusType.DELETE)) {
                            revert.set(true);
                            success.set(true);
                        }
                    }

                    @Override
                    public void scheduledForDeletion(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        success.set(false);
                    }

                    @Override
                    public void checkedOutForEdit(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(7);
                        }
                        revert.set(true);
                        success.set(true);
                    }

                    @Override
                    public void locked(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(8);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(9);
                        }
                        success.set(false);
                    }

                    @Override
                    public void renamed(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(10);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(11);
                        }
                        revert.set(true);
                        success.set(true);
                    }

                    @Override
                    public void renamedCheckedOut(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(12);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(13);
                        }
                        revert.set(true);
                        success.set(true);
                    }

                    @Override
                    public void undeleted(@NotNull FilePath localPath, boolean localItemExists, @NotNull ServerStatus serverStatus) throws TfsException {
                        if (localPath == null) {
                            1.$$$reportNull$$$0(14);
                        }
                        if (serverStatus == null) {
                            1.$$$reportNull$$$0(15);
                        }
                        revert.set(true);
                        isUndelete.set(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "localPath";
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 5: 
                            case 7: 
                            case 9: 
                            case 11: 
                            case 13: 
                            case 15: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "serverStatus";
                                break;
                            }
                        }
                        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSFileSystemListener$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "scheduledForAddition";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "unversioned";
                                break;
                            }
                            case 4: 
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "scheduledForDeletion";
                                break;
                            }
                            case 6: 
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "checkedOutForEdit";
                                break;
                            }
                            case 8: 
                            case 9: {
                                objectArray = objectArray2;
                                objectArray2[2] = "locked";
                                break;
                            }
                            case 10: 
                            case 11: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renamed";
                                break;
                            }
                            case 12: 
                            case 13: {
                                objectArray = objectArray2;
                                objectArray2[2] = "renamedCheckedOut";
                                break;
                            }
                            case 14: 
                            case 15: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undeleted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, pendingChange);
            }
        }
        catch (TfsException e) {
            logger.warn("Error while checking delete candidate's pending changes");
            AbstractVcsHelper.getInstance((Project)currentProject).showError(new VcsException((Throwable)e), "TFVC");
        }
        if (revert.get()) {
            logger.info("Reverting pending changes for delete candidate");
            CommandUtils.undoLocalFiles((ServerContext)vcs.getServerContext(true), Arrays.asList(virtualFile.getPath()));
        }
        if (success.get() && !isUndelete.get()) {
            logger.info("Deleting file with TFVC after undoing pending changes");
            String filePath = StringUtils.isNotEmpty((String)((PendingChange)pendingChanges.get(0)).getSourceItem()) ? ((PendingChange)pendingChanges.get(0)).getSourceItem() : ((PendingChange)pendingChanges.get(0)).getLocalItem();
            CommandUtils.deleteFiles((ServerContext)vcs.getServerContext(true), Arrays.asList(filePath), (String)((PendingChange)pendingChanges.get(0)).getWorkspace(), (boolean)true);
        }
        logger.info("File was deleted using TFVC: " + success.get());
        return success.get();
    }

    public boolean move(VirtualFile virtualFile, VirtualFile toDirectory) throws IOException {
        logger.info(String.format("Moving file %s to %s", virtualFile.getPath(), toDirectory.getPath()));
        return this.renameOrMove(virtualFile, Path.combine((String)toDirectory.getPath(), (String)virtualFile.getName()));
    }

    @Nullable
    public File copy(VirtualFile virtualFile, VirtualFile virtualFile1, String s) throws IOException {
        return null;
    }

    public boolean rename(VirtualFile virtualFile, String s) throws IOException {
        logger.info(String.format("Renaming file %s to %s", virtualFile.getName(), s));
        return this.renameOrMove(virtualFile, Path.combine((String)virtualFile.getParent().getPath(), (String)s));
    }

    public boolean createFile(VirtualFile virtualFile, String s) throws IOException {
        return false;
    }

    public boolean createDirectory(VirtualFile virtualFile, String s) throws IOException {
        return false;
    }

    public void afterDone(ThrowableConsumer<LocalFileOperationsHandler, IOException> throwableConsumer) {
    }

    private boolean renameOrMove(VirtualFile oldFile, String newPath) throws IOException {
        TFSVcs vcs = VcsHelper.getTFSVcsByPath(oldFile);
        if (vcs == null) {
            logger.info("Not a TFVC project so not doing a TFVC rename/move");
            return false;
        }
        Project currentProject = vcs.getProject();
        String oldPath = oldFile.getPath();
        try {
            ArrayList pendingChanges = new ArrayList(2);
            pendingChanges.addAll(CommandUtils.getStatusForFiles((ServerContext)vcs.getServerContext(true), (List)ImmutableList.of((Object)oldPath)));
            if (pendingChanges.size() == 1 && ((PendingChange)pendingChanges.get(0)).isCandidate() && ((PendingChange)pendingChanges.get(0)).getChangeTypes().contains(ServerStatusType.ADD)) {
                logger.info("Renaming unversioned file thru file system");
                return false;
            }
            logger.info("Renaming file thru tf commandline");
            CommandUtils.renameFile((ServerContext)vcs.getServerContext(true), (String)oldPath, (String)newPath);
            return true;
        }
        catch (Throwable t) {
            logger.warn("renameOrMove experienced a failure while trying to rename a file", t);
            throw new IOException(t);
        }
    }
}

