/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSRollbackEnvironment
extends DefaultRollbackEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(TFSRollbackEnvironment.class);
    private final Project project;
    private final TFSVcs vcs;

    public TFSRollbackEnvironment(@NotNull TFSVcs vcs, @NotNull Project project) {
        if (vcs == null) {
            TFSRollbackEnvironment.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TFSRollbackEnvironment.$$$reportNull$$$0(1);
        }
        logger.info("Initializing TFSRollbackEnvironment");
        this.vcs = vcs;
        this.project = project;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            TFSRollbackEnvironment.$$$reportNull$$$0(2);
        }
        logger.info("rollbackChanges started");
        ArrayList<FilePath> localPaths = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            ContentRevision revision = change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
            localPaths.add(revision.getFile());
        }
        this.undoPendingChanges(localPaths, vcsExceptions, listener);
        logger.info("rollbackChanges ended");
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, List<VcsException> errors, RollbackProgressListener listener) {
        logger.info("rollbackMissingFileDeletion started");
        for (FilePath file : files) {
            try {
                CommandUtils.forceGetFile((ServerContext)this.vcs.getServerContext(false), (String)file.getPath());
            }
            catch (Throwable t) {
                logger.warn("Exception hit while rolling back deleted file: " + file.getPath(), t);
                errors.add(new VcsException(t.getMessage(), t));
            }
        }
        logger.info("rollbackMissingFileDeletion ended");
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> errors, RollbackProgressListener listener) {
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    private void undoPendingChanges(List<FilePath> localPaths, List<VcsException> errors, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            TFSRollbackEnvironment.$$$reportNull$$$0(3);
        }
        logger.info("undoPendingChanges started");
        try {
            ArrayList<String> localFiles = new ArrayList<String>(localPaths.size());
            for (FilePath path : localPaths) {
                localFiles.add(path.getPath());
            }
            ServerContext context = this.vcs.getServerContext(false);
            List filesUndone = CommandUtils.undoLocalFiles((ServerContext)context, localFiles);
            ArrayList<VirtualFile> refresh = new ArrayList<VirtualFile>(filesUndone.size());
            for (String path : filesUndone) {
                File fileUndone = new File(path);
                listener.accept(fileUndone);
                VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(fileUndone);
                VirtualFile parent = file != null ? file.getParent() : null;
                if (parent == null || !parent.exists()) continue;
                refresh.add(file);
            }
            TfsFileUtil.refreshAndMarkDirty(this.project, refresh, true);
        }
        catch (Throwable e) {
            logger.warn("undoPendingChanges: Errors caught: " + e.getMessage(), e);
            errors.add(new VcsException("Cannot undo pending changes", e));
        }
        logger.info("undoPendingChanges ended");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSRollbackEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "undoPendingChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

