/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.external.exceptions.SyncException;
import com.microsoft.alm.plugin.external.exceptions.ToolException;
import com.microsoft.alm.plugin.external.tools.TfTool;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSChangeList;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSChangeProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSCheckinEnvironment;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSCommittedChangesProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSDiffProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSFileListener;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSFileSystemListener;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSHistoryProvider;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSProjectConfigurable;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSRollbackEnvironment;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSUpdateEnvironment;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsRevisionNumber;
import javax.swing.event.HyperlinkEvent;
import javax.ws.rs.NotAuthorizedException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSVcs
extends AbstractVcs {
    public static final Logger logger = LoggerFactory.getLogger(TFSVcs.class);
    private static boolean hasVersionBeenVerified = false;
    @NonNls
    public static final String TFVC_NAME = "TFVC";
    public static final String TFVC_ONLINE_HELP_URL = "http://java.visualstudio.com/Docs/tools/intelliJ#_tfvc-support-preview";
    public static final String SETTINGS_URL_EVENT = "settings";
    private static final VcsKey ourKey = TFSVcs.createKey((String)"TFVC");
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private final VcsShowSettingOption myCheckoutOptions;
    private VcsHistoryProvider myHistoryProvider;
    private DiffProvider myDiffProvider;
    private TFSCheckinEnvironment myCheckinEnvironment;
    private UpdateEnvironment myUpdateEnvironment;
    private VcsVFSListener fileListener;
    private TFSFileSystemListener tfsFileSystemListener;
    private CommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> committedChangesProvider;

    public TFSVcs(@NotNull Project project) {
        if (project == null) {
            TFSVcs.$$$reportNull$$$0(0);
        }
        super(project, TFVC_NAME);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
    }

    public static TFSVcs getInstance(Project project) {
        return (TFSVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(TFVC_NAME);
    }

    @NonNls
    public String getDisplayName() {
        return TFVC_NAME;
    }

    public Configurable getConfigurable() {
        return new TFSProjectConfigurable(this.myProject);
    }

    public void activate() {
        this.fileListener = new TFSFileListener(this.getProject(), this);
        if (this.tfsFileSystemListener == null) {
            this.tfsFileSystemListener = new TFSFileSystemListener();
        }
        this.checkCommandLineVersion();
    }

    public void deactivate() {
        Disposer.dispose((Disposable)this.fileListener);
        this.tfsFileSystemListener.dispose();
        this.tfsFileSystemListener = null;
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public ChangeProvider getChangeProvider() {
        return new TFSChangeProvider(this.myProject);
    }

    @NotNull
    public TFSCheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new TFSCheckinEnvironment(this);
        }
        TFSCheckinEnvironment tFSCheckinEnvironment = this.myCheckinEnvironment;
        if (tFSCheckinEnvironment == null) {
            TFSVcs.$$$reportNull$$$0(1);
        }
        return tFSCheckinEnvironment;
    }

    @NotNull
    public UpdateEnvironment createUpdateEnvironment() {
        if (this.myUpdateEnvironment == null) {
            this.myUpdateEnvironment = new TFSUpdateEnvironment(this);
        }
        UpdateEnvironment updateEnvironment = this.myUpdateEnvironment;
        if (updateEnvironment == null) {
            TFSVcs.$$$reportNull$$$0(2);
        }
        return updateEnvironment;
    }

    public RollbackEnvironment createRollbackEnvironment() {
        return new TFSRollbackEnvironment(this, this.myProject);
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        return this.isVersionedDirectory(filePath.getVirtualFile());
    }

    @NotNull
    public CommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.committedChangesProvider == null) {
            this.committedChangesProvider = new TFSCommittedChangesProvider(this.myProject);
        }
        CommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> committedChangesProvider = this.committedChangesProvider;
        if (committedChangesProvider == null) {
            TFSVcs.$$$reportNull$$$0(3);
        }
        return committedChangesProvider;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        if (this.myHistoryProvider == null) {
            this.myHistoryProvider = new TFSHistoryProvider(this.myProject);
        }
        return this.myHistoryProvider;
    }

    public DiffProvider getDiffProvider() {
        if (this.myDiffProvider == null) {
            this.myDiffProvider = new TFSDiffProvider(this.myProject);
        }
        return this.myDiffProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        return TfsRevisionNumber.tryParse(revisionNumberString);
    }

    @Nullable
    public String getRevisionPattern() {
        return "\\d+";
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public static boolean isUnderTFS(FilePath path, Project project) {
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)path);
        return vcs != null && TFVC_NAME.equals(vcs.getName());
    }

    public static VcsException convertToVcsException(Throwable throwable) {
        if (throwable instanceof VcsException) {
            return (VcsException)throwable;
        }
        VcsException exception = new VcsException(throwable.getMessage(), throwable);
        if (throwable instanceof SyncException) {
            exception.setIsWarning(((SyncException)throwable).isWarning());
        }
        return exception;
    }

    public CheckoutProvider getCheckoutProvider() {
        return null;
    }

    public ServerContext getServerContext(boolean throwIfNotFound) {
        ServerContext serverContext;
        RepositoryContext repositoryContext = VcsHelper.getRepositoryContext(this.getProject());
        logger.info("TFSVcs.getServerContext repositoryContext is null: " + (repositoryContext == null));
        ServerContext serverContext2 = serverContext = repositoryContext != null && StringUtils.isNotEmpty((String)repositoryContext.getTeamProjectName()) && StringUtils.isNotEmpty((String)repositoryContext.getUrl()) ? ServerContextManager.getInstance().createContextFromTfvcServerUrl(repositoryContext.getUrl(), repositoryContext.getTeamProjectName(), true) : null;
        if (serverContext == null && throwIfNotFound) {
            throw new NotAuthorizedException((Object)(repositoryContext != null ? repositoryContext.getUrl() : ""), new Object[0]);
        }
        return serverContext;
    }

    private void checkCommandLineVersion() {
        if (hasVersionBeenVerified) {
            logger.info("Skipping the attempt to check the version of the TF command line.");
            return;
        }
        hasVersionBeenVerified = true;
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                final SettableFuture versionMessage = SettableFuture.create();
                new Task.Backgroundable(TFSVcs.this.getProject(), TfPluginBundle.message("Tfvc.tf.VersionWarning.Progress", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            logger.info("Attempting to check the version of the TF command line.");
                            TfTool.checkVersion();
                            versionMessage.set((Object)"");
                        }
                        catch (ToolException ex) {
                            String error = LocalizationServiceImpl.getInstance().getExceptionMessage(ex);
                            logger.warn(error);
                            versionMessage.set((Object)error);
                        }
                        catch (Throwable t) {
                            logger.warn("Unexpected error when checking the version of the command line.", t);
                        }
                    }

                    public void onSuccess() {
                        try {
                            String error = (String)versionMessage.get();
                            if (StringUtils.isNotEmpty((String)error)) {
                                logger.info("Notifying the user of the min version problem.");
                                VcsNotifier.getInstance((Project)this.getProject()).notifyImportantWarning(TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]), error, (NotificationListener)new NotificationListener.Adapter(){

                                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                                        if (notification == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        if (hyperlinkEvent == null) {
                                            1.$$$reportNull$$$0(1);
                                        }
                                        if (TFSVcs.SETTINGS_URL_EVENT.equals(hyperlinkEvent.getDescription())) {
                                            ShowSettingsUtil.getInstance().showSettingsDialog(myProject, TFSVcs.TFVC_NAME);
                                        } else {
                                            BrowserUtil.browse((String)TFSVcs.TFVC_ONLINE_HELP_URL);
                                        }
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        Object[] objectArray;
                                        Object[] objectArray2 = new Object[3];
                                        switch (n) {
                                            default: {
                                                objectArray = objectArray2;
                                                objectArray2[0] = "notification";
                                                break;
                                            }
                                            case 1: {
                                                objectArray = objectArray2;
                                                objectArray2[0] = "hyperlinkEvent";
                                                break;
                                            }
                                        }
                                        objectArray[1] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSVcs$1$1$1";
                                        objectArray[2] = "hyperlinkActivated";
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Failed to warn user about min version of TF command line.", (Throwable)e);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/microsoft/alm/plugin/idea/tfvc/core/TFSVcs$1$1", "run"));
                    }
                }.queue();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/TFSVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckinEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChangesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

