/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.revision;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentStore;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentStoreFactory;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsRevisionNumber;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TFSContentRevision
implements ContentRevision {
    private final Project project;
    @Nullable
    private byte[] myContent;

    protected TFSContentRevision(Project project) {
        this.project = project;
    }

    public abstract int getChangeset();

    protected abstract String getFilePath();

    public static TFSContentRevision create(Project project, final @NotNull FilePath localPath, final int changeset, final String modificationDate) {
        if (localPath == null) {
            TFSContentRevision.$$$reportNull$$$0(0);
        }
        return new TFSContentRevision(project){

            @Override
            public int getChangeset() {
                return changeset;
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = localPath;
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return filePath;
            }

            @Override
            protected String getFilePath() {
                return localPath.getPath();
            }

            public String getModificationDate() {
                return modificationDate;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                TfsRevisionNumber tfsRevisionNumber = new TfsRevisionNumber(changeset, localPath.getName(), modificationDate);
                if (tfsRevisionNumber == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tfsRevisionNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/microsoft/alm/plugin/idea/tfvc/core/revision/TFSContentRevision$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public static TFSContentRevision createRenameRevision(Project project, final @NotNull FilePath orignalPath, final int changeset, final String modificationDate, final String serverPath) {
        if (orignalPath == null) {
            TFSContentRevision.$$$reportNull$$$0(1);
        }
        return new TFSContentRevision(project){

            @Override
            public int getChangeset() {
                return changeset;
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = orignalPath;
                if (filePath == null) {
                    2.$$$reportNull$$$0(0);
                }
                return filePath;
            }

            @Override
            protected String getFilePath() {
                return serverPath;
            }

            public String getModificationDate() {
                return modificationDate;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                TfsRevisionNumber tfsRevisionNumber = new TfsRevisionNumber(changeset, orignalPath.getName(), modificationDate);
                if (tfsRevisionNumber == null) {
                    2.$$$reportNull$$$0(1);
                }
                return tfsRevisionNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/microsoft/alm/plugin/idea/tfvc/core/revision/TFSContentRevision$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public String getContent() throws VcsException {
        return new String(this.doGetContent(), this.getFile().getCharset(this.project));
    }

    @Nullable
    public byte[] doGetContent() throws VcsException {
        if (this.myContent == null) {
            try {
                this.myContent = this.loadContent();
            }
            catch (TfsException e) {
                throw new VcsException((Throwable)e);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
        return this.myContent;
    }

    @Nullable
    private byte[] loadContent() throws TfsException, IOException {
        ArgumentHelper.checkNotNull((Object)this.getFile(), (String)"localPath");
        TFSContentStore store = TFSContentStoreFactory.findOrCreate(this.getFile().getPath(), this.getChangeset(), this.getFilePath(), this.project);
        return store.loadContent();
    }

    @NonNls
    public String toString() {
        return "TFSContentRevision [file=" + this.getFile() + ", revision=" + ((TfsRevisionNumber)this.getRevisionNumber()).getValue() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orignalPath";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/tfvc/core/revision/TFSContentRevision";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameRevision";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

