/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core.revision;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.revision.TFSContentStore;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class TFSTmpFileStore
implements TFSContentStore {
    @NonNls
    private static final String TMP_FILE_NAME = "idea_tfs";
    private static String myTfsTmpDir;
    private final File myTmpFile;

    @Nullable
    public static TFSContentStore find(String localPath, int revision) throws IOException {
        File tmpFile = new File(TFSTmpFileStore.createTmpFileName(localPath, revision));
        if (tmpFile.exists()) {
            return new TFSTmpFileStore(tmpFile);
        }
        return null;
    }

    TFSTmpFileStore(String localPath, int revision) throws IOException {
        this.myTmpFile = new File(TFSTmpFileStore.createTmpFileName(localPath, revision));
        this.myTmpFile.deleteOnExit();
    }

    private static String createTmpFileName(String localPath, int revision) throws IOException {
        return TFSTmpFileStore.getTfsTmpDir() + File.separator + localPath.hashCode() + "." + revision;
    }

    TFSTmpFileStore(File tmpFile) {
        this.myTmpFile = tmpFile;
    }

    private static String getTfsTmpDir() throws IOException {
        if (myTfsTmpDir == null) {
            File tmpDir = FileUtil.createTempFile((String)TMP_FILE_NAME, (String)"");
            tmpDir.delete();
            tmpDir.mkdir();
            tmpDir.deleteOnExit();
            myTfsTmpDir = tmpDir.getAbsolutePath();
        }
        return myTfsTmpDir;
    }

    @Override
    public void saveContent(TfsFileUtil.ContentWriter contentWriter) throws TfsException, IOException {
        TfsFileUtil.setFileContent(this.myTmpFile, contentWriter);
    }

    @Override
    public byte[] loadContent() throws IOException {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(this.myTmpFile);
            byte[] byArray = StreamUtil.loadFromStream((InputStream)fileStream);
            return byArray;
        }
        finally {
            if (fileStream != null) {
                ((InputStream)fileStream).close();
            }
        }
    }

    @Override
    public File getTmpFile() {
        return this.myTmpFile;
    }
}

