/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.tfvc.ui.CreateBranchForm;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class CreateBranchDialog
extends BaseDialogImpl {
    private static final String PROP_SERVER_CONTEXT = "server_context";
    private static final String PROP_SERVER_PATH = "server_path";
    private static final String PROP_IS_DIR = "is_directory";
    private CreateBranchForm form;

    public CreateBranchDialog(Project project, ServerContext serverContext, String serverPath, boolean isDirectory) {
        super(project, TfPluginBundle.message("Tfvc.Branch.Dialog.Title", new Object[0]), TfPluginBundle.message("Tfvc.Branch.Dialog.OkButton", new Object[0]), "Tfvc.Branch.Dialog.Title", true, CreateBranchDialog.createProperties(serverContext, serverPath, isDirectory));
    }

    private static Map<String, Object> createProperties(ServerContext serverContext, String serverPath, boolean isDirectory) {
        HashMap<String, Object> properties = new HashMap<String, Object>(3);
        properties.put(PROP_SERVER_CONTEXT, serverContext);
        properties.put(PROP_SERVER_PATH, serverPath);
        properties.put(PROP_IS_DIR, isDirectory);
        return properties;
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.form = new CreateBranchForm(this.getProject(), (ServerContext)this.getProperty(PROP_SERVER_CONTEXT), (String)this.getProperty(PROP_SERVER_PATH), (Boolean)this.getProperty(PROP_IS_DIR));
        this.form.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CreateBranchDialog.this.revalidate();
            }
        });
        this.setSize(JBUI.scale((int)380), JBUI.scale((int)450));
        this.revalidate();
        return this.form.getContentPane();
    }

    private void revalidate() {
        this.setOkEnabled(StringUtil.isNotEmpty((String)this.form.getTargetPath()));
    }

    public String getTargetPath() {
        return this.form.getTargetPath();
    }

    public boolean isCreateWorkingCopies() {
        return this.form.isCreateWorkingCopies();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.form.getPreferredFocusedComponent();
    }
}

