/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.microsoft.alm.plugin.external.commands.LockCommand;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.tfvc.ui.LockItemsTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class LockItemsForm {
    private JPanel contentPane;
    private JTable lockItemsTable;
    private JRadioButton lockCheckOutRadioButton;
    private JRadioButton lockCheckInRadioButton;
    private JCheckBox recursiveCheckBox;
    private final LockItemsTableModel lockItemsTableModel;

    public LockItemsForm(List<ItemInfo> items) {
        this.$$$setupUI$$$();
        this.lockCheckInRadioButton.setSelected(true);
        this.lockItemsTableModel = new LockItemsTableModel(items);
        this.lockItemsTable.setModel(this.lockItemsTableModel);
        for (int i = 0; i < LockItemsTableModel.Column.values().length; ++i) {
            this.lockItemsTable.getColumnModel().getColumn(i).setPreferredWidth(LockItemsTableModel.Column.values()[i].getWidth());
        }
        this.lockItemsTable.setSelectionMode(0);
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setRadioButtonsEnabled(boolean isEnabled) {
        this.lockCheckInRadioButton.setEnabled(isEnabled);
        this.lockCheckOutRadioButton.setEnabled(isEnabled);
    }

    public List<ItemInfo> getSelectedItems() {
        return this.lockItemsTableModel.getSelectedItems();
    }

    public LockCommand.LockLevel getLockLevel() {
        if (this.lockCheckInRadioButton.isEnabled() && this.lockCheckInRadioButton.isSelected()) {
            return LockCommand.LockLevel.CHECKIN;
        }
        if (this.lockCheckOutRadioButton.isEnabled() && this.lockCheckOutRadioButton.isSelected()) {
            return LockCommand.LockLevel.CHECKOUT;
        }
        return LockCommand.LockLevel.NONE;
    }

    public boolean getRecursive() {
        return this.recursiveCheckBox.isSelected();
    }

    public void addListener(LockItemsTableModel.Listener listener) {
        this.lockItemsTableModel.addListener(listener);
    }

    public void removeListener(LockItemsTableModel.Listener listener) {
        this.lockItemsTableModel.removeListener(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "South");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.LockBox"), 0, 0, null, null));
        this.lockCheckInRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.CheckinRadio"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.lockCheckOutRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.CheckoutRadio"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.recursiveCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.RecursiveCheck"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.ItemsBox"), 0, 0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, "Center");
        JBTable jBTable = new JBTable();
        this.lockItemsTable = jBTable;
        jBTable.setEnabled(true);
        jBTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        jBScrollPane.setViewportView((Component)jBTable);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

