/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.tfvc.ui.MergeBranchForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class MergeBranchDialog
extends BaseDialogImpl {
    private static final String PROP_SERVER_CONTEXT = "serverContext";
    private static final String PROP_SOURCE_PATH = "sourcePath";
    private static final String PROP_SOURCE_IS_DIR = "sourceIsDirectory";
    private static final String PROP_BRANCH_LIST_PROVIDER = "branchListProvider";
    private MergeBranchForm mergeBranchForm;

    public MergeBranchDialog(Project project, ServerContext serverContext, String sourcePath, boolean sourceIsDirectory, BranchListProvider branchListProvider) {
        super(project, TfPluginBundle.message("Tfvc.MergeBranch.Dialog.Title", new Object[0]), TfPluginBundle.message("Tfvc.MergeBranch.Dialog.OkButton", new Object[0]), "Tfvc.MergeBranch.Dialog.Title", true, MergeBranchDialog.createProperties(serverContext, sourcePath, sourceIsDirectory, branchListProvider));
        this.setResizable(true);
    }

    private static Map<String, Object> createProperties(ServerContext serverContext, String sourcePath, boolean sourceIsDirectory, BranchListProvider branchListProvider) {
        HashMap<String, Object> properties = new HashMap<String, Object>(3);
        properties.put(PROP_SERVER_CONTEXT, serverContext);
        properties.put(PROP_SOURCE_PATH, sourcePath);
        properties.put(PROP_SOURCE_IS_DIR, sourceIsDirectory);
        properties.put(PROP_BRANCH_LIST_PROVIDER, branchListProvider);
        return properties;
    }

    public String getSourcePath() {
        return this.mergeBranchForm.getSourcePath();
    }

    public String getTargetPath() {
        return this.mergeBranchForm.getTargetPath();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.mergeBranchForm = new MergeBranchForm(this.getProject(), (ServerContext)this.getProperty(PROP_SERVER_CONTEXT), (String)this.getProperty(PROP_SOURCE_PATH), (Boolean)this.getProperty(PROP_SOURCE_IS_DIR), this.getTitle(), (BranchListProvider)this.getProperty(PROP_BRANCH_LIST_PROVIDER));
        this.mergeBranchForm.addListener(new MergeBranchForm.Listener(){

            @Override
            public void stateChanged(boolean canFinish) {
                MergeBranchDialog.this.setOkEnabled(canFinish);
            }
        });
        return this.mergeBranchForm.getContentPanel();
    }

    @Override
    protected void doOKAction() {
        this.mergeBranchForm.close();
        super.doOKAction();
    }

    @Override
    public void doCancelAction() {
        this.mergeBranchForm.close();
        super.doCancelAction();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.mergeBranchForm.getPreferredFocusedComponent();
    }

    public static interface BranchListProvider {
        public List<String> getBranches(String var1);
    }
}

