/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.ui.MergeBranchDialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.ServerBrowserDialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeForm;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MergeBranchForm {
    private TextFieldWithBrowseButton.NoPathCompletion sourceText;
    private JComboBox targetCombo;
    private JComboBox changesTypeCombo;
    private JPanel contentPanel;
    private JPanel changesetsPanel;
    private JLabel sourceBranchLabel;
    private JPanel changesToMergePanel;
    private final Project project;
    private final ServerContext serverContext;
    private final String dialogTitle;
    private final EventDispatcher<Listener> myEventDispatcher;
    private boolean mySourceIsDirectory;
    private final FocusListener mySourceFieldFocusListener;
    private final MergeBranchDialog.BranchListProvider branchListProvider;

    public MergeBranchForm(final Project project, final ServerContext serverContext, String initialSourcePath, boolean initialSourcePathIsDirectory, String dialogTitle, MergeBranchDialog.BranchListProvider branchListProvider) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.project = project;
        this.serverContext = serverContext;
        this.dialogTitle = dialogTitle;
        this.branchListProvider = branchListProvider;
        this.sourceBranchLabel.setLabelFor(this.sourceText.getChildComponent());
        this.sourceText.setText(initialSourcePath);
        this.mySourceIsDirectory = initialSourcePathIsDirectory;
        this.sourceText.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerBrowserDialog dialog = new ServerBrowserDialog(TfPluginBundle.message("Tfvc.MergeBranch.Browse.Title", new Object[0]), project, serverContext, MergeBranchForm.this.sourceText.getText(), false, false);
                if (dialog.showAndGet()) {
                    TfsTreeForm.SelectedItem selectedItem = dialog.getSelectedItem();
                    MergeBranchForm.this.sourceText.setText(selectedItem != null ? selectedItem.path : null);
                    MergeBranchForm.this.mySourceIsDirectory = selectedItem == null || selectedItem.isDirectory;
                }
                MergeBranchForm.this.updateOnSourceChange();
            }
        });
        this.mySourceFieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MergeBranchForm.this.mySourceIsDirectory = true;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MergeBranchForm.this.updateOnSourceChange();
                    }
                }, ModalityState.current());
            }
        };
        this.sourceText.getTextField().addFocusListener(this.mySourceFieldFocusListener);
        this.targetCombo.setModel(new DefaultComboBoxModel());
        this.targetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergeBranchForm.this.changesTypeCombo.getSelectedItem() == ChangesType.SELECTED) {
                    MergeBranchForm.this.updateChangesetsTable();
                }
            }
        });
        this.changesTypeCombo.setModel(new DefaultComboBoxModel<ChangesType>(ChangesType.values()));
        this.changesTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergeBranchForm.this.changesTypeCombo.getSelectedItem() == ChangesType.SELECTED) {
                    MergeBranchForm.this.updateChangesetsTable();
                }
                ((CardLayout)MergeBranchForm.this.changesetsPanel.getLayout()).show(MergeBranchForm.this.changesetsPanel, MergeBranchForm.this.changesTypeCombo.getSelectedItem().toString());
                MergeBranchForm.this.fireStateChanged();
            }
        });
        this.changesTypeCombo.setVisible(false);
        this.changesToMergePanel.setVisible(false);
        this.updateOnSourceChange();
        this.targetCombo.setSelectedItem(null);
    }

    public JComponent getContentPanel() {
        return this.contentPanel;
    }

    private void updateChangesetsTable() {
    }

    public String getSourcePath() {
        return this.sourceText.getText();
    }

    public String getTargetPath() {
        String targetBranch = (String)this.targetCombo.getSelectedItem();
        return targetBranch;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private void fireStateChanged() {
        ((Listener)this.myEventDispatcher.getMulticaster()).stateChanged(this.canFinish());
    }

    private boolean canFinish() {
        return true;
    }

    private void updateOnSourceChange() {
        try {
            List<String> targetBranches = this.branchListProvider.getBranches(this.getSourcePath());
            ((DefaultComboBoxModel)this.targetCombo.getModel()).removeAllElements();
            for (String targetBranch : targetBranches) {
                ((DefaultComboBoxModel)this.targetCombo.getModel()).addElement(targetBranch);
            }
            this.fireStateChanged();
        }
        catch (Throwable t) {
            Messages.showErrorDialog((Project)this.project, (String)t.getMessage(), (String)this.dialogTitle);
        }
    }

    public void close() {
        this.sourceText.getTextField().removeFocusListener(this.mySourceFieldFocusListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.sourceText.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        JComboBox jComboBox2;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JLabel jLabel;
        JPanel jPanel3;
        this.contentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.sourceBranchLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("MergeBranchDialog.Source"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.sourceText = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel3.add((Component)noPathCompletion, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(true);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("MergeBranchDialog.Target"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.targetCombo = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.changesToMergePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("MergeBranchDialog.ChangesToMerge"), 0, 0, null, null));
        this.changesTypeCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.changesetsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum ChangesType {
        ALL{

            public String toString() {
                return "All changes up to a specific version";
            }
        }
        ,
        SELECTED{

            public String toString() {
                return "Selected changesets";
            }
        };

    }

    public static interface Listener
    extends EventListener {
        public void stateChanged(boolean var1);
    }
}

