/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.ServerBrowserDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.commons.lang.StringUtils;

public class ServerPathCellEditor
extends AbstractTableCellEditor {
    private final String title;
    private final Project project;
    private final ServerContext serverContext;
    private CellEditorComponentWithBrowseButton<JTextField> component;

    public ServerPathCellEditor(String title, Project project, ServerContext serverContext) {
        this.title = title;
        this.project = project;
        this.serverContext = serverContext;
    }

    public Object getCellEditorValue() {
        return ((JTextField)this.component.getChildComponent()).getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerPathCellEditor.this.createBrowserDialog();
            }
        };
        this.component = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton(listener), (TableCellEditor)((Object)this));
        ((JTextField)this.component.getChildComponent()).setText((String)value);
        return this.component;
    }

    @VisibleForTesting
    protected void createBrowserDialog() {
        String serverPath = this.getServerPath();
        if (StringUtils.isNotEmpty((String)serverPath)) {
            ServerBrowserDialog dialog = new ServerBrowserDialog(this.title, this.project, this.serverContext, serverPath, true, false);
            if (dialog.showAndGet()) {
                ((JTextField)this.component.getChildComponent()).setText(dialog.getSelectedPath());
            }
        } else {
            Messages.showErrorDialog((Project)this.project, (String)TfPluginBundle.message("Tfvc.Server.Tree.No.Root.Msg", new Object[0]), (String)TfPluginBundle.message("Tfvc.Server.Tree.No.Root.Title", new Object[0]));
        }
    }

    @VisibleForTesting
    protected String getServerPath() {
        String serverPath = (String)this.getCellEditorValue();
        if (StringUtils.isEmpty((String)serverPath) && this.serverContext != null && this.serverContext.getTeamProjectReference() != null) {
            serverPath = "$/".concat(this.serverContext.getTeamProjectReference().getName());
        }
        return serverPath;
    }
}

