/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.management;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.idea.tfvc.ui.management.ManageWorkspacesDialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.management.ManageWorkspacesModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

public class ManageWorkspacesController
implements Observer,
ActionListener {
    private final ManageWorkspacesDialog dialog;
    private final ManageWorkspacesModel model;

    public ManageWorkspacesController(Project project) {
        this.model = new ManageWorkspacesModel(project);
        this.dialog = new ManageWorkspacesDialog(project, this.model.getContextProvider());
        this.dialog.addActionListener(this);
        this.model.addObserver(this);
        this.update(null, null);
    }

    public void showModalDialog() {
        this.dialog.showModalDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("reloadWorkspaces".equals(e.getActionCommand())) {
            this.model.reloadWorkspacesWithProgress(this.dialog.getSelectedServer());
        } else if ("deleteWorkspace".equals(e.getActionCommand())) {
            this.model.deleteWorkspaceWithProgress(this.dialog.getSelectedWorkspace());
        } else if ("editProxy".equals(e.getActionCommand())) {
            this.model.editProxy(this.dialog.getSelectedServer());
        } else if ("editWorkspace".equals(e.getActionCommand())) {
            this.model.editWorkspaceWithProgress(this.dialog.getSelectedWorkspace(), new Runnable(){

                @Override
                public void run() {
                    ManageWorkspacesController.this.dialog.updateControls(ManageWorkspacesController.this.dialog.getSelectedWorkspace());
                }
            });
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("refreshServer".equals(arg)) {
            this.dialog.updateControls(this.dialog.getSelectedServer());
        } else if ("refreshWorkspace".equals(arg)) {
            this.dialog.updateControls(this.dialog.getSelectedWorkspace());
        }
    }
}

