/*
 * Decompiled with CFR 0.152.
 */
package testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.ideaRunner.testng;

import testng_listener_teamcity_service_messages.jetbrains.buildServer.ComparisonFailureData;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.ComparisonFailureUtil;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.ideaRunner.JpsBuildProblem;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.agent.ideaRunner.ServiceMessageReporter;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.Message;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestFailed;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestFinished;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestStarted;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.testng.TeamCityTestListener;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.testng.TestNGEventsAdapter;

public class TestngServiceMessageReporter
extends TestNGEventsAdapter {
    public TestngServiceMessageReporter() {
        super(new TeamCityTestListener(){
            private final ServiceMessageReporter myReporter = new ServiceMessageReporter(System.out, System.err);

            public void suiteStarted(String suiteName) {
                this.report(new TestSuiteStarted(suiteName));
            }

            public void suiteFinished(String suiteName) {
                this.report(new TestSuiteFinished(suiteName));
            }

            public void testStarted(String testName, String flowId) {
                TestStarted message = new TestStarted(testName, false, null);
                this.reportTestMessage(message, flowId);
            }

            public void testFinishedSuccess(String testName, String flowId, int duration) {
                TestFinished message = new TestFinished(testName, duration);
                this.reportTestMessage(message, flowId);
            }

            public void testFinishedFailure(String testName, String flowId, Throwable failure, int duration) {
                ComparisonFailureData cfd = ComparisonFailureUtil.extractComparisonFailure(failure);
                if (cfd != null) {
                    this.reportTestMessage(new TestFailed(testName, failure, cfd.getActual(), cfd.getExpected()), flowId);
                } else {
                    this.reportTestMessage(new TestFailed(testName, failure), flowId);
                }
                this.reportTestMessage(new TestFinished(testName, duration), flowId);
            }

            public void testFinishedIgnored(String testName, String flowId) {
                this.reportTestMessage(new TestIgnored(testName, ""), flowId);
                this.reportTestMessage(new TestFinished(testName, 0), flowId);
            }

            public void error(String message) {
                this.report(new Message(message, "ERROR", ""));
                this.report(new JpsBuildProblem(message));
            }

            private void reportTestMessage(MessageWithAttributes message, String flowId) {
                this.myReporter.reportTestMessage(message);
            }

            private void report(ServiceMessage message) {
                this.myReporter.report(message);
            }
        });
        this.setInitialFlowId("");
    }
}

