/*
 * Decompiled with CFR 0.152.
 */
package testng_listener_teamcity_service_messages.jetbrains.buildServer.testng;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import testng_listener_teamcity_service_messages.jetbrains.buildServer.testng.TeamCityTestListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGEventsAdapter
implements ISuiteListener,
ITestListener {
    private static boolean ourUseGetTestNameFromITest = true;
    private final Set<String> myCurrentTests = new HashSet<String>();
    private final TeamCityTestListener myListener;
    private String myFlowId;

    public TestNGEventsAdapter(TeamCityTestListener listener) {
        this.myListener = listener;
    }

    protected void setInitialFlowId(String initialFlowId) {
        this.myFlowId = initialFlowId + "-" + String.valueOf(System.identityHashCode(this));
    }

    public synchronized void onStart(ITestContext iTestContext) {
    }

    public synchronized void onFinish(ITestContext iTestContext) {
        Set<ITestResult> configurations = this.getFailedConfigurations(iTestContext);
        if (configurations != null) {
            for (ITestResult res : configurations) {
                this.onTestFailure(res);
            }
        }
    }

    public synchronized void onTestStart(ITestResult result) {
        this.startTest(result);
    }

    private boolean startTest(ITestResult iTestResult) {
        String flowId = this.getFlowId(iTestResult);
        if (!this.myCurrentTests.add(flowId)) {
            return false;
        }
        String testName = TestNGEventsAdapter.getTestName(iTestResult);
        this.myListener.testStarted(testName, flowId);
        return true;
    }

    private boolean isStarted(String flowId) {
        return this.myCurrentTests.contains(flowId);
    }

    public synchronized void onTestSuccess(ITestResult result) {
        this.finishIfStarted(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishIfStarted(ITestResult result) {
        String flowId = this.getFlowId(result);
        if (!this.isStarted(flowId)) {
            return;
        }
        try {
            String testName = TestNGEventsAdapter.getTestName(result);
            int duration = (int)(result.getEndMillis() - result.getStartMillis());
            this.myListener.testFinishedSuccess(testName, flowId, duration);
        }
        finally {
            this.myCurrentTests.remove(flowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onTestFailure(ITestResult result) {
        this.startTest(result);
        String flowId = this.getFlowId(result);
        if (!this.isStarted(flowId)) {
            return;
        }
        try {
            String testName = TestNGEventsAdapter.getTestName(result);
            int duration = (int)(result.getEndMillis() - result.getStartMillis());
            Throwable throwable = result.getThrowable();
            this.myListener.testFinishedFailure(testName, flowId, throwable, duration);
        }
        finally {
            this.myCurrentTests.remove(flowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onTestSkipped(ITestResult result) {
        if (TestNGEventsAdapter.isSpecialMethod(result)) {
            return;
        }
        this.startTest(result);
        String flowId = this.getFlowId(result);
        if (!this.isStarted(flowId)) {
            return;
        }
        try {
            String testName = TestNGEventsAdapter.getTestName(result);
            this.myListener.testFinishedIgnored(testName, flowId);
        }
        finally {
            this.myCurrentTests.remove(flowId);
        }
    }

    public synchronized void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.onTestFailure(result);
    }

    public void onStart(ISuite suite) {
        String suiteName = suite.getName();
        if (suiteName == null) {
            return;
        }
        this.myListener.suiteStarted(suiteName);
    }

    public void onFinish(ISuite suite) {
        String suiteName = suite.getName();
        if (suiteName == null) {
            return;
        }
        Map suiteResults = suite.getResults();
        if (suiteResults != null) {
            for (ISuiteResult result : suiteResults.values()) {
                Set<ITestResult> results = this.getFailedConfigurations(result.getTestContext());
                if (results == null) continue;
                for (ITestResult res : results) {
                    ITestNGMethod method = res.getMethod();
                    if (method == null || !method.isAfterSuiteConfiguration()) continue;
                    this.onTestFailure(res);
                }
            }
        }
        this.myListener.suiteFinished(suiteName);
    }

    private String getFlowId(ITestResult flowIdentityObject) {
        return this.myFlowId + "-" + String.valueOf(System.identityHashCode(flowIdentityObject));
    }

    private static String getTestName(ITestResult iTestResult) {
        Object[] params;
        String methodName = TestNGEventsAdapter.getTestNameFromITest(iTestResult);
        if (methodName == null) {
            methodName = iTestResult.getTestClass().getRealClass().getName() + '.' + iTestResult.getMethod().getMethodName();
        }
        if ((params = iTestResult.getParameters()) != null && params.length > 0) {
            return methodName + "(" + TestNGEventsAdapter.paramsAsString(params) + ")";
        }
        return methodName;
    }

    private static String getTestNameFromITest(ITestResult iTestResult) {
        if (!ourUseGetTestNameFromITest) {
            return null;
        }
        try {
            String className = iTestResult.getTestName();
            if (className == null) {
                return null;
            }
            return className + '.' + iTestResult.getMethod().getMethodName();
        }
        catch (Throwable ignored) {
            ourUseGetTestNameFromITest = false;
            return null;
        }
    }

    private static boolean isSpecialMethod(ITestResult iTestResult) {
        ITestNGMethod method = iTestResult.getMethod();
        return method.isAfterClassConfiguration() || method.isAfterGroupsConfiguration() || method.isAfterMethodConfiguration() || method.isAfterSuiteConfiguration() || method.isAfterTestConfiguration() || method.isBeforeClassConfiguration() || method.isBeforeGroupsConfiguration() || method.isBeforeMethodConfiguration() || method.isBeforeSuiteConfiguration() || method.isBeforeTestConfiguration();
    }

    private static String paramsAsString(Object[] params) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            Object param;
            if (i > 0) {
                result.append(", ");
            }
            if ((param = params[i]) == null) {
                result.append("null");
                continue;
            }
            if (param instanceof String) {
                result.append("\"").append(param).append("\"");
                continue;
            }
            result.append(param.toString());
        }
        return result.toString();
    }

    private Set<ITestResult> getFailedConfigurations(ITestContext iTestContext) {
        if (iTestContext == null) {
            return null;
        }
        try {
            IResultMap failedConfigurations = iTestContext.getFailedConfigurations();
            if (failedConfigurations == null) {
                return null;
            }
            return failedConfigurations.getAllResults();
        }
        catch (Throwable e) {
            if (!(e instanceof NoSuchMethodError) || !e.toString().contains("getFailedConfigurations")) {
                this.myListener.error("Unexpected error is thrown from TestNG: " + e.toString());
            }
            return null;
        }
    }
}

