/*
 * Decompiled with CFR 0.152.
 */
package com.android.java.model.builder;

import com.android.java.model.ArtifactModel;
import com.android.java.model.impl.ArtifactModelImpl;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class ArtifactModelBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return modelName.equals(ArtifactModel.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        String[] knownPlugins;
        PluginContainer plugins = project.getPlugins();
        for (String plugin : knownPlugins = new String[]{"java", "com.android.application", "com.android.library", "android", "android-library", "com.android.atom", "com.android.instantapp", "com.android.test", "com.android.model.atom", "com.android.model.application", "com.android.model.library", "com.android.model.native"}) {
            if (!plugins.hasPlugin(plugin)) continue;
            return null;
        }
        return new ArtifactModelImpl(project.getName().intern(), ArtifactModelBuilder.getArtifactsByConfiguration(project));
    }

    private static Map<String, Set<File>> getArtifactsByConfiguration(Project project) {
        return project.getConfigurations().stream().collect(Collectors.toMap(p -> p.getName().intern(), p -> new LinkedHashSet(p.getAllArtifacts().getFiles().getFiles())));
    }
}

