/*
 * Decompiled with CFR 0.152.
 */
package com.android.java.model.builder;

import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.SourceSet;
import com.android.java.model.impl.JavaLibraryImpl;
import com.android.java.model.impl.JavaProjectImpl;
import com.android.java.model.impl.SourceSetImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Specs;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.VersionNumber;

public class JavaModelBuilder
implements ToolingModelBuilder {
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    private static final String LOCAL_JAR_DISPLAY_NAME = "local jar - ";

    public boolean canBuild(String modelName) {
        return modelName.equals(JavaProject.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            return null;
        }
        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        ArrayList<SourceSet> sourceSets = new ArrayList<SourceSet>();
        for (org.gradle.api.tasks.SourceSet sourceSet : javaPlugin.getSourceSets()) {
            sourceSets.add(JavaModelBuilder.createSourceSets(project, sourceSet));
        }
        return new JavaProjectImpl(project.getName(), sourceSets, javaPlugin.getSourceCompatibility().toString());
    }

    private static SourceSet createSourceSets(Project project, org.gradle.api.tasks.SourceSet sourceSet) {
        String compileConfigurationName = JavaModelBuilder.isGradleAtLeast(project.getGradle().getGradleVersion(), "2.12") ? sourceSet.getCompileClasspathConfigurationName() : sourceSet.getCompileConfigurationName();
        return new SourceSetImpl(sourceSet.getName(), sourceSet.getAllJava().getSrcDirs(), sourceSet.getResources().getSrcDirs(), sourceSet.getOutput().getClassesDir(), sourceSet.getOutput().getResourcesDir(), JavaModelBuilder.getLibrariesForConfiguration(project, compileConfigurationName));
    }

    static boolean isGradleAtLeast(String gradleVersion, String expectedVersion) {
        VersionNumber givenVersion;
        VersionNumber currentVersion = VersionNumber.parse((String)gradleVersion);
        return currentVersion.compareTo(givenVersion = VersionNumber.parse((String)expectedVersion)) >= 0;
    }

    private static Collection<JavaLibrary> getLibrariesForConfiguration(Project project, String configurationName) {
        Configuration configuration = project.getConfigurations().getAt(configurationName);
        ArrayList<JavaLibrary> javaLibraries = new ArrayList<JavaLibrary>();
        Set allArtifacts = configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.satisfyAll());
        for (ResolvedArtifact artifact : allArtifacts) {
            String projectPath = JavaModelBuilder.getProjectPath(project, artifact);
            File jarFile = artifact.getFile();
            javaLibraries.add(new JavaLibraryImpl(projectPath, artifact.getName().intern(), jarFile));
        }
        Set unresolvedDependencies = configuration.getResolvedConfiguration().getLenientConfiguration().getUnresolvedModuleDependencies();
        for (UnresolvedDependency dependency : unresolvedDependencies) {
            String unresolvedName = UNRESOLVED_DEPENDENCY_PREFIX + dependency.getSelector().toString().replaceAll(":", " ");
            javaLibraries.add(new JavaLibraryImpl(null, unresolvedName.intern(), new File(unresolvedName)));
        }
        for (UnresolvedDependency dependency : configuration.getAllDependencies()) {
            if (!(dependency instanceof SelfResolvingDependency) || dependency instanceof ProjectDependency) continue;
            for (File file : ((SelfResolvingDependency)dependency).resolve()) {
                String localJarName = LOCAL_JAR_DISPLAY_NAME + file.getName();
                javaLibraries.add(new JavaLibraryImpl(null, localJarName.intern(), file));
            }
        }
        return javaLibraries;
    }

    private static String getProjectPath(Project project, ResolvedArtifact artifact) {
        if (JavaModelBuilder.isGradleAtLeast(project.getGradle().getGradleVersion(), "2.6")) {
            ComponentIdentifier id = artifact.getId().getComponentIdentifier();
            if (id instanceof ProjectComponentIdentifier) {
                return ((ProjectComponentIdentifier)id).getProjectPath().intern();
            }
        } else {
            Set allProjects = project.getRootProject().getAllprojects();
            for (Project subProject : allProjects) {
                if (!JavaModelBuilder.contains(subProject.getBuildDir(), artifact.getFile())) continue;
                return subProject.getPath().intern();
            }
        }
        return null;
    }

    private static boolean contains(File directory, File file) {
        try {
            File canonicalDirectory = directory.getCanonicalFile();
            for (File canonicalFile = file.getCanonicalFile().getParentFile(); canonicalFile != null; canonicalFile = canonicalFile.getParentFile()) {
                if (!canonicalFile.equals(canonicalDirectory)) continue;
                return true;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return false;
    }
}

