/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootType;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Visitor;

public class RootObj
extends Instance {
    public static final String UNDEFINED_CLASS_NAME = "no class defined!!";
    RootType mType = RootType.UNKNOWN;
    int mThread;

    public RootObj(RootType type) {
        this(type, 0L, 0, null);
    }

    public RootObj(RootType type, long id) {
        this(type, id, 0, null);
    }

    public RootObj(RootType type, long id, int thread, StackTrace stack) {
        super(id, stack);
        this.mType = type;
        this.mThread = thread;
    }

    public final String getClassName(Snapshot snapshot) {
        ClassObj theClass = this.mType == RootType.SYSTEM_CLASS ? snapshot.findClass(this.mId) : snapshot.findInstance(this.mId).getClassObj();
        if (theClass == null) {
            return UNDEFINED_CLASS_NAME;
        }
        return theClass.mClassName;
    }

    @Override
    public void resolveReferences() {
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.visitRootObj(this);
        Instance instance = this.getReferredInstance();
        if (instance != null) {
            visitor.visitLater(null, instance);
        }
    }

    public final String toString() {
        return String.format("%s@0x%08x", this.mType.getName(), this.mId);
    }

    public Instance getReferredInstance() {
        if (this.mType == RootType.SYSTEM_CLASS) {
            return this.mHeap.mSnapshot.findClass(this.mId);
        }
        return this.mHeap.mSnapshot.findInstance(this.mId);
    }

    public RootType getRootType() {
        return this.mType;
    }
}

