/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.usb;

import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.parser.OutputParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0014\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/usb/UsbDeviceCollectorImpl;", "Lcom/android/tools/usb/UsbDeviceCollector;", "()V", "execute", "Ljava/io/InputStream;", "command", "", "getPlatform", "Lcom/android/tools/usb/Platform;", "isSupported", "", "platform", "listUsbDevices", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/android/tools/usb/UsbDevice;", "android.sdktools.usb-devices"})
public final class UsbDeviceCollectorImpl
implements UsbDeviceCollector {
    @Override
    @NotNull
    public CompletableFuture<List<UsbDevice>> listUsbDevices() {
        Platform currentOS = Platform.Factory.currentOS();
        if (!currentOS.getSupported()) {
            CompletableFuture<List<UsbDevice>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.comple\u2026(Collections.emptyList())");
            return completableFuture;
        }
        OutputParser parser = currentOS.parser();
        String string = currentOS.getCommand();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return parser.parse(this.execute(string));
    }

    @Override
    public boolean isSupported(@NotNull String platform) {
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        return Platform.Factory.currentOS(platform).getSupported();
    }

    @Override
    @NotNull
    public Platform getPlatform() {
        return Platform.Factory.currentOS();
    }

    private final InputStream execute(String command) {
        Process p;
        ProcessBuilder builder = new ProcessBuilder(StringsKt.split$default((CharSequence)command, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null));
        builder.redirectErrorStream(true);
        Process process = p = builder.start();
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"p");
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"p.inputStream");
        return inputStream;
    }
}

