/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class ObjectArrays {
    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array2) {
        return ObjectArrays.checkElementsNotNull(array2, array2.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array2, int length) {
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array2[i], i);
        }
        return array2;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index2) {
        if (element == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element;
    }
}

