/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAttributesKey
implements Comparable<TextAttributesKey> {
    private static final Logger LOG = Logger.getInstance(TextAttributesKey.class);
    private static final TextAttributes NULL_ATTRIBUTES = new TextAttributes();
    private static final Map<String, TextAttributesKey> ourRegistry = ConcurrentFactoryMap.createMap(TextAttributesKey::new);
    private static final NullableLazyValue<TextAttributeKeyDefaultsProvider> ourDefaultsProvider = new VolatileNullableLazyValue<TextAttributeKeyDefaultsProvider>(){

        @Override
        @Nullable
        protected TextAttributeKeyDefaultsProvider compute() {
            return ServiceManager.getService(TextAttributeKeyDefaultsProvider.class);
        }
    };
    private final String myExternalName;
    private TextAttributes myDefaultAttributes = NULL_ATTRIBUTES;

    private TextAttributesKey(String externalName) {
        this.myExternalName = externalName;
    }

    @NotNull
    public static TextAttributesKey find(@NotNull @NonNls String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(1);
        }
        TextAttributesKey textAttributesKey = ourRegistry.get(externalName);
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(2);
        }
        return textAttributesKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @Override
    public int compareTo(@NotNull TextAttributesKey key) {
        if (key == null) {
            TextAttributesKey.$$$reportNull$$$0(3);
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    @NotNull
    public static TextAttributesKey createTextAttributesKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            TextAttributesKey.$$$reportNull$$$0(4);
        }
        TextAttributesKey textAttributesKey = TextAttributesKey.find(externalName);
        if (textAttributesKey == null) {
            TextAttributesKey.$$$reportNull$$$0(5);
        }
        return textAttributesKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextAttributesKey that = (TextAttributesKey)o;
        return this.myExternalName.equals(that.myExternalName);
    }

    public int hashCode() {
        return this.myExternalName.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/TextAttributesKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextAttributesKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempTextAttributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTextAttributesKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTempTextAttributesKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeTextAttributesKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTemp";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TextAttributeKeyDefaultsProvider {
    }
}

