/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SmartExtensionPoint<Extension, V>
implements ExtensionPointAndAreaListener<Extension> {
    private final Collection<V> myExplicitExtensions;
    private ExtensionPoint<Extension> myExtensionPoint;
    private List<V> myCache;

    protected SmartExtensionPoint(@NotNull Collection<V> explicitExtensions) {
        if (explicitExtensions == null) {
            SmartExtensionPoint.$$$reportNull$$$0(0);
        }
        this.myExplicitExtensions = explicitExtensions;
    }

    @NotNull
    protected abstract ExtensionPoint<Extension> getExtensionPoint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(1);
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.add(extension);
            this.myCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExplicitExtension(@NotNull V extension) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(2);
        }
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            this.myExplicitExtensions.remove(extension);
            this.myCache = null;
        }
    }

    @Nullable
    protected abstract V getExtension(@NotNull Extension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final List<V> getExtensions() {
        Collection<V> collection = this.myExplicitExtensions;
        // MONITORENTER : collection
        if (this.myCache == null) {
            this.myExtensionPoint = this.getExtensionPoint();
            this.myExtensionPoint.addExtensionPointListener(this);
            this.myCache = new ArrayList<V>(this.myExplicitExtensions);
            this.myCache.addAll(ContainerUtil.mapNotNull(this.myExtensionPoint.getExtensions(), this::getExtension));
        }
        List<V> list2 = this.myCache;
        // MONITOREXIT : collection
        if (list2 != null) return list2;
        SmartExtensionPoint.$$$reportNull$$$0(3);
        return list2;
    }

    @Override
    public final void extensionAdded(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(4);
        }
        this.dropCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        Collection<V> collection = this.myExplicitExtensions;
        synchronized (collection) {
            if (this.myCache != null) {
                this.myCache = null;
                this.myExtensionPoint.removeExtensionPointListener(this);
                this.myExtensionPoint = null;
            }
        }
    }

    @Override
    public final void extensionRemoved(@NotNull Extension extension, @Nullable PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            SmartExtensionPoint.$$$reportNull$$$0(5);
        }
        this.dropCache();
    }

    @Override
    public void areaReplaced(@NotNull ExtensionsArea area) {
        if (area == null) {
            SmartExtensionPoint.$$$reportNull$$$0(6);
        }
        this.dropCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitExtensions";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/SmartExtensionPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/SmartExtensionPoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extensionAdded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extensionRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areaReplaced";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

