/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic<DumbModeListener>("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(0);
        }
        return DumbService.getInstance(project).isDumb();
    }

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(5);
        }
        return INSTANCE_KEY.getValue(project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull T[] array2) {
        if (array2 == null) {
            DumbService.$$$reportNull$$$0(6);
        }
        List<T> list2 = this.filterByDumbAwareness(Arrays.asList(array2));
        if (list2 == null) {
            DumbService.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<T> collection) {
        if (collection == null) {
            DumbService.$$$reportNull$$$0(8);
        }
        if (this.isDumb()) {
            ArrayList<T> result2 = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result2.add(element);
            }
            ArrayList<T> arrayList = result2;
            if (arrayList == null) {
                DumbService.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        if (collection instanceof List) {
            List list2 = (List)collection;
            if (list2 == null) {
                DumbService.$$$reportNull$$$0(10);
            }
            return list2;
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        if (arrayList == null) {
            DumbService.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public abstract void completeJustSubmittedTasks();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public abstract boolean isAlternativeResolveEnabled();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDumbAwareness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDumb";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runReadActionInSmartMode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadActionInSmartMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "repeatUntilPassesInSmartMode";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterByDumbAwareness";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeDumbAware";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withAlternativeResolveEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeWithAlternativeResolveEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runWithAlternativeResolveEnabled";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "allowStartingDumbModeInside";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runReadActionInSmartMode$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runReadActionInSmartMode$0";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DumbModeListener {
    }
}

