/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    @NonNls
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text();
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string2 = "\"" + s + "\"";
            if (string2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$1", "fun"));
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string2 = "'" + s + "'";
            if (string2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$2", "fun"));
        }
    };
    @NotNull
    public static final Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return StringUtil.trim(s);
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    @NonNls
    private static final List<String> REPLACES_REFS = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;");
    @NonNls
    private static final List<String> REPLACES_DISP = Arrays.asList("<", ">", "&", "'", "\"");
    @NonNls
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    @NonNls
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        MergingCharSequence mergingCharSequence = new MergingCharSequence(new MergingCharSequence(charSeq.subSequence(0, start), replacement), charSeq.subSequence(end, charSeq.length()));
        if (mergingCharSequence == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        return mergingCharSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        String string2 = StringUtil.replace(text2, oldS, newS, false);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text2.length()) {
            int index2;
            int n = index2 = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i) : text2.indexOf(oldS, i);
            if (index2 < 0) {
                if (i == 0) {
                    return text2;
                }
                newText.append(text2, i, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i);
            }
            newText.append(text2, i, index2);
            newText.append(newS);
            i = index2 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first2 = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first2)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first2)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        int sourceCount = where.length();
        for (int i = Math.max(fromIndex, 0); i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        String string2 = StringUtil.getPackageName(fqName2, '.');
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string2 = fqName2.substring(0, lastPointIdx);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(37);
            }
            return string2;
        }
        if ("" == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        int count2 = 0;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                ++count2;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text2.length() && text2.charAt(i + 1) == '\n') {
                ++i;
                ++count2;
                continue;
            }
            ++count2;
        }
        return count2;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset2; ++curOffset) {
            if (curOffset == text2.length()) {
                return -1;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text2.length() - 1 || text2.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        CharSequence hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string2 = buffer.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        return string2;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        return s.length() > 1 && StringUtil.isQuoteAt(s, 0) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        if (StringUtil.isQuotedString(s)) {
            String string2 = s.substring(1, s.length() - 1);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(81);
            }
            return string2;
        }
        String string3 = s;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        return string3;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string2 = plural;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(89);
            }
            return string2;
        }
        if (word.endsWith("s")) {
            String string3 = Pluralizer.restoreCase(word, word + "es");
            if (string3 == null) {
                StringUtil.$$$reportNull$$$0(90);
            }
            return string3;
        }
        String string4 = Pluralizer.restoreCase(word, word + "s");
        if (string4 == null) {
            StringUtil.$$$reportNull$$$0(91);
        }
        return string4;
    }

    @Contract(pure=true)
    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        if (s.isEmpty()) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(98);
            }
            return string2;
        }
        if (s.length() == 1) {
            String string3 = StringUtilRt.toUpperCase(s).toString();
            if (string3 == null) {
                StringUtil.$$$reportNull$$$0(99);
            }
            return string3;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string4 = s;
            if (string4 == null) {
                StringUtil.$$$reportNull$$$0(100);
            }
            return string4;
        }
        String string5 = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string5 == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return string5;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string2 = s;
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(103);
            }
            return string2;
        }
        String string3 = StringUtil.capitalize(s);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        return string3;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string2, String ... prefixes) {
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        int offset2 = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string2.regionMatches(offset2, prefix, 0, prefixLen)) {
                return false;
            }
            offset2 += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(116);
        }
        String string2 = StringUtil.trimEnd(s, suffix, false);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string2 = s.substring(0, s.length() - suffix.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(120);
            }
            return string2;
        }
        String string3 = s;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string2 = s.substring(0, s.length() - 1);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(123);
            }
            return string2;
        }
        String string3 = s;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        for (index2 = 0; index2 < string2.length() && string2.charAt(index2) == symbol2; ++index2) {
        }
        String string3 = string2.substring(index2);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string2, char symbol2) {
        int index2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        for (index2 = string2.length() - 1; index2 >= 0 && string2.charAt(index2) == symbol2; --index2) {
        }
        String string3 = string2.substring(0, index2 + 1);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        if (s.startsWith(prefix)) {
            String string2 = s.substring(prefix.length());
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(146);
            }
            return string2;
        }
        String string3 = s;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        return string3;
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol2, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string2 = StringUtil.notNullize(s, "");
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        String string2 = s == null ? defaultValue : s;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        return string2;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        boolean empty = nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s);
        return empty ? null : s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        String string2 = ExceptionUtil.getThrowableText(aThrowable);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count2) {
        char[] buffer = new char[count2];
        Arrays.fill(buffer, aChar);
        String string2 = StringFactory.createShared(buffer);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        assert (count2 >= 0) : count2;
        StringBuilder sb = new StringBuilder(s.length() * count2);
        for (int i = 0; i < count2; ++i) {
            sb.append(s);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        List<String> list2 = StringUtil.split(s, separator, true);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        List<String> list2 = StringUtil.split(s, separator, excludeSeparator, true);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        List<CharSequence> list2 = StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        if (separator.length() == 0) {
            List<CharSequence> list2 = Collections.singletonList(s);
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(182);
            }
            return list2;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index2 = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index2 + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index2 : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator2 = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        String string2 = StringUtil.join(strings, 0, strings.length, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result2.append(separator);
            }
            result2.append(strings[i]);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        String string2 = StringUtil.join(Arrays.asList(items), f, separator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(215);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        if (items.isEmpty()) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(217);
            }
            return "";
        }
        if (items.size() == 1) {
            String string2 = StringUtil.notNullize(f.fun(items.iterator().next()));
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(218);
            }
            return string2;
        }
        String string3 = StringUtil.join(items, f, separator);
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        return string3;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        return result2.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(items, f, separator, result2);
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        return string2;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        boolean isFirst = true;
        for (T item : items) {
            String string2 = f.fun(item);
            if (string2 == null || string2.isEmpty()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        if (strings.size() <= 1) {
            String string2 = StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(232);
            }
            return string2;
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(strings, separator, result2);
        String string3 = result2.toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        return string3;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        boolean isFirst = true;
        for (String string2 : strings) {
            if (string2 == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string2);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null || strings.length == 0) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(240);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string2 : strings) {
            builder.append(string2);
        }
        String string3 = builder.toString();
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        return string3;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        return chars.length() > value2.length() ? StringUtil.containsAnyChar(value2, chars, 0, value2.length()) : StringUtil.containsAnyChar(chars, value2, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value2, @NotNull String chars, int start, int end) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value2.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value2, char ch) {
        if (value2 == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        return value2.indexOf(ch) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter2.accept(ch)) continue;
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        if ((l1 = text2.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, int startIndex, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        if ((l1 = text2.length() - startIndex) < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text2.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        if ((l1 = text2.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text2.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        return StringUtil.indexOf(sequence2, infix, start, sequence2.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start, int end) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        for (int i = start; i <= end - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence2, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        end = Math.min(end, s.length);
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        String string2 = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text2;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        CharSequence charSequence = text2.length() > length ? text2.subSequence(0, length) + (appendEllipsis ? "..." : "") : text2;
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        CharSequence charSequence = text2.length() > length ? (prependEllipsis ? "..." : "") + text2.subSequence(text2.length() - length, text2.length()) : text2;
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        return charSequence;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text2) {
        return text2 == null ? null : StringUtil.replace(text2, REPLACES_DISP, REPLACES_REFS);
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String[] from, @NotNull String[] to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        String string2 = StringUtil.replace(text2, Arrays.asList(from), Arrays.asList(to));
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull List<String> from, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(382);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        assert (from.size() == to.size());
        StringBuilder result2 = null;
        block0: for (int i = 0; i < text2.length(); ++i) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (!text2.regionMatches(i, toReplace, 0, len)) continue;
                if (result2 == null) {
                    result2 = new StringBuilder(text2.length());
                    result2.append(text2, 0, i);
                }
                result2.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            if (result2 == null) continue;
            result2.append(text2.charAt(i));
        }
        String string2 = result2 == null ? text2 : result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        return string2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        return StringUtil.countChars(text2, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset2, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        return StringUtil.countChars(text2, c, offset2, text2.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start, int end, boolean stopAtOtherChar) {
        int i;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        int count2 = 0;
        boolean forward = start <= end;
        start = forward ? Math.max(0, start) : Math.min(text2.length(), start);
        end = forward ? Math.min(text2.length(), end) : Math.max(0, end);
        int n = i = forward ? start : start - 1;
        while (forward && i < end || !forward && i >= end) {
            if (text2.charAt(i) == c) {
                ++count2;
            } else if (stopAtOtherChar) break;
            i += forward ? 1 : -1;
        }
        return count2;
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, String className2) {
        if (packageName == null || packageName.isEmpty()) {
            return className2;
        }
        return packageName + '.' + className2;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name2) {
        if (name2 == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        StringBuilder result2 = new StringBuilder(name2.length());
        for (int i = 0; i < name2.length(); ++i) {
            char ch = name2.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        return string2;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        String string2 = StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol2) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        if (symbol2 == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol2.length();
            assert (prefixLength > 0);
            String string2 = text2.substring(0, prefixLength) + symbol2 + text2.substring(textLength - suffixLength);
            if (string2 == null) {
                StringUtil.$$$reportNull$$$0(436);
            }
            return string2;
        }
        String string3 = text2;
        if (string3 == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        return string3;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        String symbol2 = useEllipsisSymbol ? "\u2026" : "...";
        String string2 = StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtil.charsMatch(a, b, true);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String a) {
        return a == null ? null : StringUtilRt.toUpperCase(a).toString();
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(452);
        }
        String string2 = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(461);
        }
        String string2 = StringUtilRt.getShortName(fqName2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(462);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 225: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 241: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 257: 
            case 267: 
            case 270: 
            case 273: 
            case 279: 
            case 289: 
            case 296: 
            case 329: 
            case 330: 
            case 337: 
            case 339: 
            case 341: 
            case 343: 
            case 345: 
            case 347: 
            case 350: 
            case 353: 
            case 355: 
            case 358: 
            case 360: 
            case 362: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 381: 
            case 385: 
            case 387: 
            case 388: 
            case 394: 
            case 399: 
            case 406: 
            case 407: 
            case 408: 
            case 410: 
            case 413: 
            case 415: 
            case 417: 
            case 419: 
            case 421: 
            case 423: 
            case 429: 
            case 431: 
            case 433: 
            case 436: 
            case 437: 
            case 439: 
            case 441: 
            case 443: 
            case 448: 
            case 450: 
            case 453: 
            case 456: 
            case 460: 
            case 462: 
            case 464: 
            case 468: 
            case 475: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 225: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 241: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 257: 
            case 267: 
            case 270: 
            case 273: 
            case 279: 
            case 289: 
            case 296: 
            case 329: 
            case 330: 
            case 337: 
            case 339: 
            case 341: 
            case 343: 
            case 345: 
            case 347: 
            case 350: 
            case 353: 
            case 355: 
            case 358: 
            case 360: 
            case 362: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 381: 
            case 385: 
            case 387: 
            case 388: 
            case 394: 
            case 399: 
            case 406: 
            case 407: 
            case 408: 
            case 410: 
            case 413: 
            case 415: 
            case 417: 
            case 419: 
            case 421: 
            case 423: 
            case 429: 
            case 431: 
            case 433: 
            case 436: 
            case 437: 
            case 439: 
            case 441: 
            case 443: 
            case 448: 
            case 450: 
            case 453: 
            case 456: 
            case 460: 
            case 462: 
            case 464: 
            case 468: 
            case 475: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 278: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 225: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 241: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 257: 
            case 267: 
            case 270: 
            case 273: 
            case 279: 
            case 289: 
            case 296: 
            case 329: 
            case 330: 
            case 337: 
            case 339: 
            case 341: 
            case 343: 
            case 345: 
            case 347: 
            case 350: 
            case 353: 
            case 355: 
            case 358: 
            case 360: 
            case 362: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 381: 
            case 385: 
            case 387: 
            case 388: 
            case 394: 
            case 399: 
            case 406: 
            case 407: 
            case 408: 
            case 410: 
            case 413: 
            case 415: 
            case 417: 
            case 419: 
            case 421: 
            case 423: 
            case 429: 
            case 431: 
            case 433: 
            case 436: 
            case 437: 
            case 439: 
            case 441: 
            case 443: 
            case 448: 
            case 450: 
            case 453: 
            case 456: 
            case 460: 
            case 462: 
            case 464: 
            case 468: 
            case 475: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 19: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 92: 
            case 94: 
            case 125: 
            case 189: 
            case 192: 
            case 194: 
            case 242: 
            case 280: 
            case 281: 
            case 283: 
            case 285: 
            case 313: 
            case 325: 
            case 327: 
            case 331: 
            case 333: 
            case 336: 
            case 338: 
            case 340: 
            case 342: 
            case 369: 
            case 371: 
            case 373: 
            case 377: 
            case 378: 
            case 382: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 397: 
            case 400: 
            case 401: 
            case 403: 
            case 430: 
            case 432: 
            case 434: 
            case 438: 
            case 445: 
            case 446: 
            case 447: 
            case 449: 
            case 451: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 17: 
            case 62: 
            case 64: 
            case 67: 
            case 70: 
            case 87: 
            case 153: 
            case 469: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 427: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 61: 
            case 63: 
            case 66: 
            case 69: 
            case 344: 
            case 346: 
            case 349: 
            case 352: 
            case 354: 
            case 357: 
            case 359: 
            case 361: 
            case 364: 
            case 367: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 116: 
            case 119: 
            case 286: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 145: 
            case 282: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 34: 
            case 36: 
            case 461: 
            case 463: 
            case 465: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 46: 
            case 287: 
            case 290: 
            case 292: 
            case 294: 
            case 297: 
            case 425: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 47: 
            case 288: 
            case 291: 
            case 293: 
            case 295: 
            case 298: 
            case 426: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 58: 
            case 72: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 86: 
            case 97: 
            case 102: 
            case 115: 
            case 118: 
            case 122: 
            case 144: 
            case 164: 
            case 166: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 180: 
            case 184: 
            case 265: 
            case 268: 
            case 271: 
            case 274: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 311: 
            case 312: 
            case 315: 
            case 317: 
            case 319: 
            case 321: 
            case 323: 
            case 335: 
            case 393: 
            case 402: 
            case 404: 
            case 411: 
            case 412: 
            case 422: 
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 88: 
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 261: 
            case 263: 
            case 316: 
            case 318: 
            case 320: 
            case 322: 
            case 324: 
            case 376: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 113: 
            case 128: 
            case 130: 
            case 132: 
            case 136: 
            case 138: 
            case 140: 
            case 207: 
            case 276: 
            case 414: 
            case 416: 
            case 418: 
            case 420: 
            case 457: 
            case 471: 
            case 476: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 134: 
            case 142: 
            case 365: 
            case 366: 
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 148: 
            case 405: 
            case 409: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 157: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 169: 
            case 172: 
            case 175: 
            case 178: 
            case 181: 
            case 197: 
            case 200: 
            case 212: 
            case 216: 
            case 221: 
            case 224: 
            case 228: 
            case 231: 
            case 235: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 196: 
            case 199: 
            case 205: 
            case 230: 
            case 234: 
            case 237: 
            case 386: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 210: 
            case 214: 
            case 220: 
            case 222: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 211: 
            case 215: 
            case 223: 
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 229: 
            case 236: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 246: 
            case 249: 
            case 252: 
            case 254: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "units";
                break;
            }
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multipliers";
                break;
            }
            case 259: 
            case 260: 
            case 262: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 266: 
            case 275: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 269: 
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 303: 
            case 305: 
            case 307: 
            case 309: 
            case 444: 
            case 467: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 304: 
            case 306: 
            case 308: 
            case 310: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 314: 
            case 326: 
            case 328: 
            case 332: 
            case 334: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 348: 
            case 351: 
            case 356: 
            case 363: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 379: 
            case 383: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 380: 
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 395: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 396: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 398: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 428: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 440: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 452: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 458: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 459: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 466: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 470: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 472: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 474: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 477: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 478: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escapePattern";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 12: 
            case 381: 
            case 385: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromUpperCase";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromLowerCase";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "toTitleCase";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 65: 
            case 68: 
            case 71: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 151: 
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 93: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 129: 
            case 131: 
            case 133: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 137: 
            case 139: 
            case 141: 
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 154: 
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 158: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 186: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 193: 
            case 195: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 198: 
            case 201: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 225: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 241: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 204: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 206: 
            case 208: 
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 245: 
            case 247: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNumber";
                break;
            }
            case 248: 
            case 250: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 251: 
            case 253: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 257: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
            case 267: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 270: 
            case 273: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 279: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 289: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 296: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 329: 
            case 330: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 337: 
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 341: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 343: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 345: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChar";
                break;
            }
            case 347: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
            case 353: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashes";
                break;
            }
            case 355: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashes";
                break;
            }
            case 358: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlashes";
                break;
            }
            case 360: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 362: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 368: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 370: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 372: 
            case 375: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 387: 
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 394: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalsOnly";
                break;
            }
            case 399: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 406: 
            case 407: 
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 413: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 415: 
            case 417: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 419: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 421: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 423: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 429: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 431: 
            case 436: 
            case 437: 
            case 439: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 433: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMiddle";
                break;
            }
            case 441: 
            case 443: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenPathWithEllipsis";
                break;
            }
            case 448: 
            case 450: 
            case 453: 
            case 456: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 460: 
            case 462: 
            case 464: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 468: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
            case 475: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 225: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 241: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 257: 
            case 267: 
            case 270: 
            case 273: 
            case 279: 
            case 289: 
            case 296: 
            case 329: 
            case 330: 
            case 337: 
            case 339: 
            case 341: 
            case 343: 
            case 345: 
            case 347: 
            case 350: 
            case 353: 
            case 355: 
            case 358: 
            case 360: 
            case 362: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 381: 
            case 385: 
            case 387: 
            case 388: 
            case 394: 
            case 399: 
            case 406: 
            case 407: 
            case 408: 
            case 410: 
            case 413: 
            case 415: 
            case 417: 
            case 419: 
            case 421: 
            case 423: 
            case 429: 
            case 431: 
            case 433: 
            case 436: 
            case 437: 
            case 439: 
            case 441: 
            case 443: 
            case 448: 
            case 450: 
            case 453: 
            case 456: 
            case 460: 
            case 462: 
            case 464: 
            case 468: 
            case 475: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 76: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 80: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 88: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 92: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 122: 
            case 469: 
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 128: 
            case 130: 
            case 132: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 136: 
            case 138: 
            case 140: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 157: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 184: 
            case 185: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 192: 
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 210: 
            case 211: 
            case 212: 
            case 214: 
            case 215: 
            case 216: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 205: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "formatNumber";
                break;
            }
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 252: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 268: 
            case 269: 
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 276: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 281: 
            case 282: 
            case 283: 
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 290: 
            case 291: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 294: 
            case 295: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 299: 
            case 303: 
            case 304: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 300: 
            case 301: 
            case 302: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 315: 
            case 316: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 323: 
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 325: 
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 327: 
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 331: 
            case 332: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 333: 
            case 334: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 336: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 344: 
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 349: 
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 352: 
            case 356: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 354: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlashes";
                break;
            }
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 361: 
            case 363: 
            case 364: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 365: 
            case 366: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 367: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 369: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 371: 
            case 373: 
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 376: 
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 389: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 390: 
            case 391: 
            case 392: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "capitalsOnly";
                break;
            }
            case 395: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 397: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 403: 
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreCaseOccurrenceCount";
                break;
            }
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 412: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 414: 
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 418: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 425: 
            case 426: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 427: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 428: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 430: 
            case 434: 
            case 435: 
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 432: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 440: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 444: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 445: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 447: 
            case 449: 
            case 451: 
            case 452: 
            case 454: 
            case 455: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 457: 
            case 458: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 459: 
            case 461: 
            case 463: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 465: 
            case 466: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 467: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 471: 
            case 472: 
            case 473: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 474: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 476: 
            case 477: 
            case 478: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 65: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 117: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 147: 
            case 149: 
            case 151: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 182: 
            case 183: 
            case 186: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 195: 
            case 198: 
            case 201: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 213: 
            case 217: 
            case 218: 
            case 219: 
            case 225: 
            case 232: 
            case 233: 
            case 239: 
            case 240: 
            case 241: 
            case 243: 
            case 244: 
            case 245: 
            case 247: 
            case 248: 
            case 250: 
            case 251: 
            case 253: 
            case 257: 
            case 267: 
            case 270: 
            case 273: 
            case 279: 
            case 289: 
            case 296: 
            case 329: 
            case 330: 
            case 337: 
            case 339: 
            case 341: 
            case 343: 
            case 345: 
            case 347: 
            case 350: 
            case 353: 
            case 355: 
            case 358: 
            case 360: 
            case 362: 
            case 368: 
            case 370: 
            case 372: 
            case 375: 
            case 381: 
            case 385: 
            case 387: 
            case 388: 
            case 394: 
            case 399: 
            case 406: 
            case 407: 
            case 408: 
            case 410: 
            case 413: 
            case 415: 
            case 417: 
            case 419: 
            case 421: 
            case 423: 
            case 429: 
            case 431: 
            case 433: 
            case 436: 
            case 437: 
            case 439: 
            case 441: 
            case 443: 
            case 448: 
            case 450: 
            case 453: 
            case 456: 
            case 460: 
            case 462: 
            case 464: 
            case 468: 
            case 475: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();

        private MyHtml2Text() {
        }

        @Override
        public void handleText(char[] text2, int pos) {
            this.myBuffer.append(text2);
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet set2, int i) {
            this.handleTag(tag);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set2, int i) {
            this.handleTag(tag);
        }

        private void handleTag(HTML.Tag tag) {
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }
    }
}

