/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ConstantExpressionVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstantExpressionEvaluator
extends JavaRecursiveElementWalkingVisitor {
    private final Factory<ConcurrentMap<PsiElement, Object>> myMapFactory;
    private final Project myProject;
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY = Key.create("CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY");
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY = Key.create("CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY");
    private static final Object NO_VALUE = ObjectUtils.NULL;
    private final ConstantExpressionVisitor myConstantExpressionVisitor;
    private static final CachedValueProvider<ConcurrentMap<PsiElement, Object>> PROVIDER = () -> {
        ConcurrentMap value2 = ContainerUtil.createConcurrentWeakMap();
        return CachedValueProvider.Result.create(value2, PsiModificationTracker.MODIFICATION_COUNT);
    };

    private JavaConstantExpressionEvaluator(Set<PsiVariable> visitedVars, final boolean throwExceptionOnOverflow, @NotNull Project project, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (project == null) {
            JavaConstantExpressionEvaluator.$$$reportNull$$$0(0);
        }
        this.myMapFactory = auxEvaluator == null ? new Factory<ConcurrentMap<PsiElement, Object>>(){

            @Override
            public ConcurrentMap<PsiElement, Object> create() {
                Key key = throwExceptionOnOverflow ? CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY : CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY;
                return (ConcurrentMap)CachedValuesManager.getManager(JavaConstantExpressionEvaluator.this.myProject).getCachedValue(JavaConstantExpressionEvaluator.this.myProject, key, PROVIDER, false);
            }
        } : () -> auxEvaluator.getCacheMap(throwExceptionOnOverflow);
        this.myProject = project;
        this.myConstantExpressionVisitor = new ConstantExpressionVisitor(visitedVars, throwExceptionOnOverflow, auxEvaluator);
    }

    @Override
    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            JavaConstantExpressionEvaluator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        Object value2 = this.getCached((PsiExpression)element);
        if (value2 == null) {
            Object result2 = this.myConstantExpressionVisitor.handle(element);
            this.cache((PsiExpression)element, result2);
        } else {
            this.myConstantExpressionVisitor.store(element, value2 == NO_VALUE ? null : value2);
        }
    }

    @Override
    public void visitElement(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            super.visitElement(element);
            return;
        }
        Object value2 = this.getCached((PsiExpression)element);
        if (value2 == null) {
            super.visitElement(element);
        } else {
            this.myConstantExpressionVisitor.store(element, value2 == NO_VALUE ? null : value2);
        }
    }

    private Object getCached(@NotNull PsiExpression element) {
        if (element == null) {
            JavaConstantExpressionEvaluator.$$$reportNull$$$0(2);
        }
        return this.map().get(element);
    }

    private void cache(@NotNull PsiExpression element, @Nullable Object value2) {
        if (element == null) {
            JavaConstantExpressionEvaluator.$$$reportNull$$$0(3);
        }
        ConcurrencyUtil.cacheOrGet(this.map(), element, value2 == null ? NO_VALUE : value2);
    }

    @NotNull
    private ConcurrentMap<PsiElement, Object> map() {
        ConcurrentMap<PsiElement, Object> concurrentMap = this.myMapFactory.create();
        if (concurrentMap == null) {
            JavaConstantExpressionEvaluator.$$$reportNull$$$0(4);
        }
        return concurrentMap;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, visitedVars, throwExceptionOnOverflow, null);
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)expression2).getValue();
        }
        JavaConstantExpressionEvaluator evaluator = new JavaConstantExpressionEvaluator(visitedVars, throwExceptionOnOverflow, expression2.getProject(), auxEvaluator);
        if (expression2 instanceof PsiCompiledElement) {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiExpression operand = ((PsiPrefixExpression)expression2).getOperand();
                if (operand == null) {
                    return null;
                }
                Object value2 = evaluator.myConstantExpressionVisitor.handle(operand);
                evaluator.myConstantExpressionVisitor.store(operand, value2);
            }
            return evaluator.myConstantExpressionVisitor.handle(expression2);
        }
        expression2.accept(evaluator);
        Object cached = evaluator.getCached(expression2);
        return cached == NO_VALUE ? null : cached;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, null, throwExceptionOnOverflow);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaConstantExpressionEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaConstantExpressionEvaluator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "elementFinished";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

