/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(type2);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeElement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = (PsiType)CachedValuesManager.getCachedValue(this, () -> CachedValueProvider.Result.create(this.calculateType(), PsiModificationTracker.MODIFICATION_COUNT));
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType(this);
        if (inferredType != null) {
            PsiType psiType = inferredType;
            if (psiType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(3);
            }
            return psiType;
        }
        PsiType type2 = null;
        SmartList<PsiAnnotation> annotations2 = new SmartList<PsiAnnotation>();
        PsiElement parent2 = this.getParent();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations2.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type2 == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type2 = new PsiDiamondTypeImpl(this.getManager(), this);
                    break;
                }
                type2 = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken(child, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type2 == null) : this;
                String text2 = child.getText();
                type2 = annotations2.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text2) : new PsiPrimitiveType(text2, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.VAR_KEYWORD)) {
                assert (type2 == null) : this;
                type2 = this.inferVarType(parent2);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type2 == null) : this;
                type2 = new PsiClassReferenceType(this.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                assert (type2 != null) : this;
                type2 = new PsiArrayType(type2, PsiTypeElementImpl.createProvider(annotations2));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) {
                assert (type2 != null) : this;
                type2 = new PsiEllipsisType(type2, PsiTypeElementImpl.createProvider(annotations2));
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)((Object)child)).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type2 == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward(child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward(boundKind);
                type2 = PsiUtil.isJavaToken(boundKind, JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken(boundKind, JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded(this.getManager()));
                type2 = type2.annotate(PsiTypeElementImpl.createProvider(annotations2));
                break;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type2 = PsiIntersectionType.createIntersection(false, types.toArray(PsiType.createArray(types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type2 = PsiDisjunctionType.createDisjunction(types, this.getManager());
            break;
        }
        if (type2 == null) {
            PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
            if (psiPrimitiveType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(4);
            }
            return psiPrimitiveType;
        }
        if (parent2 instanceof PsiModifierListOwner) {
            type2 = JavaSharedImplUtil.applyAnnotations(type2, ((PsiModifierListOwner)parent2).getModifierList());
        }
        PsiType psiType = type2;
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    private PsiType inferVarType(PsiElement parent2) {
        if (parent2 instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)parent2).getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue != null) {
                    return JavaGenericsUtil.getCollectionItemType(iteratedValue);
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return ((PsiParameter)parent2).getType();
            }
        } else {
            for (PsiElement e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!(e instanceof PsiArrayInitializerExpression) && !PsiTypeElementImpl.isSelfReferenced((PsiExpression)e, parent2)) {
                    PsiExpression expression2 = (PsiExpression)e;
                    PsiType type2 = JavaVarTypeUtil.ourVarGuard.doPreventingRecursion(expression2, true, () -> expression2.getType());
                    return type2 == null ? null : JavaVarTypeUtil.getUpwardProjection(type2);
                }
                return null;
            }
        }
        return null;
    }

    private static boolean isSelfReferenced(@NotNull PsiExpression initializer2, PsiElement parent2) {
        if (initializer2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(6);
        }
        class SelfReferenceVisitor
        extends JavaRecursiveElementVisitor {
            private boolean referenced;
            final /* synthetic */ PsiElement val$parent;

            SelfReferenceVisitor(PsiElement psiElement) {
                this.val$parent = psiElement;
            }

            @Override
            public void visitElement(PsiElement element) {
                if (this.referenced) {
                    return;
                }
                super.visitElement(element);
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.resolve() == this.val$parent) {
                    this.referenced = true;
                }
            }
        }
        SelfReferenceVisitor visitor2 = new SelfReferenceVisitor(parent2);
        initializer2.accept(visitor2);
        return visitor2.referenced;
    }

    @Override
    public boolean isInferredType() {
        PsiElement firstChild = this.getFirstChild();
        return PsiUtil.isJavaToken(firstChild, JavaTokenType.VAR_KEYWORD);
    }

    @NotNull
    private Computable<PsiJavaCodeReferenceElement> getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent2;
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(7);
        }
        if ((parent2 = this.getParent()) instanceof PsiMethod || parent2 instanceof PsiVariable) {
            Computable<PsiJavaCodeReferenceElement> computable = PsiTypeElementImpl.computeFromTypeOwner(parent2, new WeakReference<PsiJavaCodeReferenceElement>(ref));
            if (computable == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(8);
            }
            return computable;
        }
        Computable.PredefinedValueComputable<PsiJavaCodeReferenceElement> predefinedValueComputable = new Computable.PredefinedValueComputable<PsiJavaCodeReferenceElement>(ref);
        if (predefinedValueComputable == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(9);
        }
        return predefinedValueComputable;
    }

    @NotNull
    private static Computable<PsiJavaCodeReferenceElement> computeFromTypeOwner(final PsiElement parent2, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(10);
        }
        Computable<PsiJavaCodeReferenceElement> computable = new Computable<PsiJavaCodeReferenceElement>(){
            volatile WeakReference<PsiJavaCodeReferenceElement> myCache;
            {
                this.myCache = ref;
            }

            @Override
            public PsiJavaCodeReferenceElement compute() {
                PsiJavaCodeReferenceElement result2 = (PsiJavaCodeReferenceElement)this.myCache.get();
                if (result2 == null) {
                    result2 = this.getParentTypeElement().getReferenceElement();
                    this.myCache = new WeakReference<PsiJavaCodeReferenceElement>(result2);
                }
                return result2;
            }

            @NotNull
            private PsiTypeElementImpl getParentTypeElement() {
                PsiTypeElement typeElement = parent2 instanceof PsiMethod ? ((PsiMethod)parent2).getReturnTypeElement() : ((PsiVariable)parent2).getTypeElement();
                PsiTypeElementImpl psiTypeElementImpl = (PsiTypeElementImpl)ObjectUtils.assertNotNull(typeElement);
                if (psiTypeElementImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiTypeElementImpl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl$1", "getParentTypeElement"));
            }
        };
        if (computable == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(11);
        }
        return computable;
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations2) {
        if (annotations2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(12);
        }
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create(ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true));
        if (typeAnnotationProvider == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    @NotNull
    private List<PsiType> collectTypes() {
        List<PsiTypeElement> typeElements = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiTypeElement.class);
        List<PsiType> list2 = ContainerUtil.map(typeElements, typeElement -> typeElement.getType());
        if (list2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(15);
        }
        if (state2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(17);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations2 != null ? annotations2 : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(18);
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(19);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName2) {
        if (qualifiedName2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(20);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName2);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName2) {
        if (qualifiedName2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result2;
        if (newElement == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(22);
        }
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result2 = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result2);
        }
        return result2;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComputable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFromTypeOwner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelfReferenced";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComputable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeFromTypeOwner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

