/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private final AtomicReferenceArray<Map> myPhysicalMaps;
    private final AtomicReferenceArray<Map> myNonPhysicalMaps;
    private final RecursionGuard myGuard;
    private static final Object NULL_RESULT = ObjectUtils.sentinel("ResolveCache.NULL_RESULT");
    private static final StrongValueReference NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return ServiceManager.getService(project, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            ResolveCache.$$$reportNull$$$0(0);
        }
        this.myPhysicalMaps = new AtomicReferenceArray(4);
        this.myNonPhysicalMaps = new AtomicReferenceArray(4);
        this.myGuard = RecursionManager.createGuard("resolveCache");
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    @NotNull
    private static <K, V> Map<K, V> createWeakMap() {
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @Override
            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue2) {
                if (value2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (queue2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                ConcurrentWeakKeySoftValueHashMap.ValueReference result2 = value2 == NULL_RESULT || value2 instanceof Object[] && ((Object[])value2).length == 0 ? ResolveCache.createStrongReference(value2) : super.createValueReference(value2, queue2);
                StrongValueReference strongValueReference = result2;
                if (strongValueReference == null) {
                    2.$$$reportNull$$$0(2);
                }
                return strongValueReference;
            }

            @Override
            public V get(@NotNull Object key) {
                Object v2;
                if (key == null) {
                    2.$$$reportNull$$$0(3);
                }
                return (v2 = super.get(key)) == NULL_RESULT ? null : (Object)v2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "queue";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/source/resolve/ResolveCache$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/source/resolve/ResolveCache$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValueReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createValueReference";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "get";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (concurrentWeakKeySoftValueHashMap == null) {
            ResolveCache.$$$reportNull$$$0(1);
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    public void clearCache(boolean isPhysical) {
        if (isPhysical) {
            ResolveCache.clearArray(this.myPhysicalMaps);
        }
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    private static void clearArray(AtomicReferenceArray<?> array2) {
        for (int i = 0; i < array2.length(); ++i) {
            array2.set(i, null);
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<? super TRef, TResult> resolver2, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        int index2;
        Map<TRef, TResult> map2;
        TResult result2;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(2);
        }
        if (resolver2 == null) {
            ResolveCache.$$$reportNull$$$0(3);
        }
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if ((result2 = (map2 = this.getMap(isPhysical, index2 = ResolveCache.getIndex(incompleteCode, isPoly))).get(ref)) != null) {
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        Object object = result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion(Trinity.create(ref, incompleteCode, isPoly), true, () -> {
            if (resolver2 == null) {
                ResolveCache.$$$reportNull$$$0(27);
            }
            if (ref == null) {
                ResolveCache.$$$reportNull$$$0(28);
            }
            return resolver2.resolve(ref, incompleteCode);
        }) : resolver2.resolve(ref, incompleteCode);
        if (result2 instanceof ResolveResult) {
            ResolveCache.ensureValidPsi((ResolveResult)result2);
        } else if (result2 instanceof ResolveResult[]) {
            ResolveCache.ensureValidResults((ResolveResult[])result2);
        } else if (result2 instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)result2);
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver2, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(4);
        }
        if (resolver2 == null) {
            ResolveCache.$$$reportNull$$$0(5);
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver2, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver2, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ResolveResult[] result2;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(7);
        }
        if (resolver2 == null) {
            ResolveCache.$$$reportNull$$$0(8);
        }
        if (containingFile == null) {
            ResolveCache.$$$reportNull$$$0(9);
        }
        ResolveResult[] resolveResultArray = (result2 = (ResolveResult[])this.resolve(ref, resolver2, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical())) == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(10);
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver2, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(11);
        }
        if (resolver2 == null) {
            ResolveCache.$$$reportNull$$$0(12);
        }
        if (containingFile == null) {
            ResolveCache.$$$reportNull$$$0(13);
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = containingFile.isPhysical();
        int index2 = ResolveCache.getIndex(incompleteCode, true);
        Map map2 = this.getMap(physical, index2);
        ResolveResult[] result2 = (ResolveResult[])map2.get(ref);
        if (result2 != null) {
            if (result2 == null) {
                ResolveCache.$$$reportNull$$$0(14);
            }
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        ResolveResult[] resolveResultArray = result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion(Pair.create(ref, incompleteCode), true, () -> {
            if (resolver2 == null) {
                ResolveCache.$$$reportNull$$$0(24);
            }
            if (ref == null) {
                ResolveCache.$$$reportNull$$$0(25);
            }
            if (containingFile == null) {
                ResolveCache.$$$reportNull$$$0(26);
            }
            return resolver2.resolve(ref, containingFile, incompleteCode);
        }) : resolver2.resolve(ref, containingFile, incompleteCode);
        if (result2 != null) {
            ResolveCache.ensureValidResults(result2);
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        ResolveResult[] resolveResultArray2 = result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray2 == null) {
            ResolveCache.$$$reportNull$$$0(15);
        }
        return resolveResultArray2;
    }

    private static void ensureValidResults(ResolveResult[] result2) {
        for (ResolveResult resolveResult : result2) {
            ResolveCache.ensureValidPsi(resolveResult);
        }
    }

    private static void ensureValidPsi(ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element != null) {
            PsiUtilCore.ensureValid(element);
        }
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(16);
        }
        Map map2 = this.getMap(physical, ResolveCache.getIndex(incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver2, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(17);
        }
        if (resolver2 == null) {
            ResolveCache.$$$reportNull$$$0(18);
        }
        return this.resolve(ref, resolver2, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> Map<TRef, TResult> getMap(boolean physical, int index2) {
        AtomicReferenceArray<Map> array2 = physical ? this.myPhysicalMaps : this.myNonPhysicalMaps;
        Map map2 = array2.get(index2);
        while (map2 == null) {
            Map newMap = ResolveCache.createWeakMap();
            map2 = array2.compareAndSet(index2, null, newMap) ? newMap : array2.get(index2);
        }
        Map map3 = map2;
        if (map3 == null) {
            ResolveCache.$$$reportNull$$$0(19);
        }
        return map3;
    }

    private static int getIndex(boolean incompleteCode, boolean isPoly) {
        return (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull Map<? super TRef, TResult> map2, TResult result2) {
        Object cached;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(20);
        }
        if (map2 == null) {
            ResolveCache.$$$reportNull$$$0(21);
        }
        if ((cached = map2.get(ref)) != null && cached == result2) {
            return;
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value2) {
        if (value2 == null) {
            ResolveCache.$$$reportNull$$$0(22);
        }
        StrongValueReference strongValueReference = value2 == NULL_RESULT ? NULL_VALUE_REFERENCE : (value2 == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value2));
        if (strongValueReference == null) {
            ResolveCache.$$$reportNull$$$0(23);
        }
        return strongValueReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/ResolveCache";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 17: 
            case 20: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 18: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 9: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/ResolveCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithCaching";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createStrongReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 23: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithCaching";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResults";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createStrongReference";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveWithCaching$1";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolve$0";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        StrongValueReference(@NotNull V value2) {
            if (value2 == null) {
                StrongValueReference.$$$reportNull$$$0(0);
            }
            this.myValue = value2;
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/source/resolve/ResolveCache$StrongValueReference", "<init>"));
        }
    }

    @FunctionalInterface
    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    @FunctionalInterface
    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    @FunctionalInterface
    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    @FunctionalInterface
    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

