/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance(InferenceSessionContainer.class);
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    InferenceSessionContainer() {
    }

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, PsiType returnType2, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession = this.findNestedSubstitutor(((PsiCallExpression)returnExpression).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType2, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession.getInferenceVariables(), inferenceSession.getRestoreNameSubstitution());
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        PsiCall topLevelCall;
        PsiExpressionList argumentList2;
        MethodCandidateInfo.CurrentCandidateProperties properties2;
        if (typeParameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(1);
        }
        if (arguments2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(2);
        }
        if (partialSubstitutor == null) {
            InferenceSessionContainer.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(4);
        }
        if (policy == null) {
            InferenceSessionContainer.$$$reportNull$$$0(5);
        }
        if (parent2 instanceof PsiCall && (properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2 = ((PsiCall)parent2).getArgumentList())) != null && !properties2.isApplicabilityCheck() && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argumentList2) && (topLevelCall = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(parent2, false, () -> {
            if (parent2 == null) {
                InferenceSessionContainer.$$$reportNull$$$0(12);
            }
            if (parent2 instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent2)) {
                return null;
            }
            return LambdaUtil.treeWalkUp(parent2);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || LambdaUtil.isLambdaParameterCheck() || !policy.equals(DefaultParameterTypeInferencePolicy.INSTANCE)) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue(topLevelCall, () -> new CachedValueProvider.Result<InferenceSession>(InferenceSessionContainer.startTopLevelInference(topLevelCall, DefaultParameterTypeInferencePolicy.INSTANCE), PsiModificationTracker.MODIFICATION_COUNT));
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent2)) != null) {
                    for (PsiTypeParameter parameter : typeParameters2) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(parameters2, arguments2, (PsiCall)parent2, properties2, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
            } else if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy).prepareSubstitution();
            }
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters2, partialSubstitutor, parent2.getManager(), parent2, policy);
        inferenceSession.initExpressionConstraints(parameters2, arguments2, parent2);
        return inferenceSession.infer(parameters2, arguments2, parent2);
    }

    private static PsiSubstitutor inferNested(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiCall parent2, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull InferenceSession parentSession) {
        CompoundInitialState compoundInitialState;
        InitialInferenceState initialInferenceState;
        if (parameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(6);
        }
        if (arguments2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(7);
        }
        if (parent2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(8);
        }
        if (properties2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(9);
        }
        if (parentSession == null) {
            InferenceSessionContainer.$$$reportNull$$$0(10);
        }
        if ((initialInferenceState = (compoundInitialState = InferenceSessionContainer.createState(parentSession)).getInitialState(parent2)) != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState);
            List<String> errorMessages = parentSession.getIncompatibleErrorMessages();
            if (errorMessages != null) {
                PsiMethod outerCallerMethod;
                PsiElement context = parentSession.getContext();
                if (context instanceof PsiCallExpression && (outerCallerMethod = ((PsiCallExpression)context).resolveMethod()) != null && outerCallerMethod.hasTypeParameters()) {
                    return properties2.getInfo().getSubstitutor(false);
                }
                return childSession.prepareSubstitution();
            }
            return childSession.collectAdditionalAndInfer(parameters2, arguments2, properties2, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent2.getParent());
        while (true) {
            PsiCall call2;
            PsiElement returnContainer;
            if (gParent instanceof PsiReturnStatement && (returnContainer = gParent.getParent()) instanceof PsiCodeBlock) {
                gParent = returnContainer.getParent();
            }
            if (gParent instanceof PsiConditionalExpression) {
                gParent = PsiUtil.skipParenthesizedExprUp(gParent.getParent());
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call2 = PsiTreeUtil.getParentOfType(gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call2);
            if (initialInferenceState != null) {
                PsiExpressionList argumentList2 = call2.getArgumentList();
                int idx = LambdaUtil.getLambdaIdx(argumentList2, gParent);
                JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(call2);
                PsiElement method = result2.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1) break;
                LOG.assertTrue(argumentList2 != null);
                PsiParameter[] methodParameters = ((PsiMethod)method).getParameterList().getParameters();
                if (methodParameters.length == 0) break;
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState);
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList2.getExpressions(), ((MethodCandidateInfo)result2).createProperties(), compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(parameters2, arguments2, parent2, properties2, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy2 = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor2 = super.findNestedSubstitutor(arg, null);
                if (substitutor2 != null) {
                    return substitutor2;
                }
                InitialInferenceState state2 = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
                if (state2 != null) {
                    return state2.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy2, topLevelSession.getInferenceVariables(), topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable2 : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable2.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly(topInferenceSubstitutor.substitute(variable2))) instanceof InferenceVariable)) continue;
            substitutor2 = substitutor2.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor2, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy) {
        JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult(topLevelCall);
        if (result2 instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result2).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result2).getSiteSubstitutor(), topLevelCall.getManager(), topLevelCall, policy);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, topLevelCall, method, ((MethodCandidateInfo)result2).isVarargs());
                topLevelSession.infer(topLevelParameters, topLevelArguments, topLevelCall, ((MethodCandidateInfo)result2).createProperties());
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable2 : oldVars = inferenceVariables.toArray(new InferenceVariable[0])) {
            InferenceVariable newVariable = new InferenceVariable(variable2.getCallContext(), variable2.getParameter(), variable2.getName());
            substitutor2 = substitutor2.put(variable2, JavaPsiFacade.getElementFactory(variable2.getProject()).createType(newVariable));
            targetVars.add(newVariable);
            if (variable2.isThrownBound()) {
                newVariable.setThrownBound();
            }
            newVariable.putUserData(InferenceSession.ORIGINAL_CAPTURE, variable2.getUserData(InferenceSession.ORIGINAL_CAPTURE));
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = (InferenceVariable)targetVars.get(i);
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor2.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            InferenceSessionContainer.$$$reportNull$$$0(11);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSession";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "infer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "inferNested";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$infer$0";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

