/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPresentationUtil {
    private JavaPresentationUtil() {
    }

    @NotNull
    public static ColoredItemPresentation getMethodPresentation(final @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JavaPresentationUtil.$$$reportNull$$$0(0);
        }
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 257, 2);
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiMethod.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiMethod);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiMethod.getIcon(1);
            }
        };
        if (coloredItemPresentation == null) {
            JavaPresentationUtil.$$$reportNull$$$0(1);
        }
        return coloredItemPresentation;
    }

    @NotNull
    public static ItemPresentation getFieldPresentation(final @NotNull PsiField psiField) {
        if (psiField == null) {
            JavaPresentationUtil.$$$reportNull$$$0(2);
        }
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            public String getPresentableText() {
                return psiField.getName();
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiField.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            public String getLocationString() {
                return JavaPresentationUtil.getJavaSymbolContainerText(psiField);
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiField.getIcon(1);
            }
        };
        if (coloredItemPresentation == null) {
            JavaPresentationUtil.$$$reportNull$$$0(3);
        }
        return coloredItemPresentation;
    }

    @Nullable
    private static String getJavaSymbolContainerText(@NotNull PsiElement element) {
        String qName;
        Object container2;
        if (element == null) {
            JavaPresentationUtil.$$$reportNull$$$0(4);
        }
        String result2 = (container2 = PsiTreeUtil.getParentOfType(element, PsiMember.class, PsiFile.class)) instanceof PsiClass ? ((qName = ((PsiClass)container2).getQualifiedName()) != null ? qName : ((PsiClass)container2).getName()) : (container2 instanceof PsiJavaFile ? ((PsiJavaFile)container2).getPackageName() : null);
        if (result2 != null) {
            return PsiBundle.message("aux.context.display", result2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/presentation/java/JavaPresentationUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/presentation/java/JavaPresentationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodPresentation";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFieldPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJavaSymbolContainerText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

