/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(@NotNull Project project, @NotNull FileIndexFacade fileIndex) {
        if (project == null) {
            ProjectScopeImpl.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            ProjectScopeImpl.$$$reportNull$$$0(1);
        }
        super(project);
        this.myFileIndex = fileIndex;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(2);
        }
        if (file2 instanceof VirtualFileWindow) {
            return true;
        }
        if (this.myFileIndex.isInLibraryClasses(file2) && !this.myFileIndex.isInSourceContent(file2)) {
            return false;
        }
        return this.myFileIndex.isInContent(file2);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(4);
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            ProjectScopeImpl.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string2 = PsiBundle.message("psi.search.scope.project", new Object[0]);
        if (string2 == null) {
            ProjectScopeImpl.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public Collection<Object> getUnloadedModulesBelongingToScope() {
        return this.myFileIndex.getUnloadedModuleDescriptions();
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(7);
        }
        if (scope == this || !scope.isSearchInLibraries() || !scope.isSearchOutsideRootModel()) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                ProjectScopeImpl.$$$reportNull$$$0(8);
            }
            return projectScopeImpl;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(10);
        }
        if (scope == this) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                ProjectScopeImpl.$$$reportNull$$$0(11);
            }
            return projectScopeImpl;
        }
        if (!scope.isSearchInLibraries()) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                ProjectScopeImpl.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            ProjectScopeImpl.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/ProjectScopeImpl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/ProjectScopeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

