/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        while (true) {
            if (e.getCause() == null) {
                Throwable throwable = e;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(1);
                }
                return throwable;
            }
            e = e.getCause();
        }
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (relativeTo == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        return throwable;
    }

    @NotNull
    public static String currentStackTrace() {
        String string2 = ExceptionUtil.getThrowableText(new Throwable());
        if (string2 == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        aThrowable.printStackTrace(writer);
        String string2 = stringWriter.getBuffer().toString();
        if (string2 == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtil.rethrow(t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStackTrace";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

