/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyInitializer {

    public static abstract class NotNullValue<T>
    extends NullableValue<T> {
        @Override
        @NotNull
        public T get() {
            Object t = super.get();
            if (t == null) {
                NotNullValue.$$$reportNull$$$0(0);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/LazyInitializer$NotNullValue", "get"));
        }
    }

    public static abstract class NullableValue<T> {
        protected volatile T value;
        private volatile Initializer initializer = new Initializer();

        @Nullable
        public abstract T initialize();

        @Nullable
        public T get() {
            Initializer init2 = this.initializer;
            if (init2 != null) {
                init2.lock.lock();
                try {
                    if (init2.lock.getHoldCount() > 1) {
                        T t = null;
                        return t;
                    }
                    if (this.initializer != null) {
                        this.value = this.initializer.init();
                        this.initializer = null;
                    }
                }
                finally {
                    init2.lock.unlock();
                }
                this.onInitialized(this.value);
            }
            return this.value;
        }

        public final boolean isNotNull() {
            return this.get() != null;
        }

        protected void onInitialized(T value2) {
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        private class Initializer {
            private final ReentrantLock lock = new ReentrantLock();

            private Initializer() {
            }

            T init() {
                try {
                    return NullableValue.this.initialize();
                }
                catch (Exception e) {
                    Logger.getInstance(LazyInitializer.class).error(e);
                    return null;
                }
            }
        }
    }
}

