/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.IndexId;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final IntObjectMap<ID> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();
    private final short myUniqueId;

    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    protected ID(String name2) {
        super(name2);
        this.myUniqueId = ID.stringToId(name2);
        ID old = ourRegistry.put(this.myUniqueId, this);
        assert (old == null) : "ID with name '" + name2 + "' is already registered";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short stringToId(String name2) {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            if (ourNameToIdRegistry.containsKey(name2)) {
                return (short)ourNameToIdRegistry.get(name2);
            }
            int n = ourNameToIdRegistry.size() + 1;
            assert (n <= Short.MAX_VALUE) : "Number of indices exceeded";
            ourNameToIdRegistry.put(name2, n);
            ID.writeEnumFile();
            return (short)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitializeDiskStorage() {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            ID.writeEnumFile();
        }
    }

    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
                String[] names2 = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry((key, value2) -> {
                    names2[value2 - 1] = key;
                    return true;
                });
                for (String name2 : names2) {
                    w.write(name2);
                    w.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name2) {
        ID<K, V> found;
        if (name2 == null) {
            ID.$$$reportNull$$$0(0);
        }
        ID<K, V> iD = (found = ID.findByName(name2)) != null ? found : new ID<K, V>(name2);
        if (iD == null) {
            ID.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name2) {
        if (name2 == null) {
            ID.$$$reportNull$$$0(2);
        }
        return ID.findById(ID.stringToId(name2));
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public String toString() {
        return this.getName();
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public static ID<?, ?> findById(int id) {
        return ourRegistry.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            TObjectIntHashMap<String> nameToIdRegistry = new TObjectIntHashMap<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(indices));){
                int cnt = 0;
                while (true) {
                    ++cnt;
                    String name3 = reader.readLine();
                    if (name3 == null) {
                        break;
                    }
                    nameToIdRegistry.put(name3, cnt);
                }
            }
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.ensureCapacity(nameToIdRegistry.size());
                nameToIdRegistry.forEachEntry((name2, index2) -> {
                    ourNameToIdRegistry.put((String)name2, index2);
                    return true;
                });
            }
        }
        catch (IOException e) {
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.clear();
                ID.writeEnumFile();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

