/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BloomFilterBase;
import com.intellij.util.lang.IntObjectHashMap;
import com.intellij.util.lang.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.Nullable;

public class ClasspathCache {
    private final IntObjectHashMap myResourcePackagesCache = new IntObjectHashMap();
    private final IntObjectHashMap myClassPackagesCache = new IntObjectHashMap();
    private Map<String, Object> myResources2LoadersTempMap = new HashMap<String, Object>();
    private Name2LoaderFilter myNameFilter;
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyLoaderData(LoaderData loaderData, Loader loader) {
        this.myLock.writeLock().lock();
        try {
            for (String resourceEntry : loaderData.myResourcePaths) {
                this.addResourceEntry(resourceEntry, loader);
            }
            for (String name2 : loaderData.myNames) {
                this.addNameEntry(name2, loader);
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <ResultType, ParameterType, ParameterType2> ResultType iterateLoaders(String resourcePath, LoaderIterator<ResultType, ParameterType, ParameterType2> iterator2, ParameterType parameter, ParameterType2 parameter2) {
        this.myLock.readLock().lock();
        try {
            Loader[] loaders;
            IntObjectHashMap map2 = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
            String packageName = ClasspathCache.getPackageName(resourcePath);
            int hash = packageName.hashCode();
            Object o = map2.get(hash);
            if (o == null) {
                ResultType ResultType = null;
                return ResultType;
            }
            if (o instanceof Loader) {
                ResultType ResultType = iterator2.process((Loader)o, parameter, parameter2);
                return ResultType;
            }
            for (Loader l : loaders = (Loader[])o) {
                ResultType result2 = iterator2.process(l, parameter, parameter2);
                if (result2 == null) continue;
                ResultType ResultType = result2;
                return ResultType;
            }
            Loader[] loaderArray = null;
            return (ResultType)loaderArray;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private static String getPackageName(String resourcePath) {
        int idx = resourcePath.lastIndexOf(47);
        return idx > 0 ? resourcePath.substring(0, idx) : "";
    }

    private void addResourceEntry(String resourcePath, Loader loader) {
        int hash;
        String packageName = ClasspathCache.getPackageName(resourcePath);
        IntObjectHashMap map2 = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
        Object o = map2.get(hash = packageName.hashCode());
        if (o == null) {
            map2.put(hash, loader);
        } else if (o instanceof Loader) {
            if (o != loader) {
                map2.put(hash, new Loader[]{(Loader)o, loader});
            }
        } else {
            Loader[] loadersArray;
            for (Loader l : loadersArray = (Loader[])o) {
                if (l != loader) continue;
                return;
            }
            map2.put(hash, ArrayUtil.append(loadersArray, loader));
        }
    }

    private void addNameEntry(String name2, Loader loader) {
        name2 = ClasspathCache.transformName(name2);
        if (this.myNameFilter == null) {
            Object loaders = this.myResources2LoadersTempMap.get(name2);
            if (loaders == null) {
                this.myResources2LoadersTempMap.put(name2, loader);
            } else if (loaders instanceof Loader && loaders != loader) {
                this.myResources2LoadersTempMap.put(name2, new Loader[]{(Loader)loaders, loader});
            } else if (loaders instanceof Loader[]) {
                boolean weHaveThisLoader = false;
                for (Loader existing : (Loader[])loaders) {
                    if (existing != loader) continue;
                    weHaveThisLoader = true;
                    break;
                }
                if (!weHaveThisLoader) {
                    this.myResources2LoadersTempMap.put(name2, ArrayUtil.append((Loader[])loaders, loader));
                }
            }
        } else {
            this.myNameFilter.add(name2, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loaderHasName(String name2, String shortName, Loader loader) {
        if (StringUtil.isEmpty(name2)) {
            return true;
        }
        this.myLock.readLock().lock();
        try {
            boolean result2;
            if (this.myNameFilter == null) {
                Object loaders = this.myResources2LoadersTempMap.get(shortName);
                result2 = ClasspathCache.contains(loader, loaders);
            } else {
                result2 = this.myNameFilter.maybeContains(shortName, loader);
            }
            boolean bl = result2;
            return bl;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private static boolean contains(Loader loader, Object loaders) {
        if (loaders == null) {
            return false;
        }
        boolean result2 = false;
        if (loaders == loader) {
            result2 = true;
        } else if (loaders instanceof Loader[]) {
            for (Loader existing : (Loader[])loaders) {
                if (existing != loader) continue;
                result2 = true;
                break;
            }
        }
        return result2;
    }

    static String transformName(String name2) {
        name2 = StringUtil.trimEnd(name2, "/");
        if ((name2 = name2.substring(name2.lastIndexOf(47) + 1)).endsWith(".class")) {
            String name1 = name2;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index2 = name1.lastIndexOf(46);
                if (index2 >= 0) {
                    name1 = name1.substring(0, index2);
                }
            }
            name2 = name1;
        }
        return name2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nameSymbolsLoaded() {
        this.myLock.writeLock().lock();
        try {
            if (this.myNameFilter != null) {
                return;
            }
            int nBits = 0;
            int uniques = 0;
            for (Map.Entry<String, Object> e : this.myResources2LoadersTempMap.entrySet()) {
                int size;
                int n = size = e.getValue() instanceof Loader[] ? ((Loader[])e.getValue()).length : 1;
                if (size == 1) {
                    ++uniques;
                }
                nBits += size;
            }
            if (nBits > 20000) {
                nBits += (int)((double)nBits * 0.03);
            }
            Name2LoaderFilter name2LoaderFilter = new Name2LoaderFilter(nBits, 0.005);
            for (Map.Entry<String, Object> e : this.myResources2LoadersTempMap.entrySet()) {
                String name2 = e.getKey();
                Object value2 = e.getValue();
                if (value2 instanceof Loader) {
                    name2LoaderFilter.add(name2, (Loader)value2);
                    continue;
                }
                for (Loader loader : (Loader[])value2) {
                    name2LoaderFilter.add(name2, loader);
                }
            }
            this.myNameFilter = name2LoaderFilter;
            this.myResources2LoadersTempMap = null;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private static class Name2LoaderFilter
    extends BloomFilterBase {
        Name2LoaderFilter(int nBits, double probability) {
            super(nBits, probability);
        }

        private boolean maybeContains(String name2, Loader loader) {
            int hash = Name2LoaderFilter.hashFromNameAndLoader(name2, loader, StringHash.murmur(name2, 31));
            int hash2 = Name2LoaderFilter.hashFromNameAndLoader(name2, loader, hash);
            return this.maybeContains(hash, hash2);
        }

        private void add(String name2, Loader loader) {
            int hash = Name2LoaderFilter.hashFromNameAndLoader(name2, loader, StringHash.murmur(name2, 31));
            int hash2 = Name2LoaderFilter.hashFromNameAndLoader(name2, loader, hash);
            this.addIt(hash, hash2);
        }

        private static int hashFromNameAndLoader(String name2, Loader loader, int n) {
            int hash = StringHash.murmur(name2, n);
            for (int i = loader.getIndex(); i > 0; i /= 10) {
                hash = hash * n + (i % 10 + 48);
            }
            return hash;
        }
    }

    static abstract class LoaderIterator<ResultType, ParameterType, ParameterType2> {
        LoaderIterator() {
        }

        @Nullable
        abstract ResultType process(Loader var1, ParameterType var2, ParameterType2 var3);
    }

    static class LoaderData {
        private final List<String> myResourcePaths = new ArrayList<String>();
        private final List<String> myNames = new ArrayList<String>();

        LoaderData() {
        }

        public void addResourceEntry(String resourcePath) {
            this.myResourcePaths.add(resourcePath);
        }

        public void addNameEntry(String name2) {
            this.myNames.add(ClasspathCache.transformName(name2));
        }

        List<String> getResourcePaths() {
            return this.myResourcePaths;
        }

        List<String> getNames() {
            return this.myNames;
        }
    }
}

