/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapBinding
extends Binding
implements MultiNodeBinding {
    private static final Comparator<Object> KEY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                Comparable c2 = (Comparable)o2;
                return c1.compareTo(c2);
            }
            return 0;
        }
    };
    private final MapAnnotation oldAnnotation;
    private final XMap annotation;
    @NotNull
    private final Class<? extends Map> mapClass;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;

    public MapBinding(@Nullable MutableAccessor accessor, @NotNull Class<? extends Map> mapClass) {
        if (mapClass == null) {
            MapBinding.$$$reportNull$$$0(0);
        }
        super(accessor);
        this.oldAnnotation = accessor == null ? null : accessor.getAnnotation(MapAnnotation.class);
        this.annotation = accessor == null ? null : accessor.getAnnotation(XMap.class);
        this.mapClass = mapClass;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        if (originalType == null) {
            MapBinding.$$$reportNull$$$0(1);
        }
        if (serializer == null) {
            MapBinding.$$$reportNull$$$0(2);
        }
        ParameterizedType type2 = (ParameterizedType)originalType;
        Type[] typeArguments2 = type2.getActualTypeArguments();
        this.keyClass = XmlSerializerImpl.typeToClass(typeArguments2[0]);
        this.valueClass = XmlSerializerImpl.typeToClass(typeArguments2[1]);
        this.keyBinding = serializer.getBinding(this.keyClass, typeArguments2[0]);
        this.valueBinding = serializer.getBinding(this.valueClass, typeArguments2[1]);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    protected boolean isSurroundWithTag() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundWithTag();
    }

    @NotNull
    String getEntryElementName() {
        if (this.annotation != null) {
            String string2 = this.annotation.entryTagName();
            if (string2 == null) {
                MapBinding.$$$reportNull$$$0(4);
            }
            return string2;
        }
        String string3 = this.oldAnnotation == null ? "entry" : this.oldAnnotation.entryTagName();
        if (string3 == null) {
            MapBinding.$$$reportNull$$$0(5);
        }
        return string3;
    }

    private String getKeyAttributeName() {
        if (this.annotation != null) {
            return this.annotation.keyAttributeName();
        }
        return this.oldAnnotation == null ? "key" : this.oldAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        if (this.annotation != null) {
            return this.annotation.valueAttributeName();
        }
        return this.oldAnnotation == null ? "value" : this.oldAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<Element> elements) {
        List<Element> childNodes;
        if (elements == null) {
            MapBinding.$$$reportNull$$$0(6);
        }
        if (this.isSurroundWithTag()) {
            assert (elements.size() == 1);
            childNodes = elements.get(0).getChildren();
        } else {
            childNodes = elements;
        }
        return this.deserialize(context, childNodes);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    private Map deserialize(@Nullable Object context, @NotNull List<Element> childNodes) {
        Map<Object, Object> map2;
        if (childNodes == null) {
            MapBinding.$$$reportNull$$$0(9);
        }
        THashMap<Object, Object> tHashMap = map2 = this.myAccessor == null ? null : (THashMap<Object, Object>)context;
        if (map2 != null) {
            map2.clear();
        }
        for (Element childNode : childNodes) {
            if (!childNode.getName().equals(this.getEntryElementName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + childNode);
                continue;
            }
            if (map2 == null) {
                if (this.mapClass == Map.class) {
                    map2 = new THashMap<Object, Object>();
                } else {
                    try {
                        map2 = ReflectionUtil.newInstance(this.mapClass);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                        map2 = new THashMap();
                    }
                }
            }
            map2.put(this.deserializeKeyOrValue(childNode, this.getKeyAttributeName(), context, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(childNode, this.getValueAttributeName(), context, this.valueBinding, this.valueClass));
        }
        return map2;
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        Attribute attribute;
        if (entry == null) {
            MapBinding.$$$reportNull$$$0(12);
        }
        if (attributeName == null) {
            MapBinding.$$$reportNull$$$0(13);
        }
        if (valueClass == null) {
            MapBinding.$$$reportNull$$$0(14);
        }
        if ((attribute = entry.getAttribute(attributeName)) != null) {
            return XmlSerializerImpl.convert(attribute.getValue(), valueClass);
        }
        if (!this.isSurroundKey()) {
            assert (binding != null);
            for (Element element : entry.getChildren()) {
                if (!binding.isBoundTo(element)) continue;
                return binding.deserializeUnsafe(context, element);
            }
        } else {
            List<Object> children2;
            Element entryChild = entry.getChild(attributeName);
            List<Object> list2 = children2 = entryChild == null ? Collections.emptyList() : entryChild.getChildren();
            if (children2.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, null, children2);
        }
        return null;
    }

    private boolean isSurroundKey() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundKeyWithTag();
    }

    boolean isBoundToWithoutProperty(@NotNull Element element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(15);
        }
        String elementName = element.getName();
        if (this.annotation != null) {
            return elementName.equals(this.annotation.entryTagName());
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return elementName.equals(this.oldAnnotation.entryTagName());
        }
        return elementName.equals("map");
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(16);
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return this.oldAnnotation.entryTagName().equals(element.getName());
        }
        if (this.annotation != null) {
            return this.annotation.propertyElementName().equals(element.getName());
        }
        return element.getName().equals("map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNodes";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serializeKeyOrValue";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKeyOrValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBoundToWithoutProperty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

