/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.generator.nova;

import com.jetbrains.rider.generator.nova.GenerationSpec;
import com.jetbrains.rider.generator.nova.IGenerator;
import com.jetbrains.rider.generator.nova.RdGen;
import com.jetbrains.rider.generator.nova.RdGenKt;
import com.jetbrains.rider.generator.nova.Toplevel;
import com.jetbrains.rider.util.PlatformDependentKt;
import com.jetbrains.rider.util.hash.PersistentHash;
import com.jetbrains.rider.util.kli.Kli;
import com.jetbrains.rider.util.kli.Option;
import com.jetbrains.rider.util.reflection.ReflectionScannerKt;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00104\u001a\u000205H\u0002J \u00106\u001a\u0004\u0018\u00010\u00052\f\u00107\u001a\b\u0012\u0004\u0012\u00020.082\u0006\u00109\u001a\u00020\u0010H\u0002J\u0016\u0010:\u001a\u0004\u0018\u00010\u00142\f\u00107\u001a\b\u0012\u0004\u0012\u00020.08J\u0014\u0010;\u001a\u0002052\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020.0@H\u0002J\u0006\u0010A\u001a\u000205J\u0010\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u000bR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001f\u0010%\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0007R\u0011\u0010'\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0007R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020.0!\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010$R\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0007R\u0011\u00102\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u000b\u00a8\u0006G"}, d2={"Lcom/jetbrains/rider/generator/nova/RdGen;", "Lcom/jetbrains/rider/util/kli/Kli;", "()V", "classpath", "Lcom/jetbrains/rider/util/kli/Option$Valued;", "", "getClasspath", "()Lcom/jetbrains/rider/util/kli/Option$Valued;", "clearOutput", "Lcom/jetbrains/rider/util/kli/Option$Flag;", "getClearOutput", "()Lcom/jetbrains/rider/util/kli/Option$Flag;", "comments", "getComments", "()Ljava/lang/String;", "compiled", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCompiled", "compilerClassloader", "Ljava/lang/ClassLoader;", "getCompilerClassloader", "()Ljava/lang/ClassLoader;", "setCompilerClassloader", "(Ljava/lang/ClassLoader;)V", "defaultClassloader", "description", "getDescription", "filter", "getFilter", "force", "getForce", "generationSpecs", "", "Lcom/jetbrains/rider/generator/nova/GenerationSpec;", "getGenerationSpecs", "()Ljava/util/List;", "hashFolder", "getHashFolder", "hashfile", "getHashfile", "()Ljava/nio/file/Path;", "outputFolderKey", "packages", "getPackages", "sourcePaths", "Ljava/io/File;", "getSourcePaths", "sources", "getSources", "verbose", "getVerbose", "changedSinceLastStart", "", "compile0", "src", "", "dst", "compileDsl", "errorAndExit", "msg", "prepareHash", "Lcom/jetbrains/rider/util/hash/PersistentHash;", "outputFolders", "", "run", "v", "", "e", "", "Companion", "rd-gen"})
public final class RdGen
extends Kli {
    @Nullable
    private ClassLoader compilerClassloader;
    @NotNull
    private final Option.Valued<String> sources = Kli.option_string$default(this, Character.valueOf('s'), "source", "Folders with dsl .kt files. If not present, scan classpath for inheritors of '" + Toplevel.class.getName() + '\'', null, 8, null);
    @NotNull
    private final Option.Valued<Path> hashFolder = this.option_path(Character.valueOf('h'), "hash-folder", "Folder to store hash file '.rdgen' for incremental generation", Paths.get("", new String[0]).toAbsolutePath());
    @NotNull
    private final Option.Valued<Path> compiled = Kli.option_path$default(this, null, "compiled", "Folder for compiled dsl. Temporary folder is created if option is not specified.", null, 8, null);
    @NotNull
    private final Option.Valued<String> classpath = Kli.option_string$default(this, Character.valueOf('c'), "compiler-classpath", "Classpath for kotlin compiler. You must specify it if you referenced something from your dsl", null, 8, null);
    @NotNull
    private final Option.Flag force = this.option_flag(Character.valueOf('f'), "force", "Suppress incremental generation.");
    @NotNull
    private final Option.Flag clearOutput = this.option_flag(Character.valueOf('x'), "clear", "Clear output folder before generation (if it is not incremental) ");
    @NotNull
    private final Option.Valued<String> packages = this.option_string(Character.valueOf('p'), "packages", "Java package names to search toplevels, delimited by ','. Example: com.jetbrains.rider.model.nova", "com,org");
    @NotNull
    private final Option.Valued<String> filter = Kli.option_string$default(this, null, "filter", "Filter generators by searching regular expression inside generator class simple name (case insensitive). Example: kotlin|csharp", null, 8, null);
    @NotNull
    private final Option.Flag verbose = this.option_flag(Character.valueOf('v'), "verbose", "Verbose output");
    @NotNull
    private final List<GenerationSpec> generationSpecs;
    @NotNull
    private final List<File> sourcePaths;
    private final ClassLoader defaultClassloader;
    private final String outputFolderKey = "outputFolders";
    @NotNull
    public static final String version = "1.01";
    @NotNull
    public static final String hashFileName = ".rdgen";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getDescription() {
        return "RD Generator, v1.01. Search for inheritors of '" + Toplevel.class.getName() + '\'' + " and generate sources according generators: inheritors of '" + IGenerator.class.getName() + "'.";
    }

    @Override
    @NotNull
    public String getComments() {
        return "Generates RD Model from DSL ";
    }

    @Nullable
    public final ClassLoader getCompilerClassloader() {
        return this.compilerClassloader;
    }

    public final void setCompilerClassloader(@Nullable ClassLoader classLoader) {
        this.compilerClassloader = classLoader;
    }

    @NotNull
    public final Option.Valued<String> getSources() {
        return this.sources;
    }

    @NotNull
    public final Option.Valued<Path> getHashFolder() {
        return this.hashFolder;
    }

    @NotNull
    public final Option.Valued<Path> getCompiled() {
        return this.compiled;
    }

    @NotNull
    public final Option.Valued<String> getClasspath() {
        return this.classpath;
    }

    @NotNull
    public final Option.Flag getForce() {
        return this.force;
    }

    @NotNull
    public final Option.Flag getClearOutput() {
        return this.clearOutput;
    }

    @NotNull
    public final Option.Valued<String> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Option.Valued<String> getFilter() {
        return this.filter;
    }

    @NotNull
    public final Option.Flag getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Path getHashfile() {
        Object t = this.hashFolder.getValue();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Path path2 = Paths.get(t.toString(), hashFileName).normalize();
        Intrinsics.checkExpressionValueIsNotNull(path2, "Paths.get(hashFolder.val\u2026hashFileName).normalize()");
        return path2;
    }

    private final void v(String msg) {
        if (this.verbose.getValue().booleanValue()) {
            System.out.println((Object)msg);
        }
    }

    private final void v(Throwable e) {
        if (this.verbose.getValue().booleanValue()) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final List<GenerationSpec> getGenerationSpecs() {
        return this.generationSpecs;
    }

    @NotNull
    public final List<File> getSourcePaths() {
        return this.sourcePaths;
    }

    /*
     * WARNING - void declaration
     */
    private final String compile0(List<? extends File> src, Path dst) {
        this.v("Searching for Kotlin compiler");
        try {
            String[] stringArray;
            void $receiver$iv;
            Object[] objectArray;
            Collection<Object> collection;
            Collection $receiver$iv$iv;
            void $receiver$iv2;
            Iterable $receiver$iv$iv2;
            Iterable $receiver$iv3;
            Class<?> clazz;
            block18: {
                String compilerClass;
                block17: {
                    ClassLoader classLoader;
                    compilerClass = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
                    clazz = this.compilerClassloader;
                    if (clazz == null) break block17;
                    ClassLoader it = classLoader = clazz;
                    this.v("Using special classloader for kotlin compiler: " + it);
                    clazz = Class.forName(compilerClass, true, it);
                    if (clazz != null) break block18;
                }
                clazz = Class.forName(compilerClass);
            }
            Class<?> clazz2 = clazz;
            Method method = clazz2.getMethod("exec", PrintStream.class, new String[]{""}.getClass());
            this.v("Compiling sources from '" + CollectionsKt.joinToString$default(src, null, null, null, 0, null, compile0.1.INSTANCE, 31, null) + "' to '" + dst.toAbsolutePath() + '\'');
            String string2 = (String)this.classpath.getValue();
            if (string2 == null) {
                string2 = "";
            }
            String userCp = string2;
            this.v("User classpath: '" + userCp + '\'');
            String[] stringArray2 = new String[1];
            Package package_ = this.getClass().getPackage();
            Intrinsics.checkExpressionValueIsNotNull(package_, "javaClass.`package`");
            String string3 = package_.getName();
            Intrinsics.checkExpressionValueIsNotNull(string3, "javaClass.`package`.name");
            stringArray2[0] = string3;
            Iterable iterable = SequencesKt.toSet(SequencesKt.plus(ReflectionScannerKt.scanForResourcesContaining(this.defaultClassloader, stringArray2), ReflectionScannerKt.scanForResourcesContaining(this.defaultClassloader, "kotlin")));
            String string4 = System.getProperty("path.separator");
            Intrinsics.checkExpressionValueIsNotNull(string4, "System.getProperty(\"path.separator\")");
            String defaultCp = CollectionsKt.joinToString$default(iterable, string4, null, null, 0, null, null, 62, null);
            this.v("Rdgen default classpath: '" + defaultCp + '\'');
            Iterable iterable2 = $receiver$iv3 = (Iterable)CollectionsKt.listOf(userCp, defaultCp);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                String it = (String)element$iv$iv;
                if (!(!StringsKt.isBlank(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            String string5 = System.getProperty("path.separator");
            Intrinsics.checkExpressionValueIsNotNull(string5, "System.getProperty(\"path.separator\")");
            String cp = CollectionsKt.joinToString$default(iterable3, string5, null, null, 0, null, null, 62, null);
            this.v("Resulting kotlinc classpath: '" + cp + '\'');
            $receiver$iv$iv2 = src;
            Object object = CollectionsKt.listOf("-cp", cp, "-d", ((Object)dst).toString(), "-jvm-target", "1.8");
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File $i$a$1$filter = (File)item$iv$iv;
                collection = destination$iv$iv2;
                objectArray = it.getAbsolutePath();
                collection.add(objectArray);
            }
            collection = (List)destination$iv$iv2;
            List args = CollectionsKt.plus(object, (Iterable)collection);
            this.v("kotlinc " + CollectionsKt.joinToString$default(args, " ", null, null, 0, null, compile0.2.INSTANCE, 30, null));
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = System.err;
            $receiver$iv$iv = args;
            int n = 1;
            Object[] objectArray3 = objectArray2;
            objectArray = objectArray2;
            collection = clazz2.newInstance();
            object = method;
            void v10 = $receiver$iv;
            if (v10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            void thisCollection$iv = v10;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            if (stringArray3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray3[n] = stringArray = stringArray3;
            Object object2 = ((Method)object).invoke((Object)collection, objectArray);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Enum returnCode = (Enum)object2;
            return returnCode.ordinal() == 0 ? null : "Compilation failed. Return code: " + returnCode.ordinal() + '(' + returnCode + ").";
        }
        catch (Throwable e) {
            String string6;
            this.v(e);
            if (e instanceof ClassNotFoundException) {
                string6 = "Can't find K2JVMCompiler, maybe you forgot to add 'kotlin-compiler.jar' into classpath?";
            } else if (e instanceof NoSuchMethodException || e instanceof IllegalStateException || e instanceof NullPointerException || e instanceof InstantiationError || e instanceof ExceptionInInitializerError) {
                string6 = "Found compiler, but can't run it properly. Exception: " + PlatformDependentKt.getThrowableText(e) + '.' + System.lineSeparator() + "Maybe, compiler version is not correct?";
            } else if (e instanceof InvocationTargetException) {
                StringBuilder stringBuilder = new StringBuilder().append("Compilation failed with exception: ");
                Throwable throwable = ((InvocationTargetException)e).getTargetException();
                Intrinsics.checkExpressionValueIsNotNull(throwable, "e.targetException");
                string6 = stringBuilder.append(PlatformDependentKt.getThrowableText(throwable)).toString();
            } else {
                string6 = "Unknown exception:  " + PlatformDependentKt.getThrowableText(e);
            }
            return string6;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassLoader compileDsl(@NotNull List<? extends File> src) {
        ClassLoader classLoader;
        Path path2;
        block14: {
            Path $receiver;
            Path path3;
            block13: {
                Intrinsics.checkParameterIsNotNull(src, "src");
                path2 = (Path)this.compiled.getValue();
                if (path2 == null) break block13;
                $receiver = path3 = path2;
                this.v("Compiling into specified folder: " + $receiver);
                path2 = path3;
                if (path2 != null) break block14;
            }
            $receiver = path3 = Files.createTempDirectory("rdgen-", new FileAttribute[0]);
            this.v("Temporary folder created: " + $receiver);
            $receiver.toFile().deleteOnExit();
            path2 = path3;
        }
        Path dst = path2;
        long start$iv = System.currentTimeMillis();
        Path path4 = dst;
        Intrinsics.checkExpressionValueIsNotNull(path4, "dst");
        this.setError(this.compile0(src, path4));
        long elapsed = System.currentTimeMillis() - start$iv;
        this.v("Compilation finished in " + elapsed + " ms");
        if (this.getError() == null) {
            URLClassLoader uRLClassLoader;
            try {
                Collection $receiver$iv;
                Iterable iterable;
                Collection collection = CollectionsKt.listOf(dst.toUri().toURL());
                String string2 = (String)this.classpath.getValue();
                if (string2 != null) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv2;
                    String string3 = string2;
                    Collection collection2 = collection;
                    String it = string3;
                    Iterable iterable2 = $receiver$iv2 = (Iterable)StringsKt.split$default((CharSequence)it, new char[]{File.pathSeparatorChar}, false, 0, 6, null);
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it2;
                        String string4 = (String)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        URL uRL = new File((String)it2).toURI().toURL();
                        collection3.add(uRL);
                    }
                    List list2 = (List)destination$iv$iv;
                    collection = collection2;
                    iterable = list2;
                } else {
                    iterable = CollectionsKt.emptyList();
                }
                List classpathUris = CollectionsKt.plus(collection, iterable);
                this.v("Loading compiled classes from '" + CollectionsKt.joinToString$default(classpathUris, null, null, null, 0, null, null, 63, null) + '\'');
                Collection collection4 = $receiver$iv = (Collection)classpathUris;
                if (collection4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection4;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] uRLArray2 = uRLArray;
                ClassLoader classLoader2 = this.defaultClassloader;
                URL[] uRLArray3 = uRLArray2;
                uRLClassLoader = new URLClassLoader(uRLArray3, classLoader2);
            }
            catch (Throwable e) {
                this.setError("Error during loading classes from '" + dst + '\'');
                uRLClassLoader = null;
            }
            classLoader = uRLClassLoader;
        } else {
            classLoader = null;
        }
        return classLoader;
    }

    private final boolean errorAndExit(String msg) {
        PrintStream printStream;
        PrintStream $receiver = printStream = System.err;
        String string2 = msg;
        if (string2 == null) {
            string2 = this.getError();
        }
        $receiver.println(string2);
        $receiver.println();
        $receiver.println(this.help());
        return false;
    }

    static /* synthetic */ boolean errorAndExit$default(RdGen rdGen2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return rdGen2.errorAndExit(string2);
    }

    private final PersistentHash prepareHash(Collection<? extends File> outputFolders) {
        File element$iv;
        PersistentHash persistentHash;
        PersistentHash res2 = persistentHash = new PersistentHash();
        String string2 = (String)this.sources.getValue();
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            for (String src : StringsKt.split$default((CharSequence)it, new char[]{File.pathSeparatorChar}, false, 0, 6, null)) {
                PersistentHash.mixFileRecursively$default(res2, new File(src), null, 2, null);
            }
        }
        for (File sourcePath : this.sourcePaths) {
            PersistentHash.mixFileRecursively$default(res2, sourcePath, null, 2, null);
        }
        Object $receiver$iv = outputFolders;
        Iterator<File> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            File it = element$iv = iterator2.next();
            res2.mixFileRecursively(it, prepareHash.1.2.1.INSTANCE);
        }
        $receiver$iv = outputFolders;
        iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            File folder = element$iv = iterator2.next();
            res2.mix(this.outputFolderKey, folder.getCanonicalPath());
        }
        String[] stringArray = new String[1];
        Package package_ = this.getClass().getPackage();
        Intrinsics.checkExpressionValueIsNotNull(package_, "javaClass.`package`");
        String string4 = package_.getName();
        Intrinsics.checkExpressionValueIsNotNull(string4, "javaClass.`package`.name");
        stringArray[0] = string4;
        $receiver$iv = ReflectionScannerKt.scanForResourcesContaining(this.defaultClassloader, stringArray);
        iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            File file2 = element$iv = iterator2.next();
            res2.mixFileRecursively(file2, prepareHash.1.4.1.INSTANCE);
        }
        res2.mix("version", version);
        res2.mix("userClasspath", (String)this.classpath.getValue());
        res2.mix("filter", (String)this.filter.getValue());
        res2.mix("packages", (String)this.packages.getValue());
        return persistentHash;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean changedSinceLastStart() {
        void $receiver$iv$iv;
        if (this.sources.getValue() == null && this.sourcePaths.isEmpty()) {
            return true;
        }
        this.v("Reading hash from " + this.getHashfile());
        PersistentHash oldHash = PersistentHash.Companion.load(this.getHashfile());
        Iterable $receiver$iv = oldHash.get(this.outputFolderKey);
        Object object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file2 = new File((String)it);
            collection.add(file2);
        }
        List outputFolders = (List)destination$iv$iv;
        PersistentHash newHash = this.prepareHash(outputFolders);
        String string3 = oldHash.firstDiff(newHash);
        if (string3 != null) {
            Object it = object = string3;
            this.v("Hashes are different at key '" + (String)it + "', oldHash: " + CollectionsKt.joinToString$default(oldHash.get((String)it), ",", null, null, 0, null, null, 62, null) + ", newHash:" + CollectionsKt.joinToString$default(newHash.get((String)it), ",", null, null, 0, null, null, 62, null));
            return true;
        }
        if (this.getHashfile().toFile().exists()) {
            this.getHashfile().toFile().setLastModified(System.currentTimeMillis());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean run() {
        ClassLoader classLoader;
        Object sourcePath;
        Object sourcePaths;
        Collection $i$a$1$let;
        String srcDir;
        String string2;
        if (this.getError() != null) {
            return RdGen.errorAndExit$default(this, null, 1, null);
        }
        try {
            Regex regex;
            String string3 = (String)this.filter.getValue();
            if (string3 != null) {
                String it = string2 = string3;
                regex = new Regex(it, RegexOption.IGNORE_CASE);
            } else {
                regex = null;
            }
            string2 = regex;
        }
        catch (Throwable e) {
            return this.errorAndExit("Can't parse regex '" + (String)this.filter.getValue() + '\'');
        }
        String generatorFilter = string2;
        Object t = this.packages.getValue();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)t, new char[]{',', ' ', ':', ';'}, false, 0, 6, null);
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] pkgPrefixes = stringArray;
        if (!this.force.getValue().booleanValue()) {
            if (!this.changedSinceLastStart()) {
                this.v("No changes since last start");
                return true;
            }
        } else {
            this.v("Forced: true");
            Path path2 = (Path)this.compiled.getValue();
            if (path2 != null) {
                Iterable it = $receiver$iv = path2;
                this.v("Clearing '" + it + '\'');
                File file2 = it.toFile();
                Intrinsics.checkExpressionValueIsNotNull(file2, "it.toFile()");
                FilesKt.deleteRecursively(file2);
            }
        }
        if ((srcDir = (String)this.sources.getValue()) != null || !($i$a$1$let = (Collection)this.sourcePaths).isEmpty()) {
            List list2;
            Iterator $receiver$iv$iv;
            Object object = srcDir;
            if (object != null && (object = StringsKt.split$default((CharSequence)object, new char[]{File.pathSeparatorChar}, false, 0, 6, null)) != null) {
                Iterable $receiver$iv2;
                Iterable iterable = $receiver$iv2 = (Iterable)object;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                Iterator iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator2.next();
                    String string4 = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    File file3 = new File((String)it);
                    collection2.add(file3);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            sourcePaths = CollectionsKt.plus((Collection)list2, (Iterable)this.sourcePaths);
            $receiver$iv$iv = sourcePaths.iterator();
            while ($receiver$iv$iv.hasNext()) {
                sourcePath = (File)$receiver$iv$iv.next();
                if (((File)sourcePath).isDirectory()) continue;
                return this.errorAndExit("Sources are incorrect. No folder found at '" + sourcePath + '\'');
            }
            classLoader = this.compileDsl((List<? extends File>)sourcePaths);
            if (classLoader == null) {
                return RdGen.errorAndExit$default(this, null, 1, null);
            }
        } else {
            sourcePaths = "Folder 'source' isn't specified, searching for models in classloader of RdGen class (current java process classpath)";
            System.out.println(sourcePaths);
            classLoader = this.defaultClassloader;
        }
        ClassLoader classloader = classLoader;
        try {
            sourcePath = RdGenKt.generateRdModel(classloader, pkgPrefixes, this.verbose.getValue(), (Regex)((Object)generatorFilter), this.clearOutput.getValue(), this.generationSpecs);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        Object outputFolders = sourcePath;
        if (srcDir != null || !(sourcePath = (Collection)this.sourcePaths).isEmpty()) {
            PersistentHash hash = this.prepareHash((Collection)outputFolders);
            this.v("Storing hash into '" + this.getHashfile() + '\'');
            hash.store(this.getHashfile());
        } else {
            this.v("Don't store hashfile, build is not incremental since 'sources' aren't specified");
        }
        return true;
    }

    public RdGen() {
        List list2;
        RdGen rdGen2 = this;
        rdGen2.generationSpecs = list2 = (List)new ArrayList();
        rdGen2 = this;
        rdGen2.sourcePaths = list2 = (List)new ArrayList();
        ClassLoader classLoader = RdGen.class.getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        this.defaultClassloader = classLoader;
        this.outputFolderKey = "outputFolders";
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/generator/nova/RdGen$Companion;", "", "()V", "hashFileName", "", "version", "rd-gen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

