/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.threading;

import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.LoggerKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.util.threading.SingleThreadSchedulerBase;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/util/threading/SingleThreadScheduler;", "Lcom/jetbrains/rider/util/threading/SingleThreadSchedulerBase;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "name", "", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "log", "Lcom/jetbrains/rider/util/Logger;", "onException", "", "ex", "", "rd-core"})
public final class SingleThreadScheduler
extends SingleThreadSchedulerBase {
    private final Logger log;
    @NotNull
    private final Lifetime lifetime;

    @Override
    public void onException(@NotNull Throwable ex) {
        Intrinsics.checkParameterIsNotNull(ex, "ex");
        LoggerKt.error(this.log, ex);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public SingleThreadScheduler(@NotNull Lifetime lifetime, final @NotNull String name2) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull(lifetime, "lifetime");
        Intrinsics.checkParameterIsNotNull(name2, "name");
        super(name2);
        this.lifetime = lifetime;
        SingleThreadScheduler singleThreadScheduler = this;
        singleThreadScheduler.log = logger = LoggerKt.getLogger(Reflection.getOrCreateKotlinClass(SingleThreadScheduler.class));
        RLifetimeKt.plusAssign(this.lifetime, new Function0<Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke() {
                try {
                    this.getExecutor().shutdownNow();
                    if (!this.getExecutor().awaitTermination(5L, TimeUnit.SECONDS)) {
                        void $receiver$iv$iv;
                        Logger $receiver$iv;
                        Logger logger = $receiver$iv = log;
                        LogLevel level$iv$iv = LogLevel.Error;
                        if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                            LogLevel logLevel = level$iv$iv;
                            void var7_6 = $receiver$iv$iv;
                            String string2 = "Failed to terminate " + name2 + '.';
                            var7_6.log(logLevel, string2, null);
                        }
                    }
                }
                catch (Throwable e) {
                    LoggerKt.error(log, e);
                }
            }
        });
    }
}

