/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.Collections;
import javaslang.collection.Iterator;
import javaslang.collection.Map;
import javaslang.control.Option;

final class Maps {
    static <K, V, M extends Map<K, V>> M distinct(M map2) {
        return map2;
    }

    static <K, V, M extends Map<K, V>> M distinctBy(M map2, OfEntries<K, V, M> ofEntries, Comparator<? super Tuple2<K, V>> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return (M)((Map)ofEntries.apply(map2.iterator().distinctBy(comparator)));
    }

    static <K, V, U, M extends Map<K, V>> M distinctBy(M map2, OfEntries<K, V, M> ofEntries, Function<? super Tuple2<K, V>, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        return (M)((Map)ofEntries.apply(map2.iterator().distinctBy(keyExtractor)));
    }

    static <K, V, M extends Map<K, V>> M drop(M map2, OfEntries<K, V, M> ofEntries, Supplier<M> emptySupplier, long n) {
        if (n <= 0L) {
            return map2;
        }
        if (n >= (long)map2.size()) {
            return (M)((Map)emptySupplier.get());
        }
        return (M)((Map)ofEntries.apply(map2.iterator().drop(n)));
    }

    static <K, V, M extends Map<K, V>> M dropRight(M map2, OfEntries<K, V, M> ofEntries, Supplier<M> emptySupplier, long n) {
        if (n <= 0L) {
            return map2;
        }
        if (n >= (long)map2.size()) {
            return (M)((Map)emptySupplier.get());
        }
        return (M)((Map)ofEntries.apply(map2.iterator().dropRight(n)));
    }

    static <K, V, M extends Map<K, V>> M dropUntil(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.dropWhile(map2, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M dropWhile(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (M)((Map)ofEntries.apply(map2.iterator().dropWhile(predicate)));
    }

    static <K, V, M extends Map<K, V>> M filter(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (M)((Map)ofEntries.apply(map2.iterator().filter(predicate)));
    }

    static <K, V, C, M extends Map<K, V>> Map<C, M> groupBy(M map2, OfEntries<K, V, M> ofEntries, Function<? super Tuple2<K, V>, ? extends C> classifier2) {
        return Collections.groupBy(map2, classifier2, ofEntries);
    }

    static <K, V, M extends Map<K, V>> Iterator<M> grouped(M map2, OfEntries<K, V, M> ofEntries, long size) {
        return Maps.sliding(map2, ofEntries, size, size);
    }

    static <K, V, M extends Map<K, V>> Option<M> initOption(M map2) {
        return map2.isEmpty() ? Option.none() : Option.some(map2.init());
    }

    static <K, V, M extends Map<K, V>> M merge(M map2, OfEntries<K, V, M> ofEntries, Map<? extends K, ? extends V> that) {
        Objects.requireNonNull(that, "that is null");
        if (map2.isEmpty()) {
            return (M)((Map)ofEntries.apply(Map.narrow(that)));
        }
        if (that.isEmpty()) {
            return map2;
        }
        return (M)that.foldLeft(map2, (result2, entry) -> !result2.containsKey(entry._1) ? Maps.put(result2, entry) : result2);
    }

    static <K, V, U extends V, M extends Map<K, V>> M merge(M map2, OfEntries<K, V, M> ofEntries, Map<? extends K, U> that, BiFunction<? super V, ? super U, ? extends V> collisionResolution) {
        Objects.requireNonNull(that, "that is null");
        Objects.requireNonNull(collisionResolution, "collisionResolution is null");
        if (map2.isEmpty()) {
            return (M)((Map)ofEntries.apply(Map.narrow(that)));
        }
        if (that.isEmpty()) {
            return map2;
        }
        return (M)that.foldLeft(map2, (result2, entry) -> {
            Object key = entry._1;
            Object value2 = entry._2;
            Object newValue = result2.get(key).map(v2 -> collisionResolution.apply((Object)v2, (Object)value2)).getOrElse(value2);
            return result2.put(key, newValue);
        });
    }

    static <K, V, M extends Map<K, V>> Tuple2<M, M> partition(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super Tuple2<K, V>>, Iterator<? super Tuple2<K, V>>> p = map2.iterator().partition(predicate);
        return Tuple.of(ofEntries.apply(p._1), ofEntries.apply(p._2));
    }

    static <K, V, M extends Map<K, V>> M peek(M map2, Consumer<? super Tuple2<K, V>> action) {
        Objects.requireNonNull(action, "action is null");
        if (!map2.isEmpty()) {
            action.accept((Tuple2<K, V>)map2.head());
        }
        return map2;
    }

    static <K, V, M extends Map<K, V>> M put(M map2, Tuple2<? extends K, ? extends V> entry) {
        Objects.requireNonNull(entry, "entry is null");
        return (M)map2.put(entry._1, entry._2);
    }

    static <K, V, M extends Map<K, V>> M replace(M map2, Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        Objects.requireNonNull(currentElement, "currentElement is null");
        Objects.requireNonNull(newElement, "newElement is null");
        return (M)(map2.containsKey(currentElement._1) ? map2.remove(currentElement._1).put(newElement) : map2);
    }

    static <K, V, M extends Map<K, V>> M replaceAll(M map2, Tuple2<K, V> currentElement, Tuple2<K, V> newElement) {
        return Maps.replace(map2, currentElement, newElement);
    }

    static <K, V, M extends Map<K, V>> M scan(M map2, Supplier<M> emptySupplier, Tuple2<K, V> zero, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return (M)((Map)Collections.scanLeft(map2, zero, operation, (Iterable)emptySupplier.get(), Maps::put, Function.identity()));
    }

    static <K, V, M extends Map<K, V>> Iterator<M> sliding(M map2, OfEntries<K, V, M> ofEntries, long size) {
        return Maps.sliding(map2, ofEntries, size, 1L);
    }

    static <K, V, M extends Map<K, V>> Iterator<M> sliding(M map2, OfEntries<K, V, M> ofEntries, long size, long step) {
        return map2.iterator().sliding(size, step).map(ofEntries);
    }

    static <K, V, M extends Map<K, V>> Tuple2<M, M> span(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Tuple2<Iterator<? super Tuple2<K, V>>, Iterator<? super Tuple2<K, V>>> t = map2.iterator().span(predicate);
        return Tuple.of(ofEntries.apply(t._1), ofEntries.apply(t._2));
    }

    static <K, V, M extends Map<K, V>> Option<M> tailOption(M map2) {
        return map2.isEmpty() ? Option.none() : Option.some(map2.tail());
    }

    static <K, V, M extends Map<K, V>> M take(M map2, OfEntries<K, V, M> ofEntries, long n) {
        if (n >= (long)map2.size()) {
            return map2;
        }
        return (M)((Map)ofEntries.apply(map2.iterator().take(n)));
    }

    static <K, V, M extends Map<K, V>> M takeRight(M map2, OfEntries<K, V, M> ofEntries, long n) {
        if (n >= (long)map2.size()) {
            return map2;
        }
        return (M)((Map)ofEntries.apply(map2.iterator().takeRight(n)));
    }

    static <K, V, M extends Map<K, V>> M takeUntil(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Maps.takeWhile(map2, ofEntries, predicate.negate());
    }

    static <K, V, M extends Map<K, V>> M takeWhile(M map2, OfEntries<K, V, M> ofEntries, Predicate<? super Tuple2<K, V>> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        Map taken = (Map)ofEntries.apply(map2.iterator().takeWhile(predicate));
        return (M)(taken.size() == map2.size() ? map2 : taken);
    }

    @FunctionalInterface
    static interface OfEntries<K, V, M extends Map<K, V>>
    extends Function<Iterable<Tuple2<K, V>>, M> {
    }
}

