/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNullPointerException;
import kotlin.SinceKotlin;
import kotlin.UninitializedPropertyAccessException;

public class Intrinsics {
    private Intrinsics() {
    }

    public static String stringPlus(String self, Object other) {
        return self + other;
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            Intrinsics.throwNpe();
        }
    }

    public static void checkNotNull(Object object, String message) {
        if (object == null) {
            Intrinsics.throwNpe(message);
        }
    }

    public static void throwNpe() {
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException());
    }

    public static void throwNpe(String message) {
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException(message));
    }

    public static void throwUninitializedProperty(String message) {
        throw Intrinsics.sanitizeStackTrace(new UninitializedPropertyAccessException(message));
    }

    public static void throwUninitializedPropertyAccessException(String propertyName) {
        Intrinsics.throwUninitializedProperty("lateinit property " + propertyName + " has not been initialized");
    }

    public static void throwAssert() {
        throw Intrinsics.sanitizeStackTrace(new AssertionError());
    }

    public static void throwAssert(String message) {
        throw Intrinsics.sanitizeStackTrace(new AssertionError((Object)message));
    }

    public static void throwIllegalArgument() {
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException());
    }

    public static void throwIllegalArgument(String message) {
        throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException(message));
    }

    public static void throwIllegalState() {
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException());
    }

    public static void throwIllegalState(String message) {
        throw Intrinsics.sanitizeStackTrace(new IllegalStateException(message));
    }

    public static void checkExpressionValueIsNotNull(Object value2, String expression2) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException(expression2 + " must not be null"));
        }
    }

    public static void checkNotNullExpressionValue(Object value2, String message) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException(message));
        }
    }

    public static void checkReturnedValueIsNotNull(Object value2, String className2, String methodName) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException("Method specified as non-null returned null: " + className2 + "." + methodName));
        }
    }

    public static void checkReturnedValueIsNotNull(Object value2, String message) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException(message));
        }
    }

    public static void checkFieldIsNotNull(Object value2, String className2, String fieldName) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException("Field specified as non-null is null: " + className2 + "." + fieldName));
        }
    }

    public static void checkFieldIsNotNull(Object value2, String message) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalStateException(message));
        }
    }

    public static void checkParameterIsNotNull(Object value2, String paramName) {
        if (value2 == null) {
            Intrinsics.throwParameterIsNullException(paramName);
        }
    }

    public static void checkNotNullParameter(Object value2, String message) {
        if (value2 == null) {
            throw Intrinsics.sanitizeStackTrace(new IllegalArgumentException(message));
        }
    }

    private static void throwParameterIsNullException(String paramName) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller2 = stackTraceElements[3];
        String className2 = caller2.getClassName();
        String methodName = caller2.getMethodName();
        IllegalArgumentException exception = new IllegalArgumentException("Parameter specified as non-null is null: method " + className2 + "." + methodName + ", parameter " + paramName);
        throw Intrinsics.sanitizeStackTrace(exception);
    }

    public static int compare(long thisVal, long anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int compare(int thisVal, int anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static boolean areEqual(Object first2, Object second) {
        return first2 == null ? second == null : first2.equals(second);
    }

    @SinceKotlin(version="1.1")
    public static boolean areEqual(Double first2, Double second) {
        return first2 == null ? second == null : second != null && first2.doubleValue() == second.doubleValue();
    }

    @SinceKotlin(version="1.1")
    public static boolean areEqual(Double first2, double second) {
        return first2 != null && first2 == second;
    }

    @SinceKotlin(version="1.1")
    public static boolean areEqual(double first2, Double second) {
        return second != null && first2 == second;
    }

    @SinceKotlin(version="1.1")
    public static boolean areEqual(Float first2, Float second) {
        return first2 == null ? second == null : second != null && first2.floatValue() == second.floatValue();
    }

    @SinceKotlin(version="1.1")
    public static boolean areEqual(Float first2, float second) {
        return first2 != null && first2.floatValue() == second;
    }

    @SinceKotlin(version="1.1")
    public static boolean areEqual(float first2, Float second) {
        return second != null && first2 == second.floatValue();
    }

    public static void throwUndefinedForReified() {
        Intrinsics.throwUndefinedForReified("This function has a reified type parameter and thus can only be inlined at compilation time, not called directly.");
    }

    public static void throwUndefinedForReified(String message) {
        throw new UnsupportedOperationException(message);
    }

    public static void reifiedOperationMarker(int id, String typeParameterIdentifier) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void reifiedOperationMarker(int id, String typeParameterIdentifier, String message) {
        Intrinsics.throwUndefinedForReified(message);
    }

    public static void needClassReification() {
        Intrinsics.throwUndefinedForReified();
    }

    public static void needClassReification(String message) {
        Intrinsics.throwUndefinedForReified(message);
    }

    public static void checkHasClass(String internalName) throws ClassNotFoundException {
        String fqName2 = internalName.replace('/', '.');
        try {
            Class.forName(fqName2);
        }
        catch (ClassNotFoundException e) {
            throw Intrinsics.sanitizeStackTrace(new ClassNotFoundException("Class " + fqName2 + " is not found. Please update the Kotlin runtime to the latest version", e));
        }
    }

    public static void checkHasClass(String internalName, String requiredVersion) throws ClassNotFoundException {
        String fqName2 = internalName.replace('/', '.');
        try {
            Class.forName(fqName2);
        }
        catch (ClassNotFoundException e) {
            throw Intrinsics.sanitizeStackTrace(new ClassNotFoundException("Class " + fqName2 + " is not found: this code requires the Kotlin runtime of version at least " + requiredVersion, e));
        }
    }

    private static <T extends Throwable> T sanitizeStackTrace(T throwable) {
        return Intrinsics.sanitizeStackTrace(throwable, Intrinsics.class.getName());
    }

    static <T extends Throwable> T sanitizeStackTrace(T throwable, String classNameToDrop) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int size = stackTrace.length;
        int lastIntrinsic = -1;
        for (int i = 0; i < size; ++i) {
            if (!classNameToDrop.equals(stackTrace[i].getClassName())) continue;
            lastIntrinsic = i;
        }
        List<StackTraceElement> list2 = Arrays.asList(stackTrace).subList(lastIntrinsic + 1, size);
        throwable.setStackTrace(list2.toArray(new StackTraceElement[list2.size()]));
        return throwable;
    }
}

