/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.annotations;

import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;

public final class AnnotationUtilKt {
    private static final Name DEPRECATED_MESSAGE_NAME;
    private static final Name DEPRECATED_REPLACE_WITH_NAME;
    private static final Name DEPRECATED_LEVEL_NAME;
    private static final Name REPLACE_WITH_EXPRESSION_NAME;
    private static final Name REPLACE_WITH_IMPORTS_NAME;
    private static final FqName INLINE_ONLY_ANNOTATION_FQ_NAME;

    @NotNull
    public static final AnnotationDescriptor createDeprecatedAnnotation(@NotNull KotlinBuiltIns $receiver, @NotNull String message, @NotNull String replaceWith, @NotNull String level) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(replaceWith, "replaceWith");
        Intrinsics.checkParameterIsNotNull(level, "level");
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.replaceWith;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.replaceWith");
        BuiltInAnnotationDescriptor replaceWithAnnotation2 = new BuiltInAnnotationDescriptor($receiver, fqName2, MapsKt.mapOf(TuplesKt.to(REPLACE_WITH_EXPRESSION_NAME, new StringValue(replaceWith)), TuplesKt.to(REPLACE_WITH_IMPORTS_NAME, new ArrayValue(CollectionsKt.emptyList(), (Function1<? super ModuleDescriptor, ? extends KotlinType>)new Function1<ModuleDescriptor, SimpleType>($receiver){
            final /* synthetic */ KotlinBuiltIns $this_createDeprecatedAnnotation;

            @NotNull
            public final SimpleType invoke(@NotNull ModuleDescriptor module2) {
                Intrinsics.checkParameterIsNotNull(module2, "module");
                SimpleType simpleType2 = module2.getBuiltIns().getArrayType(Variance.INVARIANT, this.$this_createDeprecatedAnnotation.getStringType());
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "module.builtIns.getArray\u2026ce.INVARIANT, stringType)");
                return simpleType2;
            }
            {
                this.$this_createDeprecatedAnnotation = kotlinBuiltIns;
                super(1);
            }
        }))));
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.deprecated;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "KotlinBuiltIns.FQ_NAMES.deprecated");
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to(DEPRECATED_MESSAGE_NAME, new StringValue(message));
        pairArray[1] = TuplesKt.to(DEPRECATED_REPLACE_WITH_NAME, new AnnotationValue(replaceWithAnnotation2));
        ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.deprecationLevel);
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(KotlinB\u2026Q_NAMES.deprecationLevel)");
        Name name2 = Name.identifier(level);
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(level)");
        pairArray[2] = TuplesKt.to(DEPRECATED_LEVEL_NAME, new EnumValue(classId, name2));
        return new BuiltInAnnotationDescriptor($receiver, fqName3, MapsKt.mapOf(pairArray));
    }

    @NotNull
    public static /* synthetic */ AnnotationDescriptor createDeprecatedAnnotation$default(KotlinBuiltIns kotlinBuiltIns, String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            string4 = "WARNING";
        }
        return AnnotationUtilKt.createDeprecatedAnnotation(kotlinBuiltIns, string2, string3, string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineOnlyOrReifiable(@NotNull MemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        if (!($receiver instanceof CallableMemberDescriptor)) return false;
        if (AnnotationUtilKt.isReifiable((CallableMemberDescriptor)$receiver)) return true;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
        Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
        if (AnnotationUtilKt.isReifiable(callableMemberDescriptor)) return true;
        if (!AnnotationUtilKt.isInlineOnly($receiver)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyInlineOnly(@NotNull MemberDescriptor $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        if (AnnotationUtilKt.isInlineOnlyOrReifiable($receiver)) return true;
        if (!($receiver instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)$receiver).isSuspend()) return false;
        if (!((FunctionDescriptor)$receiver).isInline()) return false;
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)$receiver).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "valueParameters");
        Iterable $receiver$iv = list2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                if (!it.isCrossinline()) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (!Intrinsics.areEqual(((FunctionDescriptor)$receiver).getVisibility(), Visibilities.PRIVATE)) return false;
        return true;
    }

    public static final boolean isInlineOnly(@NotNull MemberDescriptor $receiver) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
                if (!($receiver instanceof FunctionDescriptor)) break block4;
                if (AnnotationUtilKt.hasInlineOnlyAnnotation((CallableMemberDescriptor)$receiver)) break block5;
                CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember((CallableMemberDescriptor)$receiver);
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "DescriptorUtils.getDirectMember(this)");
                if (AnnotationUtilKt.hasInlineOnlyAnnotation(callableMemberDescriptor)) break block5;
            }
            return false;
        }
        boolean bl = ((FunctionDescriptor)$receiver).isInline();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Function is not inline: " + $receiver;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return true;
    }

    private static final boolean isReifiable(@NotNull CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                    if (!typeParameterDescriptor.isReified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean hasInlineOnlyAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        return $receiver.getAnnotations().hasAnnotation(INLINE_ONLY_ANNOTATION_FQ_NAME);
    }

    static {
        Name name2 = Name.identifier("message");
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(\"message\")");
        DEPRECATED_MESSAGE_NAME = name2;
        Name name3 = Name.identifier("replaceWith");
        Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier(\"replaceWith\")");
        DEPRECATED_REPLACE_WITH_NAME = name3;
        Name name4 = Name.identifier("level");
        Intrinsics.checkExpressionValueIsNotNull(name4, "Name.identifier(\"level\")");
        DEPRECATED_LEVEL_NAME = name4;
        Name name5 = Name.identifier("expression");
        Intrinsics.checkExpressionValueIsNotNull(name5, "Name.identifier(\"expression\")");
        REPLACE_WITH_EXPRESSION_NAME = name5;
        Name name6 = Name.identifier("imports");
        Intrinsics.checkExpressionValueIsNotNull(name6, "Name.identifier(\"imports\")");
        REPLACE_WITH_IMPORTS_NAME = name6;
        INLINE_ONLY_ANNOTATION_FQ_NAME = new FqName("kotlin.internal.InlineOnly");
    }
}

