/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ClassDescriptorBase;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.NonReportingOverrideStrategy;
import kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.ClassTypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumEntrySyntheticClassDescriptor
extends ClassDescriptorBase {
    private final TypeConstructor typeConstructor;
    private final MemberScope scope;
    private final NotNullLazyValue<Set<Name>> enumMemberNames;
    private final Annotations annotations;

    @NotNull
    public static EnumEntrySyntheticClassDescriptor create(@NotNull StorageManager storageManager, @NotNull ClassDescriptor enumClass2, @NotNull Name name2, @NotNull NotNullLazyValue<Set<Name>> enumMemberNames2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        SimpleType enumType = enumClass2.getDefaultType();
        return new EnumEntrySyntheticClassDescriptor(storageManager, enumClass2, enumType, name2, enumMemberNames2, annotations2, source);
    }

    private EnumEntrySyntheticClassDescriptor(@NotNull StorageManager storageManager, @NotNull ClassDescriptor containingClass, @NotNull KotlinType supertype, @NotNull Name name2, @NotNull NotNullLazyValue<Set<Name>> enumMemberNames2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        super(storageManager, containingClass, name2, source, false);
        assert (containingClass.getKind() == ClassKind.ENUM_CLASS);
        this.annotations = annotations2;
        this.typeConstructor = new ClassTypeConstructorImpl(this, Collections.emptyList(), Collections.singleton(supertype), storageManager);
        this.scope = new EnumEntryScope(storageManager);
        this.enumMemberNames = enumMemberNames2;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        return MemberScope.Empty.INSTANCE;
    }

    @Override
    @NotNull
    public Collection<ClassConstructorDescriptor> getConstructors() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @Nullable
    public ClassDescriptor getCompanionObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return ClassKind.ENUM_ENTRY;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return Modality.FINAL;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.PUBLIC;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    public boolean isExpect() {
        return false;
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    @Nullable
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return null;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "enum entry " + this.getName();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        return Collections.emptyList();
    }

    private class EnumEntryScope
    extends MemberScopeImpl {
        private final MemoizedFunctionToNotNull<Name, Collection<SimpleFunctionDescriptor>> functions;
        private final MemoizedFunctionToNotNull<Name, Collection<PropertyDescriptor>> properties;
        private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;

        public EnumEntryScope(@NotNull StorageManager storageManager) {
            this.functions = storageManager.createMemoizedFunction(new Function1<Name, Collection<SimpleFunctionDescriptor>>(){

                @Override
                public Collection<SimpleFunctionDescriptor> invoke(Name name2) {
                    return EnumEntryScope.this.computeFunctions(name2);
                }
            });
            this.properties = storageManager.createMemoizedFunction(new Function1<Name, Collection<PropertyDescriptor>>(){

                @Override
                public Collection<PropertyDescriptor> invoke(Name name2) {
                    return EnumEntryScope.this.computeProperties(name2);
                }
            });
            this.allDescriptors = storageManager.createLazyValue(new Function0<Collection<DeclarationDescriptor>>(){

                @Override
                public Collection<DeclarationDescriptor> invoke() {
                    return EnumEntryScope.this.computeAllDeclarations();
                }
            });
        }

        @NotNull
        public Collection getContributedVariables(@NotNull Name name2, @NotNull LookupLocation location2) {
            return (Collection)this.properties.invoke(name2);
        }

        @NotNull
        private Collection<PropertyDescriptor> computeProperties(@NotNull Name name2) {
            return this.resolveFakeOverrides(name2, this.getSupertypeScope().getContributedVariables(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
        }

        @NotNull
        public Collection getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location2) {
            return (Collection)this.functions.invoke(name2);
        }

        @NotNull
        private Collection<SimpleFunctionDescriptor> computeFunctions(@NotNull Name name2) {
            return this.resolveFakeOverrides(name2, this.getSupertypeScope().getContributedFunctions(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
        }

        @NotNull
        private MemberScope getSupertypeScope() {
            Collection<KotlinType> supertype = EnumEntrySyntheticClassDescriptor.this.getTypeConstructor().getSupertypes();
            assert (supertype.size() == 1) : "Enum entry and its companion object both should have exactly one supertype: " + supertype;
            return supertype.iterator().next().getMemberScope();
        }

        @NotNull
        private <D extends CallableMemberDescriptor> Collection<D> resolveFakeOverrides(@NotNull Name name2, @NotNull Collection<D> fromSupertypes) {
            final LinkedHashSet result2 = new LinkedHashSet();
            OverridingUtil.generateOverridesInFunctionGroup(name2, fromSupertypes, Collections.emptySet(), EnumEntrySyntheticClassDescriptor.this, new NonReportingOverrideStrategy(){

                @Override
                public void addFakeOverride(@NotNull CallableMemberDescriptor fakeOverride) {
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, null);
                    result2.add(fakeOverride);
                }

                @Override
                protected void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
            return result2;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
            return (Collection)this.allDescriptors.invoke();
        }

        @NotNull
        private Collection<DeclarationDescriptor> computeAllDeclarations() {
            HashSet<DeclarationDescriptor> result2 = new HashSet<DeclarationDescriptor>();
            for (Name name2 : (Set)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke()) {
                result2.addAll(this.getContributedFunctions(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
                result2.addAll(this.getContributedVariables(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
            }
            return result2;
        }

        @Override
        @NotNull
        public Set<Name> getFunctionNames() {
            return (Set)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke();
        }

        @Override
        @NotNull
        public Set<Name> getVariableNames() {
            return (Set)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke();
        }
    }
}

