/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.EventLoop;
import kotlinx.coroutines.internal.ThreadSafeHeap;
import kotlinx.coroutines.internal.ThreadSafeHeapNode;
import kotlinx.coroutines.test.TimedRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001<B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J$\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0 J$\u0010\"\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0 J*\u0010#\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020!0 J$\u0010$\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0 J\u0006\u0010%\u001a\u00020\u001bJ5\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u0002H'2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u0002H'0*H\u0016\u00a2\u0006\u0002\u0010,J(\u0010-\u001a\u0004\u0018\u0001H.\"\b\b\u0000\u0010.*\u00020+2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0096\u0002\u00a2\u0006\u0002\u00101J\u0014\u00102\u001a\u00020\u00012\n\u0010/\u001a\u0006\u0012\u0002\b\u000300H\u0016J\u0010\u00103\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0014\u00104\u001a\u00020\u001b2\n\u00105\u001a\u000606j\u0002`7H\u0002J\u001c\u00108\u001a\u00020\u00122\n\u00105\u001a\u000606j\u0002`72\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020\u0006H\u0002J\b\u0010:\u001a\u00020\u0003H\u0016J\u0006\u0010;\u001a\u00020\u001bJ\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lkotlinx/coroutines/test/TestCoroutineContext;", "Lkotlin/coroutines/CoroutineContext;", "name", "", "(Ljava/lang/String;)V", "counter", "", "ctxDispatcher", "Lkotlinx/coroutines/test/TestCoroutineContext$Dispatcher;", "ctxHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "exceptions", "", "", "getExceptions", "()Ljava/util/List;", "queue", "Lkotlinx/coroutines/internal/ThreadSafeHeap;", "Lkotlinx/coroutines/test/TimedRunnable;", "time", "uncaughtExceptions", "", "advanceTimeBy", "delayTime", "unit", "Ljava/util/concurrent/TimeUnit;", "advanceTimeTo", "", "targetTime", "assertAllUnhandledExceptions", "message", "predicate", "Lkotlin/Function1;", "", "assertAnyUnhandledException", "assertExceptions", "assertUnhandledException", "cancelAllActions", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext$Element;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "get", "E", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;", "minusKey", "now", "post", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "postDelayed", "processNextEvent", "toString", "triggerActions", "Dispatcher", "kotlinx-coroutines-core"})
public final class TestCoroutineContext
implements CoroutineContext {
    private final List<Throwable> uncaughtExceptions;
    private final Dispatcher ctxDispatcher;
    private final CoroutineExceptionHandler ctxHandler;
    private final ThreadSafeHeap<TimedRunnable> queue;
    private long counter;
    private long time;
    private final String name;

    @NotNull
    public final List<Throwable> getExceptions() {
        return this.uncaughtExceptions;
    }

    @Override
    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        return operation.invoke(operation.invoke(initial, this.ctxDispatcher), this.ctxHandler);
    }

    @Override
    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        CoroutineContext.Element element;
        Intrinsics.checkParameterIsNotNull(key, "key");
        if (key == ContinuationInterceptor.Key) {
            Dispatcher dispatcher = this.ctxDispatcher;
            if (dispatcher == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            element = dispatcher;
        } else if (key == CoroutineExceptionHandler.Key) {
            CoroutineExceptionHandler coroutineExceptionHandler = this.ctxHandler;
            if (coroutineExceptionHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            element = coroutineExceptionHandler;
        } else {
            element = null;
        }
        return (E)element;
    }

    @Override
    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        return key == ContinuationInterceptor.Key ? (CoroutineContext)this.ctxHandler : (key == CoroutineExceptionHandler.Key ? (CoroutineContext)this.ctxDispatcher : (CoroutineContext)this);
    }

    public final long now(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        return unit.convert(this.time, TimeUnit.NANOSECONDS);
    }

    public static /* synthetic */ long now$default(TestCoroutineContext testCoroutineContext, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return testCoroutineContext.now(timeUnit);
    }

    public final long advanceTimeBy(long delayTime, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        long oldTime = this.time;
        this.advanceTimeTo(oldTime + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
        return unit.convert(this.time - oldTime, TimeUnit.NANOSECONDS);
    }

    public static /* synthetic */ long advanceTimeBy$default(TestCoroutineContext testCoroutineContext, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return testCoroutineContext.advanceTimeBy(l, timeUnit);
    }

    public final void advanceTimeTo(long targetTime, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        long nanoTime = unit.toNanos(targetTime);
        this.triggerActions(nanoTime);
        if (nanoTime > this.time) {
            this.time = nanoTime;
        }
    }

    public static /* synthetic */ void advanceTimeTo$default(TestCoroutineContext testCoroutineContext, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        testCoroutineContext.advanceTimeTo(l, timeUnit);
    }

    public final void triggerActions() {
        this.triggerActions(this.time);
    }

    public final void cancelAllActions() {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
        }
    }

    public final void assertUnhandledException(@NotNull String message, @NotNull Function1<? super Throwable, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        if (this.uncaughtExceptions.size() != 1 || !predicate.invoke(this.uncaughtExceptions.get(0)).booleanValue()) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertUnhandledException$default(TestCoroutineContext testCoroutineContext, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        testCoroutineContext.assertUnhandledException(string2, function1);
    }

    public final void assertAllUnhandledExceptions(@NotNull String message, @NotNull Function1<? super Throwable, Boolean> predicate) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull(message, "message");
            Intrinsics.checkParameterIsNotNull(predicate, "predicate");
            Iterable $receiver$iv = this.uncaughtExceptions;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    if (predicate.invoke((Throwable)element$iv).booleanValue()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertAllUnhandledExceptions$default(TestCoroutineContext testCoroutineContext, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        testCoroutineContext.assertAllUnhandledExceptions(string2, function1);
    }

    public final void assertAnyUnhandledException(@NotNull String message, @NotNull Function1<? super Throwable, Boolean> predicate) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull(message, "message");
            Intrinsics.checkParameterIsNotNull(predicate, "predicate");
            Iterable $receiver$iv = this.uncaughtExceptions;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    if (!predicate.invoke((Throwable)element$iv).booleanValue()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertAnyUnhandledException$default(TestCoroutineContext testCoroutineContext, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        testCoroutineContext.assertAnyUnhandledException(string2, function1);
    }

    public final void assertExceptions(@NotNull String message, @NotNull Function1<? super List<? extends Throwable>, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        if (!predicate.invoke(this.uncaughtExceptions).booleanValue()) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertExceptions$default(TestCoroutineContext testCoroutineContext, String string2, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        testCoroutineContext.assertExceptions(string2, function1);
    }

    private final void post(Runnable block) {
        long l = this.counter;
        this.counter = l + 1L;
        this.queue.addLast((TimedRunnable)((ThreadSafeHeapNode)new TimedRunnable(block, l, 0L, 4, null)));
    }

    private final TimedRunnable postDelayed(Runnable block, long delayTime) {
        TimedRunnable timedRunnable;
        long l = this.counter;
        this.counter = l + 1L;
        TimedRunnable it = timedRunnable = new TimedRunnable(block, l, this.time + TimeUnit.MILLISECONDS.toNanos(delayTime));
        this.queue.addLast((TimedRunnable)((ThreadSafeHeapNode)it));
        return timedRunnable;
    }

    private final long processNextEvent() {
        TimedRunnable current = this.queue.peek();
        if (current != null) {
            this.triggerActions(current.time);
        }
        return this.queue.isEmpty() ? Long.MAX_VALUE : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void triggerActions(long targetTime) {
        while (true) {
            TimedRunnable current;
            TimedRunnable timedRunnable;
            ThreadSafeHeap<TimedRunnable> this_$iv;
            ThreadSafeHeap<TimedRunnable> lock$iv$iv = this_$iv = this.queue;
            synchronized (lock$iv$iv) {
                TimedRunnable timedRunnable2;
                if (this_$iv.firstImpl() == null) {
                    timedRunnable2 = null;
                } else {
                    TimedRunnable first$iv;
                    TimedRunnable it = first$iv;
                    timedRunnable2 = it.time <= targetTime ? this_$iv.removeAtImpl(0) : null;
                }
                timedRunnable = timedRunnable2;
            }
            if ((TimedRunnable)timedRunnable == null) {
                break;
            }
            if (current.time != 0L) {
                this.time = current.time;
            }
            current.run();
        }
    }

    @NotNull
    public String toString() {
        String string2 = this.name;
        if (string2 == null) {
            string2 = "TestCoroutineContext@" + DebugKt.getHexAddress(this);
        }
        return string2;
    }

    public TestCoroutineContext(@Nullable String name2) {
        this.name = name2;
        TestCoroutineContext testCoroutineContext = this;
        Object object = new ArrayList();
        testCoroutineContext.uncaughtExceptions = object;
        this.ctxDispatcher = new Dispatcher();
        testCoroutineContext = this;
        testCoroutineContext.ctxHandler = object = (CoroutineExceptionHandler)new CoroutineExceptionHandler(CoroutineExceptionHandler.Key, this){
            final /* synthetic */ TestCoroutineContext this$0;
            {
                this.this$0 = testCoroutineContext;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                void exception2;
                Intrinsics.checkParameterIsNotNull(context, "context");
                Intrinsics.checkParameterIsNotNull(exception, "exception");
                Throwable throwable = exception;
                CoroutineContext $noName_0 = context;
                Collection collection = TestCoroutineContext.access$getUncaughtExceptions$p(this.this$0);
                collection.add(exception2);
            }
        };
        this.queue = new ThreadSafeHeap();
    }

    public /* synthetic */ TestCoroutineContext(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        this(string2);
    }

    public TestCoroutineContext() {
        this(null, 1, null);
    }

    @Override
    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        return CoroutineContext.DefaultImpls.plus(this, context);
    }

    @NotNull
    public static final /* synthetic */ ThreadSafeHeap access$getQueue$p(TestCoroutineContext $this) {
        return $this.queue;
    }

    @NotNull
    public static final /* synthetic */ List access$getUncaughtExceptions$p(TestCoroutineContext $this) {
        return $this.uncaughtExceptions;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J&\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lkotlinx/coroutines/test/TestCoroutineContext$Dispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "Lkotlinx/coroutines/Delay;", "Lkotlinx/coroutines/EventLoop;", "(Lkotlinx/coroutines/test/TestCoroutineContext;)V", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "invokeOnTimeout", "Lkotlinx/coroutines/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "processNextEvent", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/CancellableContinuation;", "toString", "", "kotlinx-coroutines-core"})
    private final class Dispatcher
    extends CoroutineDispatcher
    implements Delay,
    EventLoop {
        @Override
        public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(block, "block");
            TestCoroutineContext.this.post(block);
        }

        @Override
        public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation2) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
            TestCoroutineContext testCoroutineContext = TestCoroutineContext.this;
            Runnable runnable = new Runnable(this, continuation2){
                final /* synthetic */ Dispatcher this$0;
                final /* synthetic */ CancellableContinuation $continuation$inlined;
                {
                    this.this$0 = dispatcher;
                    this.$continuation$inlined = cancellableContinuation;
                }

                public final void run() {
                    CancellableContinuation cancellableContinuation;
                    CancellableContinuation $receiver = cancellableContinuation = this.$continuation$inlined;
                    $receiver.resumeUndispatched(this.this$0, Unit.INSTANCE);
                }
            };
            testCoroutineContext.postDelayed(runnable, unit.toMillis(time));
        }

        @Override
        @NotNull
        public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            Intrinsics.checkParameterIsNotNull(block, "block");
            TimedRunnable node = TestCoroutineContext.this.postDelayed(block, unit.toMillis(time));
            return new DisposableHandle(this, node){
                final /* synthetic */ Dispatcher this$0;
                final /* synthetic */ TimedRunnable $node;

                public void dispose() {
                    TestCoroutineContext.access$getQueue$p(this.this$0.TestCoroutineContext.this).remove((ThreadSafeHeapNode)this.$node);
                }
                {
                    this.this$0 = $outer;
                    this.$node = $captured_local_variable$1;
                }
            };
        }

        @Override
        public long processNextEvent() {
            return TestCoroutineContext.this.processNextEvent();
        }

        @Override
        @NotNull
        public String toString() {
            return "Dispatcher(" + TestCoroutineContext.this + ')';
        }

        @Override
        @Nullable
        public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> continuation2) {
            return Delay.DefaultImpls.delay(this, time, unit, continuation2);
        }
    }
}

