/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER;
import org.jetbrains.kotlin.backend.common.lower.InitializersLowering;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend"})
public final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final JvmBackendContext context;

    @NotNull
    public final GenerationState getState() {
        return this.state;
    }

    @Override
    public void lower(@NotNull IrClass irClass) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv$iv2;
        Object element$iv2;
        Iterator $receiver$iv$iv3;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        if (!IrUtilsKt.isInterface(irClass)) {
            return;
        }
        IrClass defaultImplsIrClass = this.context.getDeclarationFactory().getDefaultImplsClass(irClass);
        irClass.getDeclarations().add(defaultImplsIrClass);
        List<IrDeclaration> members2 = defaultImplsIrClass.getDeclarations();
        Iterable iterable = $receiver$iv = (Iterable)irClass.getDeclarations();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv2 : $receiver$iv) {
            IrFunction it = (IrFunction)element$iv2;
            FunctionDescriptor descriptor2 = it.getDescriptor();
            if (Intrinsics.areEqual(it.getOrigin(), DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) {
                members2.add(it);
                continue;
            }
            if (descriptor2.getModality() == Modality.ABSTRACT || !(Intrinsics.areEqual(it.getOrigin(), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) ^ true)) continue;
            IrFunction element = this.context.getDeclarationFactory().getDefaultImplsFunction(it);
            members2.add(element);
            element.setBody(it.getBody());
            it.setBody(null);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
        Iterable $receiver$iv2 = irClass.getDeclarations();
        element$iv2 = $receiver$iv2;
        Iterable<IrFunction> destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv2;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            IrFunction irFunction;
            Object element$iv$iv = element$iv$iv$iv;
            IrFunction it = (IrFunction)element$iv$iv;
            int visibility = AsmUtil.getVisibilityAccessFlag(it.getDescriptor());
            IrFunction irFunction2 = visibility == 2 && Intrinsics.areEqual(it.getDescriptor().getName(), InitializersLowering.Companion.getClinitName()) ^ true ? it : null;
            if (irFunction2 == null) continue;
            IrFunction it$iv$iv = irFunction = irFunction2;
            destination$iv$iv2.add(it$iv$iv);
        }
        List privateToRemove = (List)destination$iv$iv2;
        Iterable $receiver$iv3 = irClass.getDeclarations();
        destination$iv$iv2 = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $receiver$iv3 = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv3;
        destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            if (!Intrinsics.areEqual(it.getOrigin(), DECLARATION_ORIGIN_FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List defaultBodies = (List)destination$iv$iv3;
        irClass.getDeclarations().removeAll(privateToRemove);
        irClass.getDeclarations().removeAll(defaultBodies);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InterfaceLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.state = this.context.getState();
    }
}

