/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.LineSeparator;
import java.util.EnumSet;
import java.util.Set;
import kotlin.text.StringsKt;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.internal.CLibrary;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

public abstract class PlainTextMessageRenderer
implements MessageRenderer {
    public static final String KOTLIN_COLORS_ENABLED_PROPERTY = "kotlin.colors.enabled";
    public static final boolean COLOR_ENABLED;
    private static final String LINE_SEPARATOR;
    private static final Set<CompilerMessageSeverity> IMPORTANT_MESSAGE_SEVERITIES;

    @Override
    public String renderPreamble() {
        return "";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location2) {
        String path2;
        StringBuilder result2 = new StringBuilder();
        int line = location2 != null ? location2.getLine() : -1;
        int column = location2 != null ? location2.getColumn() : -1;
        String lineContent = location2 != null ? location2.getLineContent() : null;
        String string2 = path2 = location2 != null ? this.getPath(location2) : null;
        if (path2 != null) {
            result2.append(path2);
            result2.append(":");
            if (line > 0) {
                result2.append(line).append(":");
                if (column > 0) {
                    result2.append(column).append(":");
                }
            }
            result2.append(" ");
        }
        if (COLOR_ENABLED) {
            String decapitalized;
            int firstNewline;
            Ansi ansi = Ansi.ansi().bold().fg(PlainTextMessageRenderer.severityColor(severity)).a(severity.getPresentableName()).a(": ").reset();
            if (IMPORTANT_MESSAGE_SEVERITIES.contains((Object)severity)) {
                ansi.bold();
            }
            if ((firstNewline = (decapitalized = PlainTextMessageRenderer.decapitalizeIfNeeded(message)).indexOf(LINE_SEPARATOR)) < 0) {
                result2.append(ansi.a(decapitalized).reset());
            } else {
                result2.append(ansi.a(decapitalized.substring(0, firstNewline)).reset().a(decapitalized.substring(firstNewline)));
            }
        } else {
            result2.append(severity.getPresentableName());
            result2.append(": ");
            result2.append(PlainTextMessageRenderer.decapitalizeIfNeeded(message));
        }
        if (lineContent != null && 1 <= column && column <= lineContent.length() + 1) {
            result2.append(LINE_SEPARATOR);
            result2.append(lineContent);
            result2.append(LINE_SEPARATOR);
            result2.append(StringsKt.repeat(" ", column - 1));
            result2.append("^");
        }
        return result2.toString();
    }

    @NotNull
    private static String decapitalizeIfNeeded(@NotNull String message) {
        if (message.startsWith("Java") || message.startsWith("Kotlin")) {
            return message;
        }
        if (message.length() >= 2 && Character.isUpperCase(message.charAt(0)) && Character.isUpperCase(message.charAt(1))) {
            return message;
        }
        return StringsKt.decapitalize(message);
    }

    @NotNull
    private static Ansi.Color severityColor(@NotNull CompilerMessageSeverity severity) {
        switch (severity) {
            case EXCEPTION: {
                return Ansi.Color.RED;
            }
            case ERROR: {
                return Ansi.Color.RED;
            }
            case STRONG_WARNING: {
                return Ansi.Color.YELLOW;
            }
            case WARNING: {
                return Ansi.Color.YELLOW;
            }
            case INFO: {
                return Ansi.Color.BLUE;
            }
            case LOGGING: {
                return Ansi.Color.BLUE;
            }
            case OUTPUT: {
                return Ansi.Color.BLUE;
            }
        }
        throw new UnsupportedOperationException("Unknown severity: " + (Object)((Object)severity));
    }

    @Nullable
    protected abstract String getPath(@NotNull CompilerMessageLocation var1);

    @Override
    public String renderUsage(@NotNull String usage2) {
        return usage2;
    }

    @Override
    public String renderConclusion() {
        return "";
    }

    static {
        boolean colorEnabled = false;
        if (!SystemInfo.isWindows && "true".equals(System.getProperty(KOTLIN_COLORS_ENABLED_PROPERTY))) {
            try {
                colorEnabled = CLibrary.isatty(CLibrary.STDERR_FILENO) != 0;
            }
            catch (UnsatisfiedLinkError e) {
                colorEnabled = false;
            }
        }
        COLOR_ENABLED = colorEnabled;
        LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
        IMPORTANT_MESSAGE_SEVERITIES = EnumSet.of(CompilerMessageSeverity.EXCEPTION, CompilerMessageSeverity.ERROR, CompilerMessageSeverity.STRONG_WARNING, CompilerMessageSeverity.WARNING);
    }
}

