/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.BytesUrlUtils;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class GeneratedClassLoader
extends URLClassLoader {
    private ClassFileFactory factory;

    public GeneratedClassLoader(@NotNull ClassFileFactory factory2, ClassLoader parentClassLoader, URL ... urls) {
        super(urls, parentClassLoader);
        this.factory = factory2;
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        OutputFile outputFile = this.factory.get(name2);
        if (outputFile != null) {
            return new ByteArrayInputStream(outputFile.asByteArray());
        }
        return super.getResourceAsStream(name2);
    }

    @Override
    public Enumeration<URL> findResources(String name2) throws IOException {
        Enumeration<URL> fromParent = super.findResources(name2);
        URL url = this.createFakeURLForResource(name2);
        if (url == null) {
            return fromParent;
        }
        List<URL> fromMe = Collections.singletonList(url);
        List<URL> result2 = fromParent.hasMoreElements() ? CollectionsKt.plus(fromMe, Collections.list(fromParent)) : fromMe;
        return Collections.enumeration(result2);
    }

    @Override
    public URL findResource(String name2) {
        URL url = this.createFakeURLForResource(name2);
        return url != null ? url : super.findResource(name2);
    }

    @Nullable
    private URL createFakeURLForResource(@NotNull String name2) {
        try {
            OutputFile outputFile = this.factory.get(name2);
            return outputFile == null ? null : BytesUrlUtils.createBytesUrl(outputFile.asByteArray());
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        String classFilePath = name2.replace('.', '/') + ".class";
        OutputFile outputFile = this.factory.get(classFilePath);
        if (outputFile != null) {
            String pkgName;
            byte[] bytes = outputFile.asByteArray();
            int lastDot = name2.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(pkgName = name2.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, new Manifest(), null);
            }
            return this.defineClass(name2, bytes, 0, bytes.length);
        }
        return super.findClass(name2);
    }

    public void dispose() {
        this.factory = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        return this.factory.asList();
    }
}

