/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CollectionStubMethodGenerator;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ConstructorCodegen;
import org.jetbrains.kotlin.codegen.DelegationFieldsInfo;
import org.jetbrains.kotlin.codegen.ErasedInlineClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionsFromAnyGeneratorImpl;
import org.jetbrains.kotlin.codegen.InterfaceImplBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SuperClassInfo;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtils2Kt;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmClassSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ImplementationBodyCodegen
extends ClassBodyCodegen {
    private Type superClassAsmType;
    @NotNull
    private SuperClassInfo superClassInfo;
    private final Type classAsmType;
    private final boolean isLocal;
    private List<PropertyAndDefaultValue> companionObjectPropertiesToCopy;
    private final DelegationFieldsInfo delegationFieldsInfo;
    private final List<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>> additionalTasks = new ArrayList<Function2<ImplementationBodyCodegen, ClassBuilder, Unit>>();
    private final DescriptorSerializer serializer;
    private final ConstructorCodegen constructorCodegen;
    private static final Map<FqName, String> KOTLIN_MARKER_INTERFACES = new HashMap<FqName, String>();

    public ImplementationBodyCodegen(@NotNull KtPureClassOrObject aClass2, @NotNull ClassContext context, @NotNull ClassBuilder v2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen, boolean isLocal) {
        super(aClass2, context, v2, state2, parentCodegen);
        this.classAsmType = Type.getObjectType(this.typeMapper.classInternalName(this.descriptor));
        this.isLocal = isLocal;
        this.delegationFieldsInfo = new DelegationFieldsInfo(this.classAsmType, this.descriptor, state2, this.bindingContext).getDelegationFieldsInfo(this.myClass.getSuperTypeListEntries());
        JvmSerializerExtension extension = new JvmSerializerExtension(v2.getSerializationBindings(), state2);
        this.serializer = DescriptorSerializer.create(this.descriptor, extension, parentCodegen instanceof ImplementationBodyCodegen ? ((ImplementationBodyCodegen)parentCodegen).serializer : DescriptorSerializer.createTopLevel(extension));
        this.constructorCodegen = new ConstructorCodegen(this.descriptor, context, this.functionCodegen, this, this, state2, this.kind, v2, this.classAsmType, this.myClass, this.bindingContext);
    }

    @Override
    protected void generateDeclaration() {
        this.superClassInfo = SuperClassInfo.getSuperClassInfo(this.descriptor, this.typeMapper);
        this.superClassAsmType = this.superClassInfo.getType();
        JvmClassSignature signature2 = this.signature();
        boolean isAbstract = false;
        boolean isInterface = false;
        boolean isFinal = false;
        boolean isAnnotation = false;
        boolean isEnum = false;
        ClassKind kind = this.descriptor.getKind();
        Modality modality = this.descriptor.getModality();
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            isAbstract = true;
        }
        if (kind == ClassKind.INTERFACE) {
            isAbstract = true;
            isInterface = true;
        } else if (kind == ClassKind.ANNOTATION_CLASS) {
            isAbstract = true;
            isInterface = true;
            isAnnotation = true;
        } else if (kind == ClassKind.ENUM_CLASS) {
            isAbstract = JvmCodegenUtil.hasAbstractMembers(this.descriptor);
            isEnum = true;
        }
        if (modality != Modality.OPEN && !isAbstract) {
            isFinal = kind == ClassKind.OBJECT || kind != ClassKind.ENUM_CLASS || this.state.getClassBuilderMode().generateBodies;
        }
        int access = 0;
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !DescriptorUtils.isTopLevelDeclaration(this.descriptor)) {
            access |= AsmUtil.getVisibilityAccessFlag(this.descriptor);
            if (!this.descriptor.isInner()) {
                access |= 8;
            }
        } else {
            access |= AsmUtil.getVisibilityAccessFlagForClass(this.descriptor);
        }
        if (isAbstract) {
            access |= 0x400;
        }
        access = isInterface ? (access |= 0x200) : (access |= 0x20);
        if (isFinal) {
            access |= 0x10;
        }
        if (isAnnotation) {
            access |= 0x2000;
        }
        if (KotlinBuiltIns.isDeprecated(this.descriptor)) {
            access |= 0x20000;
        }
        if (isEnum) {
            for (KtDeclaration declaration : this.myClass.getDeclarations()) {
                if (!(declaration instanceof KtEnumEntry) || !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) continue;
                access &= 0xFFFFFFEF;
            }
            access |= 0x4000;
        }
        this.v.defineClass(this.myClass.getPsiOrParent(), this.state.getClassFileVersion(), access, signature2.getName(), signature2.getJavaGenericSignature(), signature2.getSuperclassName(), ArrayUtil.toStringArray(signature2.getInterfaces()));
        this.v.visitSource(this.myClass.getContainingKtFile().getName(), null);
        InlineCodegenUtils2Kt.initDefaultSourceMappingIfNeeded(this.context, this, this.state);
        this.writeEnclosingMethod();
        AnnotationCodegen.forClass(this.v.getVisitor(), this, this.typeMapper).genAnnotations(this.descriptor, null);
        this.generateEnumEntries();
    }

    @Override
    protected void generateDefaultImplsIfNeeded() {
        if (DescriptorUtils.isInterface(this.descriptor) && !this.isLocal) {
            Type defaultImplsType = this.state.getTypeMapper().mapDefaultImpls(this.descriptor);
            ClassBuilder defaultImplsBuilder = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.DefaultImpls(this.myClass.getPsiOrParent(), this.descriptor), defaultImplsType, this.myClass.getContainingKtFile());
            CodegenContext parentContext = this.context.getParentContext();
            assert (parentContext != null) : "Parent context of interface declaration should not be null";
            ClassContext defaultImplsContext = parentContext.intoDefaultImplsClass(this.descriptor, (ClassContext)this.context, this.state);
            new InterfaceImplBodyCodegen(this.myClass, defaultImplsContext, defaultImplsBuilder, this.state, this).generate();
        }
    }

    @Override
    protected void generateErasedInlineClassIfNeeded() {
        if (!(this.myClass instanceof KtClass)) {
            return;
        }
        if (!this.descriptor.isInline()) {
            return;
        }
        CodegenContext parentContext = this.context.getParentContext();
        assert (parentContext != null) : "Parent context of inline class declaration should not be null";
        ClassContext erasedInlineClassContext = parentContext.intoWrapperForErasedInlineClass(this.descriptor, this.state);
        new ErasedInlineClassBodyCodegen((KtClass)this.myClass, erasedInlineClassContext, this.v, this.state, this).generate();
    }

    @Override
    protected void generateUnboxMethodForInlineClass() {
        if (!(this.myClass instanceof KtClass)) {
            return;
        }
        if (!this.descriptor.isInline()) {
            return;
        }
        final Type ownerType = this.typeMapper.mapClass(this.descriptor);
        final ValueParameterDescriptor inlinedValue = InlineClassesUtilsKt.underlyingRepresentation(this.descriptor);
        if (inlinedValue == null) {
            return;
        }
        final Type valueType = this.typeMapper.mapType(inlinedValue.getType());
        SimpleFunctionDescriptor functionDescriptor = InlineClassDescriptorResolver.createUnboxFunctionDescriptor(this.descriptor);
        assert (functionDescriptor != null) : "FunctionDescriptor for unbox method should be not null during codegen";
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.UnboxMethodOfInlineClass(functionDescriptor), functionDescriptor, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
                InstructionAdapter iv = codegen.v;
                iv.load(0, AsmTypes.OBJECT_TYPE);
                iv.getfield(ownerType.getInternalName(), inlinedValue.getName().asString(), valueType.getDescriptor());
                iv.areturn(valueType);
            }
        });
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        ProtoBuf.Class classProto = this.serializer.classProto(this.descriptor).build();
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.CLASS, 0, av -> {
            AsmUtil.writeAnnotationData(av, this.serializer, classProto);
            return Unit.INSTANCE;
        });
    }

    private void writeEnclosingMethod() {
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor) || !(this.descriptor.getContainingDeclaration() instanceof ClassOrPackageFragmentDescriptor)) {
            this.writeOuterClassAndEnclosingMethod();
        }
    }

    @NotNull
    private JvmClassSignature signature() {
        return ImplementationBodyCodegen.signature(this.descriptor, this.classAsmType, this.superClassInfo, this.typeMapper);
    }

    @NotNull
    public static JvmClassSignature signature(@NotNull ClassDescriptor descriptor2, @NotNull Type classAsmType, @NotNull SuperClassInfo superClassInfo, @NotNull KotlinTypeMapper typeMapper) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        typeMapper.writeFormalTypeParameters(descriptor2.getDeclaredTypeParameters(), sw);
        ((JvmSignatureWriter)sw).writeSuperclass();
        if (superClassInfo.getKotlinType() == null) {
            ((JvmSignatureWriter)sw).writeClassBegin(superClassInfo.getType());
            ((JvmSignatureWriter)sw).writeClassEnd();
        } else {
            typeMapper.mapSupertype(superClassInfo.getKotlinType(), sw);
        }
        ((JvmSignatureWriter)sw).writeSuperclassEnd();
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        LinkedHashSet<String> kotlinMarkerInterfaces = new LinkedHashSet<String>();
        for (KotlinType supertype : descriptor2.getTypeConstructor().getSupertypes()) {
            if (!JvmCodegenUtil.isJvmInterface(supertype.getConstructor().getDeclarationDescriptor())) continue;
            FqName kotlinInterfaceName = DescriptorUtils.getFqName(supertype.getConstructor().getDeclarationDescriptor()).toSafe();
            ((JvmSignatureWriter)sw).writeInterface();
            Type jvmInterfaceType = typeMapper.mapSupertype(supertype, sw);
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
            String jvmInterfaceInternalName = jvmInterfaceType.getInternalName();
            superInterfaces.add(jvmInterfaceInternalName);
            String kotlinMarkerInterfaceInternalName = KOTLIN_MARKER_INTERFACES.get(kotlinInterfaceName);
            if (kotlinMarkerInterfaceInternalName == null) continue;
            if (typeMapper.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
                ((JvmSignatureWriter)sw).writeInterface();
                Type kotlinCollectionType = typeMapper.mapType(supertype, sw, TypeMappingMode.SUPER_TYPE_KOTLIN_COLLECTIONS_AS_IS);
                ((JvmSignatureWriter)sw).writeInterfaceEnd();
                superInterfaces.add(kotlinCollectionType.getInternalName());
            }
            kotlinMarkerInterfaces.add(kotlinMarkerInterfaceInternalName);
        }
        for (String kotlinMarkerInterface : kotlinMarkerInterfaces) {
            ((JvmSignatureWriter)sw).writeInterface();
            ((JvmSignatureWriter)sw).writeAsmType(Type.getObjectType(kotlinMarkerInterface));
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
        }
        superInterfaces.addAll(kotlinMarkerInterfaces);
        return new JvmClassSignature(classAsmType.getInternalName(), superClassInfo.getType().getInternalName(), new ArrayList<String>(superInterfaces), ((JvmSignatureWriter)sw).makeJavaGenericSignature());
    }

    @Override
    protected void generateSyntheticPartsBeforeBody() {
        this.generatePropertyMetadataArrayFieldIfNeeded(this.classAsmType);
    }

    @Override
    protected void generateSyntheticPartsAfterBody() {
        this.generateFieldForSingleton();
        this.initializeObjects();
        this.generateCompanionObjectBackingFieldCopies();
        this.generateTraitMethods();
        this.generateDelegates(this.delegationFieldsInfo);
        this.generateSyntheticAccessors();
        this.generateEnumMethods();
        this.generateFunctionsForDataClasses();
        this.generateFunctionsFromAnyForInlineClasses();
        if (this.state.getClassBuilderMode() != ClassBuilderMode.LIGHT_CLASSES) {
            new CollectionStubMethodGenerator(this.typeMapper, this.descriptor).generate(this.functionCodegen, this.v);
            this.generateToArray();
        }
        if (this.context.closure != null) {
            AsmUtil.genClosureFields(this.context.closure, this.v, this.typeMapper, this.state.getLanguageVersionSettings());
        }
        for (ExpressionCodegenExtension extension : ExpressionCodegenExtension.Companion.getInstances(this.state.getProject())) {
            if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES && !extension.getShouldGenerateClassSyntheticPartsInLightClassesMode()) continue;
            extension.generateClassSyntheticParts(this);
        }
    }

    @Override
    protected void generateConstructors() {
        try {
            this.lookupConstructorExpressionsInClosureIfPresent();
            this.constructorCodegen.generatePrimaryConstructor(this.delegationFieldsInfo, this.superClassAsmType);
            if (!this.descriptor.isInline()) {
                for (ClassConstructorDescriptor secondaryConstructor : DescriptorUtilsKt.getSecondaryConstructors(this.descriptor)) {
                    this.constructorCodegen.generateSecondaryConstructor(secondaryConstructor, this.superClassAsmType);
                }
            }
        }
        catch (ProcessCanceledException | CompilationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error generating constructors of class " + this.myClass.getName() + " with kind " + (Object)((Object)this.kind), e);
        }
    }

    private void generateToArray() {
        MethodVisitor mv;
        if (this.descriptor.getKind() == ClassKind.INTERFACE) {
            return;
        }
        KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(this.descriptor);
        if (!DescriptorUtils.isSubclass(this.descriptor, builtIns.getCollection())) {
            return;
        }
        if (CollectionsKt.any(DescriptorUtilsKt.getAllSuperclassesWithoutAny(this.descriptor), classDescriptor2 -> !(classDescriptor2 instanceof JavaClassDescriptor) && DescriptorUtils.isSubclass(classDescriptor2, builtIns.getCollection()))) {
            return;
        }
        Collection<SimpleFunctionDescriptor> functions2 = this.descriptor.getDefaultType().getMemberScope().getContributedFunctions(Name.identifier("toArray"), NoLookupLocation.FROM_BACKEND);
        boolean hasGenericToArray = false;
        boolean hasNonGenericToArray = false;
        for (FunctionDescriptor functionDescriptor : functions2) {
            hasGenericToArray |= CodegenUtilKt.isGenericToArray(functionDescriptor);
            hasNonGenericToArray |= CodegenUtilKt.isNonGenericToArray(functionDescriptor);
        }
        if (!hasNonGenericToArray) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "toArray", "()[Ljava/lang/Object;", null, null);
            InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
            mv.visitCode();
            instructionAdapter.load(0, this.classAsmType);
            instructionAdapter.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;)[Ljava/lang/Object;", false);
            instructionAdapter.areturn(Type.getType("[Ljava/lang/Object;"));
            FunctionCodegen.endVisit(mv, "toArray", this.myClass);
        }
        if (!hasGenericToArray) {
            mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", "<T:Ljava/lang/Object;>([TT;)[TT;", null);
            InstructionAdapter instructionAdapter = new InstructionAdapter(mv);
            mv.visitCode();
            instructionAdapter.load(0, this.classAsmType);
            instructionAdapter.load(1, Type.getType("[Ljava/lang/Object;"));
            instructionAdapter.invokestatic("kotlin/jvm/internal/CollectionToArray", "toArray", "(Ljava/util/Collection;[Ljava/lang/Object;)[Ljava/lang/Object;", false);
            instructionAdapter.areturn(Type.getType("[Ljava/lang/Object;"));
            FunctionCodegen.endVisit(mv, "toArray", this.myClass);
        }
    }

    public static JvmKotlinType genPropertyOnStack(InstructionAdapter iv, MethodContext context, @NotNull PropertyDescriptor propertyDescriptor, Type classAsmType, int index2, GenerationState state2) {
        iv.load(index2, classAsmType);
        if (JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, false, context, state2.getShouldInlineConstVals())) {
            KotlinType kotlinType = propertyDescriptor.getType();
            Type type2 = state2.getTypeMapper().mapType(kotlinType);
            String fieldName = ((FieldOwnerContext)context.getParentContext()).getFieldName(propertyDescriptor, false);
            iv.getfield(classAsmType.getInternalName(), fieldName, type2.getDescriptor());
            return new JvmKotlinType(type2, kotlinType);
        }
        PropertyGetterDescriptor getter2 = propertyDescriptor.getGetter();
        Method method = state2.getTypeMapper().mapAsmMethod(getter2);
        iv.invokevirtual(classAsmType.getInternalName(), method.getName(), method.getDescriptor(), false);
        return new JvmKotlinType(method.getReturnType(), getter2.getReturnType());
    }

    private void generateFunctionsForDataClasses() {
        if (!this.descriptor.isData()) {
            return;
        }
        if (!(this.myClass instanceof KtClassOrObject)) {
            return;
        }
        new DataClassMethodGeneratorImpl((KtClassOrObject)this.myClass, this.bindingContext).generate();
    }

    private void generateFunctionsFromAnyForInlineClasses() {
        if (!this.descriptor.isInline()) {
            return;
        }
        if (!(this.myClass instanceof KtClassOrObject)) {
            return;
        }
        new FunctionsFromAnyGeneratorImpl((KtClassOrObject)this.myClass, this.bindingContext, this.descriptor, this.classAsmType, this.context, this.v, this.state).generate();
    }

    @NotNull
    private static ConstructorDescriptor getPrimaryConstructorOfDataClass(@NotNull ClassDescriptor classDescriptor2) {
        ClassConstructorDescriptor constructor = classDescriptor2.getUnsubstitutedPrimaryConstructor();
        assert (constructor != null) : "Data class must have primary constructor: " + classDescriptor2;
        return constructor;
    }

    private void generateEnumMethods() {
        if (DescriptorUtils.isEnumClass(this.descriptor)) {
            this.generateEnumValuesMethod();
            this.generateEnumValueOfMethod();
        }
    }

    private void generateEnumValuesMethod() {
        Type type2 = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        FunctionDescriptor valuesFunction = CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUES, NoLookupLocation.FROM_BACKEND));
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass, valuesFunction), 9, DescriptorUtils.ENUM_VALUES.asString(), "()" + type2.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        mv.visitFieldInsn(178, this.classAsmType.getInternalName(), "$VALUES", type2.getDescriptor());
        mv.visitMethodInsn(182, type2.getInternalName(), "clone", "()Ljava/lang/Object;", false);
        mv.visitTypeInsn(192, type2.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "values()", this.myClass);
    }

    private void generateEnumValueOfMethod() {
        FunctionDescriptor valueOfFunction = CollectionsKt.single(this.descriptor.getStaticScope().getContributedFunctions(DescriptorUtils.ENUM_VALUE_OF, NoLookupLocation.FROM_BACKEND), DescriptorUtilsKt::isEnumValueOfMethod);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass, valueOfFunction), 9, DescriptorUtils.ENUM_VALUE_OF.asString(), "(Ljava/lang/String;)" + this.classAsmType.getDescriptor(), null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        mv.visitLdcInsn(this.classAsmType);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        mv.visitTypeInsn(192, this.classAsmType.getInternalName());
        mv.visitInsn(176);
        FunctionCodegen.endVisit(mv, "valueOf()", this.myClass);
    }

    private void generateFieldForSingleton() {
        StackValue.Field field;
        if (JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(this.descriptor)) {
            field = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, "$$INSTANCE");
            this.v.newField(JvmDeclarationOriginKt.OtherOrigin(this.descriptor), 4120, field.name, field.type.getDescriptor(), null, null);
        }
        if (DescriptorUtils.isEnumEntry(this.descriptor) || DescriptorUtils.isCompanionObject(this.descriptor)) {
            return;
        }
        if (DescriptorUtils.isNonCompanionObject(this.descriptor)) {
            field = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, "INSTANCE");
            this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass), 25, field.name, field.type.getDescriptor(), null, null);
            return;
        }
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 == null) {
            return;
        }
        KtObjectDeclaration companionObject = CollectionsKt.firstOrNull(this.myClass.getCompanionObjects());
        int properFieldVisibilityFlag = AsmUtil.getVisibilityAccessFlag(companionObjectDescriptor2);
        boolean deprecatedFieldForInvisibleCompanionObject = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.DeprecatedFieldForInvisibleCompanionObject);
        boolean properVisibilityForCompanionObjectInstanceField = this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField);
        boolean fieldShouldBeDeprecated = deprecatedFieldForInvisibleCompanionObject && !properVisibilityForCompanionObjectInstanceField && (properFieldVisibilityFlag & 6) != 0;
        boolean doNotGeneratePublic = properVisibilityForCompanionObjectInstanceField && (properFieldVisibilityFlag & 6) != 0;
        int fieldAccessFlags = doNotGeneratePublic ? 24 : 25;
        if (properVisibilityForCompanionObjectInstanceField) {
            fieldAccessFlags |= properFieldVisibilityFlag;
        }
        if (fieldShouldBeDeprecated) {
            fieldAccessFlags |= 0x20000;
        }
        StackValue.Field field2 = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
        FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin(companionObject == null ? this.myClass.getPsiOrParent() : companionObject), fieldAccessFlags, field2.name, field2.type.getDescriptor(), null, null);
        if (fieldShouldBeDeprecated) {
            AnnotationCodegen.forField(fv, this, this.typeMapper).visitAnnotation("Ljava/lang/Deprecated;", true).visitEnd();
        }
    }

    private void initializeObjects() {
        if (!DescriptorUtils.isObject(this.descriptor)) {
            return;
        }
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        boolean isNonCompanionObject = DescriptorUtils.isNonCompanionObject(this.descriptor);
        boolean isInterfaceCompanion = JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(this.descriptor);
        boolean isInterfaceCompanionWithBackingFieldsInOuter = ImplementationBodyCodegen.isInterfaceCompanionWithBackingFieldsInOuter(this.descriptor);
        boolean isMappedIntrinsicCompanionObject = JvmAbi.isMappedIntrinsicCompanionObject(this.descriptor);
        boolean isClassCompanionWithBackingFieldsInOuter = JvmAbi.isClassCompanionObjectWithBackingFieldsInOuter(this.descriptor);
        if (isNonCompanionObject || isInterfaceCompanion && !isInterfaceCompanionWithBackingFieldsInOuter || isMappedIntrinsicCompanionObject) {
            ExpressionCodegen clInitCodegen = this.createOrGetClInitCodegen();
            InstructionAdapter v2 = clInitCodegen.v;
            ImplementationBodyCodegen.markLineNumberForElement(((KtPureClassOrObject)this.element).getPsiOrParent(), v2);
            v2.anew(this.classAsmType);
            v2.dup();
            v2.invokespecial(this.classAsmType.getInternalName(), "<init>", "()V", false);
            int local0Index = clInitCodegen.getFrameMap().enterTemp(this.classAsmType);
            assert (local0Index == 0) : "Local variable with index 0 in clInit should be used only for singleton instance keeping";
            StackValue.Local local0 = StackValue.local(0, this.classAsmType);
            local0.store(StackValue.onStack(this.classAsmType), clInitCodegen.v);
            StackValue.Field singleton = StackValue.createSingletonViaInstance(this.descriptor, this.typeMapper, isInterfaceCompanion ? "$$INSTANCE" : "INSTANCE");
            singleton.store(local0, clInitCodegen.v);
            this.generateInitializers(clInitCodegen);
            if (isInterfaceCompanion) {
                StackValue.singleton(this.descriptor, this.typeMapper).store(singleton, this.getParentCodegen().createOrGetClInitCodegen().v, true);
            }
        } else if (isClassCompanionWithBackingFieldsInOuter || isInterfaceCompanionWithBackingFieldsInOuter) {
            ImplementationBodyCodegen parentCodegen = (ImplementationBodyCodegen)this.getParentCodegen();
            ExpressionCodegen parentClInitCodegen = parentCodegen.createOrGetClInitCodegen();
            InstructionAdapter parentVisitor = parentClInitCodegen.v;
            FunctionDescriptor constructor = (FunctionDescriptor)parentCodegen.context.accessibleDescriptor((CallableMemberDescriptor)CollectionsKt.single(this.descriptor.getConstructors()), null);
            parentCodegen.generateMethodCallTo(constructor, null, parentVisitor);
            StackValue instance = StackValue.onStack(parentCodegen.typeMapper.mapClass(this.descriptor));
            StackValue.singleton(this.descriptor, parentCodegen.typeMapper).store(instance, parentVisitor, true);
            this.generateInitializers(parentClInitCodegen);
        } else assert (false) : "Unknown object type: " + this.descriptor;
    }

    private static boolean isInterfaceCompanionWithBackingFieldsInOuter(@NotNull DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor interfaceClass = declarationDescriptor.getContainingDeclaration();
        if (!DescriptorUtils.isCompanionObject(declarationDescriptor) || !JvmCodegenUtil.isJvmInterface(interfaceClass)) {
            return false;
        }
        Collection<DeclarationDescriptor> descriptors = ((ClassDescriptor)declarationDescriptor).getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.ALL, MemberScope.Companion.getALL_NAME_FILTER());
        return CollectionsKt.any(descriptors, d -> d instanceof PropertyDescriptor && JvmAbi.hasJvmFieldAnnotation((PropertyDescriptor)d));
    }

    private void generateCompanionObjectBackingFieldCopies() {
        if (this.companionObjectPropertiesToCopy == null) {
            return;
        }
        for (PropertyAndDefaultValue info : this.companionObjectPropertiesToCopy) {
            PropertyDescriptor property = info.descriptor;
            Type type2 = this.typeMapper.mapType(property);
            int modifiers2 = 25;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.Synthetic(DescriptorToSourceUtils.descriptorToDeclaration(property), property), modifiers2, this.context.getFieldName(property, false), type2.getDescriptor(), this.typeMapper.mapFieldSignature(property.getType(), property), info.defaultValue);
            AnnotationCodegen.forField(fv, this, this.typeMapper).genAnnotations(property, type2);
            if (!this.state.getClassBuilderMode().generateBodies || info.defaultValue != null) continue;
            ExpressionCodegen codegen = this.createOrGetClInitCodegen();
            int companionObjectIndex = this.putCompanionObjectInLocalVar(codegen);
            StackValue.local(companionObjectIndex, AsmTypes.OBJECT_TYPE).put(AsmTypes.OBJECT_TYPE, codegen.v);
            this.copyFieldFromCompanionObject(property);
        }
    }

    private int putCompanionObjectInLocalVar(ExpressionCodegen codegen) {
        FrameMap frameMap = codegen.myFrameMap;
        ClassDescriptor companionObjectDescriptor2 = this.descriptor.getCompanionObjectDescriptor();
        int companionObjectIndex = frameMap.getIndex(companionObjectDescriptor2);
        if (companionObjectIndex == -1) {
            companionObjectIndex = frameMap.enter(companionObjectDescriptor2, AsmTypes.OBJECT_TYPE);
            StackValue.Field companionObject = StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            StackValue.local(companionObjectIndex, companionObject.type).store(companionObject, codegen.v);
        }
        return companionObjectIndex;
    }

    private void copyFieldFromCompanionObject(PropertyDescriptor propertyDescriptor) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor, false, null, StackValue.none());
        StackValue.Field field = StackValue.field(property.type, property.kotlinType, this.classAsmType, propertyDescriptor.getName().asString(), true, StackValue.none(), propertyDescriptor);
        field.store(property, codegen.v);
    }

    public void generateInitializers(@NotNull ExpressionCodegen codegen) {
        this.generateInitializers(() -> codegen);
    }

    private void lookupConstructorExpressionsInClosureIfPresent() {
        if (!this.state.getClassBuilderMode().generateBodies || this.descriptor.getConstructors().isEmpty()) {
            return;
        }
        KtVisitorVoid visitor2 = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement e) {
                e.acceptChildren(this);
            }

            @Override
            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expr) {
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expr);
                if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
                    this.lookupInContext(descriptor2);
                } else if (descriptor2 instanceof CallableMemberDescriptor) {
                    ResolvedCall<? extends CallableDescriptor> call2 = CallUtilKt.getResolvedCall(expr, ImplementationBodyCodegen.this.bindingContext);
                    if (call2 != null) {
                        this.lookupReceivers(call2);
                    }
                    if (call2 instanceof VariableAsFunctionResolvedCall) {
                        this.lookupReceivers(((VariableAsFunctionResolvedCall)((Object)call2)).getVariableCall());
                    }
                } else if (descriptor2 instanceof VariableDescriptor) {
                    ClassDescriptor classDescriptor2;
                    DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
                    if (containingDeclaration instanceof ConstructorDescriptor && (classDescriptor2 = ((ConstructorDescriptor)containingDeclaration).getConstructedClass()) == ImplementationBodyCodegen.this.descriptor) {
                        return;
                    }
                    this.lookupInContext(descriptor2);
                }
            }

            private void lookupReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> call2) {
                this.lookupReceiver(call2.getDispatchReceiver());
                this.lookupReceiver(call2.getExtensionReceiver());
            }

            private void lookupReceiver(@Nullable ReceiverValue value2) {
                if (value2 instanceof ImplicitReceiver) {
                    if (value2 instanceof ExtensionReceiver) {
                        ReceiverParameterDescriptor parameter = ((ExtensionReceiver)value2).getDeclarationDescriptor().getExtensionReceiverParameter();
                        assert (parameter != null) : "Extension receiver should exist: " + ((ExtensionReceiver)value2).getDeclarationDescriptor();
                        this.lookupInContext(parameter);
                    } else {
                        this.lookupInContext(((ImplicitReceiver)value2).getDeclarationDescriptor());
                    }
                }
            }

            private void lookupInContext(@NotNull DeclarationDescriptor toLookup) {
                ImplementationBodyCodegen.this.context.lookupInContext(toLookup, StackValue.LOCAL_0, ImplementationBodyCodegen.this.state, true);
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                ReceiverParameterDescriptor parameter;
                DeclarationDescriptor descriptor2 = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference());
                assert (descriptor2 instanceof CallableDescriptor || descriptor2 instanceof ClassDescriptor) : "'This' reference target should be class or callable descriptor but was " + descriptor2;
                if (descriptor2 instanceof ClassDescriptor) {
                    this.lookupInContext(descriptor2);
                }
                if (descriptor2 instanceof CallableDescriptor && (parameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter()) != null) {
                    this.lookupInContext(parameter);
                }
            }

            @Override
            public void visitSuperExpression(@NotNull KtSuperExpression expression2) {
                this.lookupInContext(ExpressionCodegen.getSuperCallLabelTarget(ImplementationBodyCodegen.this.context, expression2));
            }
        };
        for (KtDeclaration declaration : this.myClass.getDeclarations()) {
            if (declaration instanceof KtProperty) {
                KtProperty property = (KtProperty)declaration;
                KtExpression initializer2 = property.getDelegateExpressionOrInitializer();
                if (initializer2 == null) continue;
                initializer2.accept(visitor2);
                continue;
            }
            if (declaration instanceof KtAnonymousInitializer) {
                KtAnonymousInitializer initializer3 = (KtAnonymousInitializer)declaration;
                initializer3.accept(visitor2);
                continue;
            }
            if (!(declaration instanceof KtSecondaryConstructor)) continue;
            KtSecondaryConstructor constructor = (KtSecondaryConstructor)declaration;
            constructor.accept(visitor2);
        }
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (specifier instanceof KtDelegatedSuperTypeEntry) {
                KtExpression delegateExpression = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
                assert (delegateExpression != null);
                delegateExpression.accept(visitor2);
                continue;
            }
            if (!(specifier instanceof KtSuperTypeCallEntry)) continue;
            specifier.accept(visitor2);
        }
    }

    private void generateTraitMethods() {
        if (JvmCodegenUtil.isJvmInterface(this.descriptor)) {
            return;
        }
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getNonPrivateTraitMethods(this.descriptor).entrySet()) {
            FunctionDescriptor interfaceFun = entry.getKey();
            if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(interfaceFun) || JvmAnnotationUtilKt.hasJvmDefaultAnnotation(interfaceFun)) continue;
            this.generateDelegationToDefaultImpl(interfaceFun, entry.getValue());
        }
    }

    private void generateDelegationToDefaultImpl(final @NotNull FunctionDescriptor interfaceFun, final @NotNull FunctionDescriptor inheritedFun) {
        this.functionCodegen.generateMethod(new JvmDeclarationOrigin(JvmDeclarationOriginKind.CLASS_MEMBER_DELEGATION_TO_DEFAULT_IMPL, DescriptorToSourceUtils.descriptorToDeclaration(interfaceFun), interfaceFun), inheritedFun, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
                DeclarationDescriptor containingDeclaration = interfaceFun.getContainingDeclaration();
                if (!DescriptorUtils.isInterface(containingDeclaration)) {
                    return;
                }
                DeclarationDescriptor declarationInheritedFun = inheritedFun.getContainingDeclaration();
                PsiElement classForInheritedFun = DescriptorToSourceUtils.descriptorToDeclaration(declarationInheritedFun);
                if (classForInheritedFun instanceof KtDeclaration) {
                    codegen.markLineNumber((KtElement)classForInheritedFun, false);
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration;
                Type traitImplType = ImplementationBodyCodegen.this.typeMapper.mapDefaultImpls(containingTrait);
                FunctionDescriptor originalInterfaceFun = interfaceFun.getOriginal();
                Method traitMethod = ImplementationBodyCodegen.this.typeMapper.mapAsmMethod(originalInterfaceFun, OwnerKind.DEFAULT_IMPLS);
                Type[] argTypes = signature2.getAsmMethod().getArgumentTypes();
                Type[] originalArgTypes = traitMethod.getArgumentTypes();
                assert (originalArgTypes.length == argTypes.length + 1) : "Invalid trait implementation signature: " + signature2 + " vs " + traitMethod + " for " + interfaceFun;
                InstructionAdapter iv = codegen.v;
                iv.load(0, AsmTypes.OBJECT_TYPE);
                int reg = 1;
                for (int i = 0; i < argTypes.length; ++i) {
                    StackValue.local(reg, argTypes[i]).put(originalArgTypes[i + 1], iv);
                    reg += argTypes[i].getSize();
                }
                if (KotlinBuiltIns.isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType2 = signature2.getReturnType();
                StackValue.onStack(traitMethod.getReturnType(), originalInterfaceFun.getReturnType()).put(returnType2, iv);
                iv.areturn(returnType2);
            }
        });
    }

    private void generateEnumEntries() {
        if (this.descriptor.getKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        List<KtEnumEntry> enumEntries = CollectionsKt.filterIsInstance(((KtPureClassOrObject)this.element).getDeclarations(), KtEnumEntry.class);
        for (KtEnumEntry enumEntry : enumEntries) {
            ClassDescriptor descriptor2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
            int isDeprecated = KotlinBuiltIns.isDeprecated(descriptor2) ? 131072 : 0;
            FieldVisitor fv = this.v.newField(JvmDeclarationOriginKt.OtherOrigin(enumEntry, descriptor2), 0x4019 | isDeprecated, descriptor2.getName().asString(), this.classAsmType.getDescriptor(), null, null);
            AnnotationCodegen.forField(fv, this, this.typeMapper).genAnnotations(descriptor2, null);
        }
        this.initializeEnumConstants(enumEntries);
    }

    private void initializeEnumConstants(@NotNull List<KtEnumEntry> enumEntries) {
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        Type arrayAsmType = this.typeMapper.mapType(DescriptorUtilsKt.getBuiltIns(this.descriptor).getArrayType(Variance.INVARIANT, this.descriptor.getDefaultType()));
        this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.myClass), 4122, "$VALUES", arrayAsmType.getDescriptor(), null, null);
        iv.iconst(enumEntries.size());
        iv.newarray(this.classAsmType);
        if (!enumEntries.isEmpty()) {
            iv.dup();
            int size = enumEntries.size();
            for (int ordinal = 0; ordinal < size; ++ordinal) {
                this.initializeEnumConstant(enumEntries, ordinal);
            }
        }
        iv.putstatic(this.classAsmType.getInternalName(), "$VALUES", arrayAsmType.getDescriptor());
    }

    private void initializeEnumConstant(@NotNull List<KtEnumEntry> enumEntries, int ordinal) {
        ExpressionCodegen codegen = this.createOrGetClInitCodegen();
        InstructionAdapter iv = codegen.v;
        KtEnumEntry enumEntry = enumEntries.get(ordinal);
        iv.dup();
        iv.iconst(ordinal);
        ClassDescriptor classDescriptor2 = BindingContextUtils.getNotNull(this.bindingContext, BindingContext.CLASS, enumEntry);
        Type implClass = this.typeMapper.mapClass(classDescriptor2);
        iv.anew(implClass);
        iv.dup();
        iv.aconst(enumEntry.getName());
        iv.iconst(ordinal);
        List<KtSuperTypeListEntry> delegationSpecifiers = enumEntry.getSuperTypeListEntries();
        ResolvedCall<? extends CallableDescriptor> defaultArgumentsConstructorCall = CallUtilKt.getResolvedCall(enumEntry, this.bindingContext);
        boolean enumEntryHasSubclass = CodegenBinding.enumEntryNeedSubclass(this.bindingContext, classDescriptor2);
        if (delegationSpecifiers.size() == 1 && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, enumEntry)) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(delegationSpecifiers.get(0), this.bindingContext);
            CallableMethod method = this.typeMapper.mapToCallableMethod((ConstructorDescriptor)resolvedCall2.getResultingDescriptor(), false);
            codegen.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
        } else if (defaultArgumentsConstructorCall != null && !enumEntryHasSubclass) {
            codegen.invokeFunction(defaultArgumentsConstructorCall, StackValue.none()).put(Type.VOID_TYPE, iv);
        } else {
            iv.invokespecial(implClass.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        }
        iv.dup();
        iv.putstatic(this.classAsmType.getInternalName(), enumEntry.getName(), this.classAsmType.getDescriptor());
        iv.astore(AsmTypes.OBJECT_TYPE);
    }

    private void generateDelegates(DelegationFieldsInfo delegationFieldsInfo) {
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            DelegationFieldsInfo.Field field;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry) || (field = delegationFieldsInfo.getInfo((KtDelegatedSuperTypeEntry)specifier)) == null) continue;
            this.generateDelegateField(field);
            KtExpression delegateExpression = ((KtDelegatedSuperTypeEntry)specifier).getDelegateExpression();
            KotlinType delegateExpressionType = delegateExpression != null ? this.bindingContext.getType(delegateExpression) : null;
            ClassDescriptor superClass = JvmCodegenUtil.getSuperClass(specifier, this.state, this.bindingContext);
            if (superClass == null) continue;
            this.generateDelegates(superClass, delegateExpressionType, field);
        }
    }

    private void generateDelegateField(DelegationFieldsInfo.Field fieldInfo) {
        if (!fieldInfo.generateField) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4114, fieldInfo.name, fieldInfo.type.getDescriptor(), null, null);
    }

    private void generateDelegates(@NotNull ClassDescriptor toInterface, @Nullable KotlinType delegateExpressionType, @NotNull DelegationFieldsInfo.Field field) {
        for (Map.Entry<CallableMemberDescriptor, CallableMemberDescriptor> entry : DelegationResolver.Companion.getDelegates(this.descriptor, toInterface, delegateExpressionType).entrySet()) {
            CallableMemberDescriptor member = entry.getKey();
            CallableMemberDescriptor delegateTo = entry.getValue();
            if (member instanceof PropertyDescriptor) {
                this.propertyCodegen.genDelegate((PropertyDescriptor)member, (PropertyDescriptor)delegateTo, field.getStackValue());
                continue;
            }
            if (!(member instanceof FunctionDescriptor)) continue;
            this.functionCodegen.genDelegate((FunctionDescriptor)member, (FunctionDescriptor)delegateTo, field.getStackValue());
        }
    }

    public void addCompanionObjectPropertyToCopy(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
        if (this.companionObjectPropertiesToCopy == null) {
            this.companionObjectPropertiesToCopy = new ArrayList<PropertyAndDefaultValue>();
        }
        this.companionObjectPropertiesToCopy.add(new PropertyAndDefaultValue(descriptor2, defaultValue));
    }

    @Override
    protected void done() {
        for (Function2<ImplementationBodyCodegen, ClassBuilder, Unit> task : this.additionalTasks) {
            task.invoke(this, this.v);
        }
        super.done();
    }

    public void addAdditionalTask(Function2<ImplementationBodyCodegen, ClassBuilder, Unit> additionalTask) {
        this.additionalTasks.add(additionalTask);
    }

    static {
        for (JavaToKotlinClassMap.PlatformMutabilityMapping platformMutabilityMapping : JavaToKotlinClassMap.INSTANCE.getMutabilityMappings()) {
            KOTLIN_MARKER_INTERFACES.put(platformMutabilityMapping.getKotlinReadOnly().asSingleFqName(), "kotlin/jvm/internal/markers/KMappedMarker");
            ClassId mutableClassId = platformMutabilityMapping.getKotlinMutable();
            KOTLIN_MARKER_INTERFACES.put(mutableClassId.asSingleFqName(), "kotlin/jvm/internal/markers/K" + mutableClassId.getRelativeClassName().asString().replace("MutableEntry", "Entry").replace(".", "$"));
        }
    }

    private static class PropertyAndDefaultValue {
        public final PropertyDescriptor descriptor;
        public final Object defaultValue;

        public PropertyAndDefaultValue(@NotNull PropertyDescriptor descriptor2, Object defaultValue) {
            this.descriptor = descriptor2;
            this.defaultValue = defaultValue;
        }
    }

    private class DataClassMethodGeneratorImpl
    extends DataClassMethodGenerator {
        private final FunctionsFromAnyGeneratorImpl functionsFromAnyGenerator;

        DataClassMethodGeneratorImpl(KtClassOrObject klass2, BindingContext bindingContext) {
            super(klass2, bindingContext);
            this.functionsFromAnyGenerator = new FunctionsFromAnyGeneratorImpl(klass2, bindingContext, ImplementationBodyCodegen.this.descriptor, ImplementationBodyCodegen.this.classAsmType, ImplementationBodyCodegen.this.context, ImplementationBodyCodegen.this.v, ImplementationBodyCodegen.this.state);
        }

        @Override
        public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            this.functionsFromAnyGenerator.generateEqualsMethod(function2, properties2);
        }

        @Override
        public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            this.functionsFromAnyGenerator.generateHashCodeMethod(function2, properties2);
        }

        @Override
        public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> properties2) {
            this.functionsFromAnyGenerator.generateToStringMethod(function2, properties2);
        }

        @Override
        public void generateComponentFunction(@NotNull FunctionDescriptor function2, final @NotNull ValueParameterDescriptor parameter) {
            PsiElement originalElement = DescriptorToSourceUtils.descriptorToDeclaration(parameter);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(originalElement, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature2, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                    Type componentType = signature2.getReturnType();
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    if (!componentType.equals(Type.VOID_TYPE)) {
                        PropertyDescriptor property = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, DescriptorToSourceUtils.descriptorToDeclaration(parameter));
                        assert (property != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                        JvmKotlinType propertyType = ImplementationBodyCodegen.genPropertyOnStack(iv, context, property, ImplementationBodyCodegen.this.classAsmType, 0, ImplementationBodyCodegen.this.state);
                        StackValue.coerce(propertyType.getType(), componentType, iv);
                    }
                    iv.areturn(componentType);
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return false;
                }
            });
        }

        @Override
        public void generateCopyFunction(final @NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
            final Type thisDescriptorType = ImplementationBodyCodegen.this.typeMapper.mapType(ImplementationBodyCodegen.this.descriptor);
            ImplementationBodyCodegen.this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOriginFromPure(ImplementationBodyCodegen.this.myClass, function2), function2, new FunctionGenerationStrategy(){

                @Override
                public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature2, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                    InstructionAdapter iv = new InstructionAdapter(mv);
                    iv.anew(thisDescriptorType);
                    iv.dup();
                    ConstructorDescriptor constructor = ImplementationBodyCodegen.getPrimaryConstructorOfDataClass(ImplementationBodyCodegen.this.descriptor);
                    assert (function2.getValueParameters().size() == constructor.getValueParameters().size()) : "Number of parameters of copy function and constructor are different. Copy: " + function2.getValueParameters().size() + ", constructor: " + constructor.getValueParameters().size();
                    MutableClosure closure = ImplementationBodyCodegen.this.context.closure;
                    if (closure != null) {
                        this.pushCapturedFieldsOnStack(iv, closure);
                    }
                    int parameterIndex = 1;
                    for (ValueParameterDescriptor parameterDescriptor : function2.getValueParameters()) {
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(parameterDescriptor.getType());
                        iv.load(parameterIndex, type2);
                        parameterIndex += type2.getSize();
                    }
                    Method constructorAsmMethod = ImplementationBodyCodegen.this.typeMapper.mapAsmMethod(constructor);
                    iv.invokespecial(thisDescriptorType.getInternalName(), "<init>", constructorAsmMethod.getDescriptor(), false);
                    iv.areturn(thisDescriptorType);
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return false;
                }

                private void pushCapturedFieldsOnStack(InstructionAdapter iv, MutableClosure closure) {
                    KotlinType captureReceiver;
                    ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
                    if (captureThis != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type2 = ImplementationBodyCodegen.this.typeMapper.mapType(captureThis);
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), "this$0", type2.getDescriptor());
                    }
                    if ((captureReceiver = closure.getCapturedReceiverFromOuterContext()) != null) {
                        iv.load(0, ImplementationBodyCodegen.this.classAsmType);
                        Type type3 = ImplementationBodyCodegen.this.typeMapper.mapType(captureReceiver);
                        String fieldName = closure.getCapturedReceiverFieldName(ImplementationBodyCodegen.this.bindingContext, ImplementationBodyCodegen.this.state.getLanguageVersionSettings());
                        iv.getfield(ImplementationBodyCodegen.this.classAsmType.getInternalName(), fieldName, type3.getDescriptor());
                    }
                    for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closure.getCaptureVariables().entrySet()) {
                        DeclarationDescriptor declarationDescriptor = entry.getKey();
                        EnclosedValueDescriptor enclosedValueDescriptor = entry.getValue();
                        StackValue capturedValue = enclosedValueDescriptor.getInstanceValue();
                        Type sharedVarType = ImplementationBodyCodegen.this.typeMapper.getSharedVarType(declarationDescriptor);
                        if (sharedVarType == null) {
                            sharedVarType = ImplementationBodyCodegen.this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
                        }
                        capturedValue.put(sharedVarType, iv);
                    }
                }
            });
            ImplementationBodyCodegen.this.functionCodegen.generateDefaultIfNeeded(ImplementationBodyCodegen.this.context.intoFunction(function2), function2, OwnerKind.IMPLEMENTATION, (valueParameter, codegen) -> {
                assert (((ClassDescriptor)function2.getContainingDeclaration()).isData()) : "Function container must have [data] modifier: " + function2;
                PropertyDescriptor property = ImplementationBodyCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter);
                assert (property != null) : "Copy function doesn't correspond to any property: " + function2;
                return codegen.intermediateValueForProperty(property, false, null, StackValue.LOCAL_0);
            }, null);
        }
    }
}

