/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.MethodVerifier;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckCastEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.UninitializedStoresMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.StackPeepholeOptimizationsTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.CompositeMethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor;", "Lorg/jetbrains/kotlin/codegen/TransformationMethodVisitor;", "delegate", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "access", "", "name", "", "desc", "signature", "exceptions", "", "(Lorg/jetbrains/org/objectweb/asm/MethodVisitor;Lorg/jetbrains/kotlin/codegen/state/GenerationState;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "constructorCallNormalizationTransformer", "Lorg/jetbrains/kotlin/codegen/optimization/UninitializedStoresMethodTransformer;", "normalizationMethodTransformer", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "getNormalizationMethodTransformer", "()Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "optimizationTransformer", "getOptimizationTransformer", "performTransformations", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Companion", "backend"})
public final class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    private final UninitializedStoresMethodTransformer constructorCallNormalizationTransformer;
    @NotNull
    private final CompositeMethodTransformer normalizationMethodTransformer;
    @NotNull
    private final CompositeMethodTransformer optimizationTransformer;
    private final GenerationState generationState;
    private static final int MEMORY_LIMIT_BY_METHOD_MB = 50;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompositeMethodTransformer getNormalizationMethodTransformer() {
        return this.normalizationMethodTransformer;
    }

    @NotNull
    public final CompositeMethodTransformer getOptimizationTransformer() {
        return this.optimizationTransformer;
    }

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        this.normalizationMethodTransformer.transform("fake", methodNode);
        this.constructorCallNormalizationTransformer.transform("fake", methodNode);
        if (Companion.canBeOptimized(methodNode) && !this.generationState.getDisableOptimization()) {
            this.optimizationTransformer.transform("fake", methodNode);
        }
        UtilKt.prepareForEmitting(methodNode);
    }

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate2, @NotNull GenerationState generationState, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        Intrinsics.checkParameterIsNotNull(delegate2, "delegate");
        Intrinsics.checkParameterIsNotNull(generationState, "generationState");
        Intrinsics.checkParameterIsNotNull(name2, "name");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        super(delegate2, access, name2, desc, signature2, exceptions);
        this.generationState = generationState;
        this.constructorCallNormalizationTransformer = new UninitializedStoresMethodTransformer(this.generationState.getConstructorCallNormalizationMode());
        this.normalizationMethodTransformer = new CompositeMethodTransformer(new FixStackWithLabelNormalizationMethodTransformer(), new MethodVerifier("AFTER mandatory stack transformations"));
        this.optimizationTransformer = new CompositeMethodTransformer(new CapturedVarsOptimizationMethodTransformer(), new RedundantNullCheckMethodTransformer(this.generationState), new RedundantCheckCastEliminationMethodTransformer(), new ConstantConditionEliminationMethodTransformer(), new RedundantBoxingMethodTransformer(this.generationState), new StackPeepholeOptimizationsTransformer(), new PopBackwardPropagationTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantNopsCleanupMethodTransformer(), new MethodVerifier("AFTER optimizations"));
    }

    static {
        MEMORY_LIMIT_BY_METHOD_MB = 50;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$Companion;", "", "()V", "MEMORY_LIMIT_BY_METHOD_MB", "", "canBeOptimized", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "canBeOptimizedUsingSourceInterpreter", "backend"})
    public static final class Companion {
        public final boolean canBeOptimized(@NotNull MethodNode node) {
            Intrinsics.checkParameterIsNotNull(node, "node");
            int totalFramesSizeMb = node.instructions.size() * (node.maxLocals + node.maxStack) / 0x100000;
            return totalFramesSizeMb < MEMORY_LIMIT_BY_METHOD_MB;
        }

        public final boolean canBeOptimizedUsingSourceInterpreter(@NotNull MethodNode node) {
            Intrinsics.checkParameterIsNotNull(node, "node");
            int frameSize = node.maxLocals + node.maxStack;
            long methodSize = node.instructions.size();
            long totalFramesSizeMb = methodSize * methodSize * (long)frameSize / (long)0x100000;
            return totalFramesSizeMb < (long)MEMORY_LIMIT_BY_METHOD_MB;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

