/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;

public class CompilerConfiguration {
    public static CompilerConfiguration EMPTY = new CompilerConfiguration();
    private final Map<Key, Object> map = new LinkedHashMap<Key, Object>();
    private boolean readOnly = false;

    @Nullable
    public <T> T get(@NotNull CompilerConfigurationKey<T> key) {
        Object data2 = this.map.get(key.ideaKey);
        return (T)(data2 == null ? null : CompilerConfiguration.unmodifiable(data2));
    }

    @NotNull
    public <T> T get(@NotNull CompilerConfigurationKey<T> key, @NotNull T defaultValue) {
        T data2 = this.get(key);
        return data2 == null ? defaultValue : data2;
    }

    @NotNull
    public <T> T getNotNull(@NotNull CompilerConfigurationKey<T> key) {
        T data2 = this.get(key);
        assert (data2 != null) : "No value for configuration key: " + key;
        return data2;
    }

    public boolean getBoolean(@NotNull CompilerConfigurationKey<Boolean> key) {
        return this.get(key, false);
    }

    @NotNull
    public <T> List<T> getList(@NotNull CompilerConfigurationKey<List<T>> key) {
        List<T> data2 = this.get(key);
        return data2 == null ? Collections.emptyList() : data2;
    }

    @NotNull
    public <K, V> Map<K, V> getMap(@NotNull CompilerConfigurationKey<Map<K, V>> key) {
        Map<K, V> data2 = this.get(key);
        return data2 == null ? Collections.emptyMap() : data2;
    }

    public <T> void put(@NotNull CompilerConfigurationKey<T> key, @NotNull T value2) {
        this.checkReadOnly();
        this.map.put(key.ideaKey, value2);
    }

    public <T> void add(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull T value2) {
        this.checkReadOnly();
        Key ideaKey = key.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new ArrayList());
        List list2 = (List)this.map.get(ideaKey);
        list2.add(value2);
    }

    public <K, V> void put(@NotNull CompilerConfigurationKey<Map<K, V>> configurationKey, @NotNull K key, @NotNull V value2) {
        this.checkReadOnly();
        Key ideaKey = configurationKey.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new HashMap());
        Map data2 = (Map)this.map.get(ideaKey);
        data2.put(key, value2);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull Collection<T> values2) {
        this.addAll(key, this.getList(key).size(), values2);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, int index2, @NotNull Collection<T> values2) {
        this.checkReadOnly();
        CompilerConfiguration.checkForNullElements(values2);
        Key ideaKey = key.ideaKey;
        this.map.computeIfAbsent(ideaKey, k -> new ArrayList());
        List list2 = (List)this.map.get(ideaKey);
        list2.addAll(index2, values2);
    }

    public CompilerConfiguration copy() {
        CompilerConfiguration copy2 = new CompilerConfiguration();
        copy2.map.putAll(this.map);
        return copy2;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("CompilerConfiguration is read-only");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.readOnly = readOnly;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @NotNull
    private static <T> T unmodifiable(@NotNull T object) {
        if (object instanceof List) {
            return (T)Collections.unmodifiableList((List)object);
        }
        if (object instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)object);
        }
        if (object instanceof Set) {
            return (T)Collections.unmodifiableSet((Set)object);
        }
        if (object instanceof Collection) {
            return (T)Collections.unmodifiableCollection((Collection)object);
        }
        return object;
    }

    public String toString() {
        return this.map.toString();
    }

    private static <T> void checkForNullElements(Collection<T> values2) {
        int index2 = 0;
        for (T value2 : values2) {
            if (value2 == null) {
                throw new IllegalArgumentException("Element " + index2 + " is null, while null values in compiler configuration are not allowed");
            }
            ++index2;
        }
    }

    static {
        EMPTY.setReadOnly(true);
    }
}

