/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0000J \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "()V", "registrationMap", "Ljava/util/HashMap;", "Ljava/lang/reflect/Type;", "Lkotlin/collections/HashMap;", "addAll", "", "descriptors", "", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "other", "buildRegistrationMap", "Lcom/intellij/util/containers/MultiMap;", "tryGetEntry", "request", "container"})
public final class ComponentRegistry {
    private final HashMap<Type, Object> registrationMap;

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        MultiMap<Type, ComponentDescriptor> registrationMap = new MultiMap<Type, ComponentDescriptor>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue(registration, componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        MultiMap<Type, ComponentDescriptor> newRegistrationMap = this.buildRegistrationMap(descriptors);
        for (Map.Entry<Type, Collection<ComponentDescriptor>> entry : newRegistrationMap.entrySet()) {
            Object object;
            Map map2;
            Object oldEntries = this.registrationMap.get(entry.getKey());
            if (oldEntries != null || entry.getValue().size() > 1) {
                List list2 = new ArrayList();
                if (oldEntries instanceof Collection) {
                    list2.addAll((Collection)oldEntries);
                } else if (oldEntries != null) {
                    list2.add((ComponentDescriptor)oldEntries);
                }
                Collection<ComponentDescriptor> collection = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(collection, "entry.value");
                list2.addAll(collection);
                map2 = this.registrationMap;
                Intrinsics.checkExpressionValueIsNotNull(entry.getKey(), "entry.key");
                Object object2 = (ComponentDescriptor)CollectionsKt.singleOrNull(list2);
                if (object2 == null) {
                    object2 = list2;
                }
                ComponentDescriptor componentDescriptor = object2;
                map2.put(object, componentDescriptor);
                continue;
            }
            Map map3 = this.registrationMap;
            Intrinsics.checkExpressionValueIsNotNull(entry.getKey(), "entry.key");
            Collection<ComponentDescriptor> collection = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(collection, "entry.value");
            Intrinsics.checkExpressionValueIsNotNull(CollectionsKt.single((Iterable)collection), "entry.value.single()");
            map3.put(map2, object);
        }
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Collection collection;
        Object value2;
        Intrinsics.checkParameterIsNotNull(request, "request");
        Object object = value2 = this.registrationMap.get(request);
        if (object instanceof Collection) {
            Object object2 = value2;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.container.ComponentDescriptor>");
            }
            collection = (Collection)object2;
        } else if (object == null) {
            collection = CollectionsKt.emptyList();
        } else {
            Object object3 = value2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.container.ComponentDescriptor");
            }
            collection = CollectionsKt.listOf((ComponentDescriptor)object3);
        }
        return collection;
    }

    public final void addAll(@NotNull ComponentRegistry other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (!this.registrationMap.isEmpty()) {
            throw (Throwable)new IllegalStateException("Can only copy entries from another component registry into an empty component registry");
        }
        Map map2 = this.registrationMap;
        Map map3 = other.registrationMap;
        map2.putAll(map3);
    }

    public ComponentRegistry() {
        ComponentRegistry componentRegistry = this;
        HashMap hashMap = new HashMap();
        componentRegistry.registrationMap = hashMap;
    }
}

