/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.functors.AbstractReducingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0014J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH$J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H$\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/AbstractBinaryFunctor;", "Lorg/jetbrains/kotlin/contracts/model/functors/AbstractReducingFunctor;", "()V", "doInvocation", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "invokeWithArguments", "left", "right", "invokeWithConstant", "computation", "constant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "invokeWithReturningEffects", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "resolution"})
public abstract class AbstractBinaryFunctor
extends AbstractReducingFunctor {
    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        boolean bl2 = bl = arguments2.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Wrong size of arguments list for Binary functor: expected 2, got " + arguments2.size();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return this.invokeWithArguments(arguments2.get(0), arguments2.get(1));
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation left, @NotNull Computation right) {
        Collection collection;
        ESEffect it;
        Intrinsics.checkParameterIsNotNull(left, "left");
        Intrinsics.checkParameterIsNotNull(right, "right");
        if (left instanceof ESConstant) {
            return this.invokeWithConstant(right, (ESConstant)left);
        }
        if (right instanceof ESConstant) {
            return this.invokeWithConstant(left, (ESConstant)right);
        }
        List nonInterestingEffects = new ArrayList();
        List leftValueReturning = new ArrayList();
        List rightValueReturning = new ArrayList();
        Iterable $receiver$iv = left.getEffects();
        for (Object element$iv : $receiver$iv) {
            it = (ESEffect)element$iv;
            if (!(it instanceof ConditionalEffect) || !(((ConditionalEffect)it).getSimpleEffect() instanceof ESReturns) || Intrinsics.areEqual(((ESReturns)((ConditionalEffect)it).getSimpleEffect()).getValue(), ESConstant.Companion.getWILDCARD())) {
                collection = nonInterestingEffects;
                collection.add(it);
                continue;
            }
            collection = leftValueReturning;
            collection.add(it);
        }
        $receiver$iv = right.getEffects();
        for (Object element$iv : $receiver$iv) {
            it = (ESEffect)element$iv;
            if (!(it instanceof ConditionalEffect) || !(((ConditionalEffect)it).getSimpleEffect() instanceof ESReturns) || Intrinsics.areEqual(((ESReturns)((ConditionalEffect)it).getSimpleEffect()).getValue(), ESConstant.Companion.getWILDCARD())) {
                collection = nonInterestingEffects;
                collection.add(it);
                continue;
            }
            collection = rightValueReturning;
            collection.add(it);
        }
        List<ConditionalEffect> evaluatedByFunctor = this.invokeWithReturningEffects(leftValueReturning, rightValueReturning);
        return CollectionsKt.plus((Collection)nonInterestingEffects, (Iterable)evaluatedByFunctor);
    }

    @NotNull
    protected abstract List<ESEffect> invokeWithConstant(@NotNull Computation var1, @NotNull ESConstant var2);

    @NotNull
    protected abstract List<ConditionalEffect> invokeWithReturningEffects(@NotNull List<ConditionalEffect> var1, @NotNull List<ConditionalEffect> var2);
}

