/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantLabelRemoval;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "labelUsages", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "analyze", "", "apply", "perform", "statements", "", "name", "statement", "unuseLabel", "useLabel", "js.translator"})
public final class RedundantLabelRemoval {
    private final Map<JsName, Integer> labelUsages;
    private boolean hasChanges;
    private final JsStatement root;

    public final boolean apply() {
        this.analyze();
        this.perform();
        return this.hasChanges;
    }

    private final void analyze() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;

            public void endVisit(@NotNull JsBreak x, @NotNull JsContext<?> ctx) {
                block1: {
                    JsNameRef jsNameRef;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    super.endVisit(x, ctx);
                    JsNameRef jsNameRef2 = x.getLabel();
                    if (jsNameRef2 == null) break block1;
                    JsNameRef it = jsNameRef = jsNameRef2;
                    JsName jsName = it.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name!!");
                    RedundantLabelRemoval.access$useLabel(this.this$0, jsName);
                }
            }

            public void endVisit(@NotNull JsContinue x, @NotNull JsContext<?> ctx) {
                block1: {
                    JsNameRef jsNameRef;
                    Intrinsics.checkParameterIsNotNull(x, "x");
                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                    super.endVisit(x, ctx);
                    JsNameRef jsNameRef2 = x.getLabel();
                    if (jsNameRef2 == null) break block1;
                    JsNameRef it = jsNameRef = jsNameRef2;
                    JsName jsName = it.getName();
                    if (jsName == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "it.name!!");
                    RedundantLabelRemoval.access$useLabel(this.this$0, jsName);
                }
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ RedundantLabelRemoval this$0;

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement, "x.statement");
                    JsName jsName = x.getName();
                    Intrinsics.checkExpressionValueIsNotNull(jsName, "x.name");
                    x.setStatement(RedundantLabelRemoval.access$perform(this.this$0, jsStatement, jsName));
                    Integer n = (Integer)RedundantLabelRemoval.access$getLabelUsages$p(this.this$0).get(x.getName());
                    if ((n != null ? n : 0) == 0) {
                        RedundantLabelRemoval.access$setHasChanges$p(this.this$0, true);
                        ctx.replaceMe((JsNode)x.getStatement());
                    }
                }
                super.endVisit(x, ctx);
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
    }

    private final JsStatement perform(JsStatement statement2, JsName name2) {
        JsStatement jsStatement;
        JsStatement jsStatement2 = statement2;
        if (jsStatement2 instanceof JsBreak) {
            JsNameRef jsNameRef = ((JsBreak)statement2).getLabel();
            if (Intrinsics.areEqual(name2, jsNameRef != null ? jsNameRef.getName() : null)) {
                this.unuseLabel(name2);
                this.hasChanges = true;
                jsStatement = JsEmpty.INSTANCE;
            } else {
                jsStatement = statement2;
            }
        } else if (jsStatement2 instanceof JsLabel) {
            JsStatement jsStatement3 = ((JsLabel)statement2).getStatement();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement3, "statement.statement");
            this.perform(jsStatement3, name2);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "statement.statements");
            this.perform(list2, name2);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsIf) {
            JsStatement jsStatement4;
            JsIf jsIf = (JsIf)statement2;
            JsStatement jsStatement5 = ((JsIf)statement2).getThenStatement();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement5, "statement.thenStatement");
            jsIf.setThenStatement(this.perform(jsStatement5, name2));
            JsIf jsIf2 = (JsIf)statement2;
            JsStatement jsStatement6 = ((JsIf)statement2).getElseStatement();
            if (jsStatement6 != null) {
                JsStatement it;
                JsStatement jsStatement7 = jsStatement6;
                JsIf jsIf3 = jsIf2;
                JsStatement jsStatement8 = it = jsStatement7;
                Intrinsics.checkExpressionValueIsNotNull(jsStatement8, "it");
                JsStatement jsStatement9 = this.perform(jsStatement8, name2);
                jsIf2 = jsIf3;
                jsStatement4 = jsStatement9;
            } else {
                jsStatement4 = null;
            }
            jsIf2.setElseStatement(jsStatement4);
            jsStatement = statement2;
        } else if (jsStatement2 instanceof JsTry) {
            JsBlock jsBlock = ((JsTry)statement2).getTryBlock();
            Intrinsics.checkExpressionValueIsNotNull(jsBlock, "statement.tryBlock");
            this.perform(jsBlock, name2);
            jsStatement = statement2;
        } else {
            jsStatement = statement2;
        }
        return jsStatement;
    }

    private final void perform(List<JsStatement> statements, JsName name2) {
        block0: {
            JsStatement jsStatement;
            JsStatement jsStatement2 = CollectionsKt.lastOrNull(statements);
            if (jsStatement2 == null) break block0;
            JsStatement it = jsStatement = jsStatement2;
            statements.set(CollectionsKt.getLastIndex(statements), this.perform(it, name2));
        }
    }

    private final void useLabel(JsName name2) {
        Map<JsName, Integer> map2 = this.labelUsages;
        Integer n = this.labelUsages.get(name2);
        Integer n2 = (n != null ? n : 0) + 1;
        map2.put(name2, n2);
    }

    private final void unuseLabel(JsName name2) {
        Map<JsName, Integer> map2 = this.labelUsages;
        Integer n = this.labelUsages.get(name2);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        Integer n2 = ((Number)n).intValue() - 1;
        map2.put(name2, n2);
    }

    public RedundantLabelRemoval(@NotNull JsStatement root2) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(root2, "root");
        this.root = root2;
        RedundantLabelRemoval redundantLabelRemoval = this;
        redundantLabelRemoval.labelUsages = map2 = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ void access$useLabel(RedundantLabelRemoval $this, @NotNull JsName name2) {
        $this.useLabel(name2);
    }

    @NotNull
    public static final /* synthetic */ JsStatement access$perform(RedundantLabelRemoval $this, @NotNull JsStatement statement2, @NotNull JsName name2) {
        return $this.perform(statement2, name2);
    }

    @NotNull
    public static final /* synthetic */ Map access$getLabelUsages$p(RedundantLabelRemoval $this) {
        return $this.labelUsages;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(RedundantLabelRemoval $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(RedundantLabelRemoval $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

